/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.setup;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitBlock;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.playerprops.FavoriteDestinationsProperties;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import mcjty.rftoolsutility.playerprops.PropertiesDispatcher;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    private static List<Pair<TeleportDestination, PlayerEntity>> playersToTeleportHere = new ArrayList<Pair<TeleportDestination, PlayerEntity>>();

    public static void addPlayerToTeleportHere(TeleportDestination destination, PlayerEntity player) {
        playersToTeleportHere.add((Pair<TeleportDestination, PlayerEntity>)Pair.of((Object)destination, (Object)player));
    }

    private static void performDelayedTeleports() {
        if (!playersToTeleportHere.isEmpty()) {
            for (Pair<TeleportDestination, PlayerEntity> pair : playersToTeleportHere) {
                TeleportationTools.performTeleport((PlayerEntity)pair.getRight(), (TeleportDestination)pair.getLeft(), 0, 10, false);
            }
            playersToTeleportHere.clear();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.world.func_201675_m().func_186058_p().func_186068_a() == 0) {
            ForgeEventHandlers.performDelayedTeleports();
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.func_130014_f_().field_72995_K) {
            PlayerExtendedProperties.getBuffProperties(event.player).ifPresent(h -> h.tickBuffs((ServerPlayerEntity)event.player));
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !((Entity)event.getObject()).getCapability(PlayerExtendedProperties.BUFF_CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation("rftoolsutility", "properties"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        double blockReachDistance;
        BlockRayTraceResult rayTrace;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if ((heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof SmartWrench)) && (rayTrace = ForgeEventHandlers.rayTraceEyes((LivingEntity)player, (blockReachDistance = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e()) + 1.0)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            Block block = world.func_180495_p(rayTrace.func_216350_a()).func_177230_c();
            if (block instanceof ScreenBlock) {
                event.setCanceled(true);
                return;
            }
            if (block instanceof ScreenHitBlock) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @Nonnull
    public static BlockRayTraceResult rayTraceEyes(LivingEntity entity, double length) {
        Vec3d startPos = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vec3d endPos = startPos.func_178787_e(new Vec3d(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length));
        RayTraceContext context = new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity);
        return entity.field_70170_p.func_217299_a(context);
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        ItemStack heldItem;
        PlayerEntity player = event.getPlayer();
        if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            this.checkCreativeClick(event);
        } else if (event instanceof PlayerInteractEvent.RightClickBlock && player.func_225608_bj_() && ((heldItem = player.func_184614_ca()).func_190926_b() || !(heldItem.func_77973_b() instanceof SmartWrench))) {
            World world = event.getWorld();
            BlockState state = world.func_180495_p(event.getPos());
            Block block = state.func_177230_c();
        }
        heldItem = player.func_184586_b(event.getHand());
        if (heldItem.func_190926_b() || heldItem.func_77973_b() == null) {
            return;
        }
    }

    private void checkCreativeClick(PlayerInteractEvent event) {
        BlockState state;
        Block block;
        if (event.getPlayer().func_184812_l_() && ((block = (state = event.getWorld().func_180495_p(event.getPos())).func_177230_c()) == ScreenModule.SCREEN.get() || block == ScreenModule.CREATIVE_SCREEN.get() || block == ScreenModule.SCREEN_HIT.get()) && !event.getPlayer().func_225608_bj_()) {
            if (event.getWorld().field_72995_K) {
                block.func_196270_a(state, event.getWorld(), event.getPos(), event.getPlayer());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            PlayerExtendedProperties.getBuffProperties(player).ifPresent(h -> {});
        }
    }

    @SubscribeEvent
    public void onEntityTeleport(EnderTeleportEvent event) {
        World world = event.getEntity().func_130014_f_();
        int id = world.func_201675_m().func_186058_p().func_186068_a();
        Entity entity = event.getEntity();
        BlockPos coordinate = new BlockPos((int)entity.func_226277_ct_(), (int)entity.func_226278_cu_(), (int)entity.func_226281_cx_());
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        World world = event.getWorld().func_201672_e();
        int id = world.func_201675_m().func_186058_p().func_186068_a();
        Entity entity = event.getEntity();
        if (entity instanceof IMob) {
            BlockPos blockPos = new BlockPos((int)entity.func_226277_ct_(), (int)entity.func_226278_cu_(), (int)entity.func_226281_cx_());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerExtendedProperties.FAVORITE_DESTINATIONS_CAPABILITY).ifPresent(oldFavorites -> PlayerExtendedProperties.getFavoriteDestinations(event.getPlayer()).ifPresent(h -> h.copyFrom((FavoriteDestinationsProperties)oldFavorites)));
        }
    }
}

