/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.capability.templates;

import cofh.core.capability.CapabilityArchery;
import cofh.core.capability.IArcheryAmmoItem;
import cofh.core.util.helpers.ArcheryHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ArcheryAmmoItemWrapper
implements IArcheryAmmoItem,
ICapabilityProvider {
    private final LazyOptional<IArcheryAmmoItem> holder = LazyOptional.of(() -> this);
    final ItemStack ammoItem;

    public ArcheryAmmoItemWrapper(ItemStack ammoItem) {
        this.ammoItem = ammoItem;
    }

    @Override
    public void onArrowLoosed(PlayerEntity shooter) {
        this.ammoItem.func_190918_g(1);
    }

    @Override
    public AbstractArrowEntity createArrowEntity(World world, PlayerEntity shooter) {
        return ArcheryHelper.createDefaultArrow(world, this.ammoItem, shooter);
    }

    @Override
    public boolean isEmpty(PlayerEntity shooter) {
        return this.ammoItem.func_190926_b();
    }

    @Override
    public boolean isInfinite(ItemStack bow, PlayerEntity shooter) {
        return shooter != null && shooter.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0 && this.ammoItem.func_77973_b().getClass() == ArrowItem.class;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityArchery.AMMO_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

