/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.RenderHelper;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class ElementConditionalLayered
extends ElementBase {
    protected ArrayList<Pair<Supplier<TextureAtlasSprite>, BooleanSupplier>> conditionalTextures = new ArrayList();

    public ElementConditionalLayered(IGuiAccess gui) {
        super(gui);
    }

    public ElementConditionalLayered(IGuiAccess gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public ElementConditionalLayered addSprite(String location, BooleanSupplier condition) {
        return this.addSprite(new ResourceLocation(location), condition);
    }

    public ElementConditionalLayered addSprite(ResourceLocation location, BooleanSupplier condition) {
        return this.addSprite(() -> RenderHelper.getTexture(location), condition);
    }

    public ElementConditionalLayered addSprite(TextureAtlasSprite sprite, BooleanSupplier condition) {
        return this.addSprite(() -> sprite, condition);
    }

    public ElementConditionalLayered addSprite(Supplier<TextureAtlasSprite> sprite, BooleanSupplier condition) {
        this.conditionalTextures.add((Pair<Supplier<TextureAtlasSprite>, BooleanSupplier>)Pair.of(sprite, (Object)condition));
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        for (Pair<Supplier<TextureAtlasSprite>, BooleanSupplier> entry : this.conditionalTextures) {
            if (!((BooleanSupplier)entry.getRight()).getAsBoolean()) continue;
            this.gui.drawIcon((TextureAtlasSprite)((Supplier)entry.getLeft()).get(), this.posX(), this.posY());
        }
    }
}

