/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.datagen;

import cofh.core.registries.DeferredRegisterCoFH;
import cofh.core.util.FeatureManager;
import cofh.core.util.FeatureRecipeCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class RecipeProviderCoFH
extends RecipeProvider
implements IConditionBuilder {
    protected final String modid;

    public RecipeProviderCoFH(DataGenerator generatorIn, String modid) {
        super(generatorIn);
        this.modid = modid;
    }

    @SafeVarargs
    protected final Ingredient fromTags(Tag<Item> ... tagsIn) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(tagsIn.length);
        for (Tag<Item> tag : tagsIn) {
            ingredients.add(Ingredient.func_199805_a(tag));
        }
        return new CompoundIngredientCoFH(ingredients);
    }

    protected void generateStorageRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item storage, Item individual) {
        String storageName = storage.getRegistryName().func_110623_a();
        String individualName = individual.getRegistryName().func_110623_a();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)storage).func_200462_a(Character.valueOf('#'), (IItemProvider)individual).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200466_a(consumer, this.modid + ":storage/" + storageName);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)individual, (int)9).func_200487_b((IItemProvider)storage).func_200483_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200483_a("has_" + storageName, (ICriterionInstance)this.func_200403_a((IItemProvider)storage)).func_200484_a(consumer, this.modid + ":storage/" + individualName + "_from_block");
    }

    protected void generateStorageRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type) {
        Item block = reg.get(type + "_block");
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type);
        Item nugget = reg.get(type + "_nugget");
        if (block != null) {
            if (ingot != null) {
                this.generateStorageRecipes(reg, consumer, block, ingot);
            } else if (gem != null) {
                this.generateStorageRecipes(reg, consumer, block, gem);
            }
        }
        if (nugget != null) {
            String nuggetName = nugget.getRegistryName().func_110623_a();
            if (ingot != null) {
                this.generateStorageRecipes(reg, consumer, ingot, nugget);
                String ingotName = ingot.getRegistryName().func_110623_a();
                ShapedRecipeBuilder.func_200470_a((IItemProvider)ingot).func_200462_a(Character.valueOf('#'), (IItemProvider)nugget).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_at_least_9_" + nuggetName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)nugget)).func_200466_a(consumer, this.modid + ":storage/" + ingotName + "_from_nuggets");
                ShapelessRecipeBuilder.func_200488_a((IItemProvider)nugget, (int)9).func_200487_b((IItemProvider)ingot).func_200483_a("has_at_least_9_" + nuggetName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)nugget)).func_200483_a("has_" + ingotName, (ICriterionInstance)this.func_200403_a((IItemProvider)ingot)).func_200484_a(consumer, this.modid + ":storage/" + nuggetName + "_from_ingot");
            }
        }
        this.generateGearRecipe(reg, consumer, type);
    }

    protected void generateGearRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type) {
        Item gear = reg.get(type + "_gear");
        if (gear == null) {
            return;
        }
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type);
        Tag<Item> ingotTag = RecipeProviderCoFH.forgeTag("ingots/" + type);
        Tag<Item> gemTag = RecipeProviderCoFH.forgeTag("gems/" + type);
        if (ingot != null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), ingotTag).func_200469_a(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + ingot.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200409_a(ingotTag)).func_200466_a(consumer, this.modid + ":parts/" + gear.getRegistryName().func_110623_a());
        }
        if (gem != null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), gemTag).func_200469_a(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + gem.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200409_a(gemTag)).func_200466_a(consumer, this.modid + ":parts/" + gear.getRegistryName().func_110623_a());
        }
    }

    protected void generateGearRecipe(Consumer<IFinishedRecipe> consumer, Item gear, Item material, Tag<Item> tag) {
        if (gear == null || material == null || tag == null) {
            return;
        }
        ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), tag).func_200469_a(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + material.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200409_a(tag)).func_200466_a(consumer, this.modid + ":parts/" + gear.getRegistryName().func_110623_a());
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String material, float xp) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, material, xp, "smelting");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String material, float xp, String folder) {
        Item ore = reg.get(material + "_ore");
        Item ingot = reg.get(material + "_ingot");
        Item gem = reg.get(material);
        Item nugget = reg.get(material + "_nugget");
        Item dust = reg.get(material + "_dust");
        if (ingot != null) {
            if (dust != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, dust, ingot, 0.0f, folder, "_dust");
            }
            if (ore != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, ore, ingot, xp, folder, "_ore");
            }
        } else if (gem != null && ore != null) {
            this.generateSmeltingAndBlastingRecipes(reg, consumer, ore, gem, xp, folder, "_ore");
        }
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, input, output, xp, "", "");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String folder) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, input, output, xp, folder, "");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String folder, String type) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)200).func_218628_a("has_" + input.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + folder + "/" + output.getRegistryName().func_110623_a() + "_from" + type + "_smelting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)100).func_218628_a("has_" + input.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + folder + "/" + output.getRegistryName().func_110623_a() + "_from" + type + "_blasting");
    }

    public EnterBlockTrigger.Instance func_200407_a(Block blockIn) {
        return new EnterBlockTrigger.Instance(blockIn, StatePropertiesPredicate.field_227178_a_);
    }

    public InventoryChangeTrigger.Instance func_200403_a(IItemProvider itemIn) {
        return this.func_200405_a(ItemPredicate.Builder.func_200309_a().func_200308_a(itemIn).func_200310_b());
    }

    public InventoryChangeTrigger.Instance func_200409_a(Tag<Item> tagIn) {
        return this.func_200405_a(ItemPredicate.Builder.func_200309_a().func_200307_a(tagIn).func_200310_b());
    }

    public InventoryChangeTrigger.Instance func_200405_a(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }

    public InventoryChangeTrigger.Instance hasItem(MinMaxBounds.IntBound amount, IItemProvider itemIn) {
        return this.func_200405_a(new ItemPredicate(null, itemIn.func_199767_j(), amount, MinMaxBounds.IntBound.field_211347_e, EnchantmentPredicate.field_226534_b_, EnchantmentPredicate.field_226534_b_, null, NBTPredicate.field_193479_a));
    }

    protected static Tag<Item> forgeTag(String name) {
        return new ItemTags.Wrapper(new ResourceLocation("forge", name));
    }

    protected ICondition flagEnabled(FeatureManager manager, String flag) {
        return new FeatureRecipeCondition(manager, flag);
    }

    protected static class CompoundIngredientCoFH
    extends CompoundIngredient {
        public CompoundIngredientCoFH(List<Ingredient> children) {
            super(children);
        }
    }
}

