/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.energy;

import cofh.core.util.IResourceStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageCoFH
implements IEnergyStorage,
IResourceStorage,
INBTSerializable<CompoundNBT> {
    protected final int baseCapacity;
    protected final int baseReceive;
    protected final int baseExtract;
    protected int energy;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public EnergyStorageCoFH(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public EnergyStorageCoFH(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyStorageCoFH(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public EnergyStorageCoFH(int capacity, int maxReceive, int maxExtract, int energy) {
        this.baseCapacity = capacity;
        this.baseReceive = maxReceive;
        this.baseExtract = maxExtract;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0, Math.min(capacity, energy));
    }

    public EnergyStorageCoFH applyModifiers(float storageMod, float transferMod) {
        this.setCapacity(Math.round((float)this.baseCapacity * storageMod));
        this.setMaxReceive(Math.round((float)this.baseReceive * transferMod));
        this.setMaxExtract(Math.round((float)this.baseExtract * transferMod));
        return this;
    }

    public EnergyStorageCoFH setCapacity(int capacity) {
        this.capacity = capacity;
        this.energy = Math.max(0, Math.min(capacity, this.energy));
        return this;
    }

    public EnergyStorageCoFH setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public EnergyStorageCoFH setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public void setEnergyStored(int amount) {
        this.energy = amount;
        this.energy = Math.max(0, Math.min(this.capacity, this.energy));
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int receiveEnergyOverride(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergyOverride(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public EnergyStorageCoFH read(CompoundNBT nbt) {
        this.energy = nbt.func_74762_e("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.capacity <= 0 || this.energy <= 0) {
            return nbt;
        }
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    public CompoundNBT serializeNBT() {
        return this.write(new CompoundNBT());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.read(nbt);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    @Override
    public void modify(int amount) {
        this.energy += amount;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.energy <= 0 && this.capacity > 0;
    }

    @Override
    public int getCapacity() {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getStored() {
        return this.getEnergyStored();
    }

    @Override
    public String getUnit() {
        return "RF";
    }
}

