/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreConfig;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core")
public class CoreClientEvents {
    private CoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        String infoKey;
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (CoreConfig.enableItemDescriptions && StringHelper.canLocalize(infoKey = stack.func_77973_b().func_77667_c(stack) + ".desc")) {
            event.getToolTip().add(1, StringHelper.getInfoTextComponent(infoKey));
        }
        if (CoreConfig.enableEnchantmentDescriptions) {
            String enchKey;
            Enchantment ench;
            if (stack.func_77978_p() == null) {
                return;
            }
            ListNBT list = stack.func_77978_p().func_150295_c("StoredEnchantments", 10);
            if (list.size() == 1 && (ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)list.func_150305_b(0).func_74779_i("id")))) != null && ench.getRegistryName() != null && StringHelper.canLocalize(enchKey = ench.func_77320_a() + ".desc")) {
                event.getToolTip().add(StringHelper.getInfoTextComponent(enchKey));
            }
        }
    }
}

