/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ICoFHItem;
import cofh.core.util.constants.Constants;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArrowItemCoFH
extends ArrowItem
implements ICoFHItem {
    protected BooleanSupplier showEnchantEffect = Constants.TRUE;
    protected BooleanSupplier showInItemGroup = Constants.TRUE;
    protected Supplier<ItemGroup> displayGroup;
    protected final IArrowFactory<? extends AbstractArrowEntity> factory;
    protected boolean infinitySupport = false;

    public ArrowItemCoFH(IArrowFactory<? extends AbstractArrowEntity> factory, Item.Properties builder) {
        super(builder);
        this.factory = factory;
    }

    public ArrowItemCoFH setDisplayGroup(Supplier<ItemGroup> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    public ArrowItemCoFH setInfinitySupport(boolean infinitySupport) {
        this.infinitySupport = infinitySupport;
        return this;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInItemGroup.getAsBoolean()) {
            return;
        }
        super.func_150895_a(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.showEnchantEffect.getAsBoolean() && stack.func_77948_v();
    }

    protected boolean func_194125_a(ItemGroup group) {
        return group == ItemGroup.field_78027_g || this.getCreativeTabs().stream().anyMatch(tab -> tab == group);
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public AbstractArrowEntity func_200887_a(World worldIn, ItemStack stack, LivingEntity shooter) {
        return this.factory.createArrow(worldIn, shooter);
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, PlayerEntity player) {
        return this.infinitySupport && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0;
    }

    public static interface IArrowFactory<T extends AbstractArrowEntity> {
        public T createArrow(World var1, LivingEntity var2);
    }
}

