/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.fluid.FluidContainerItemWrapper;
import cofh.core.fluid.IFluidContainerItem;
import cofh.core.item.IColorableItem;
import cofh.core.item.ItemCoFH;
import cofh.core.util.Utils;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.core.util.references.CoreReferences;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidContainerItem
extends ItemCoFH
implements IFluidContainerItem,
IColorableItem {
    protected Predicate<FluidStack> validator;
    protected int fluidCapacity;

    public FluidContainerItem(Item.Properties builder, int fluidCapacity, Predicate<FluidStack> validator) {
        super(builder);
        this.fluidCapacity = fluidCapacity;
        this.validator = validator;
    }

    public FluidContainerItem(Item.Properties builder, int fluidCapacity) {
        this(builder, fluidCapacity, e -> true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add(StringHelper.getFluidName(fluid));
        }
        tooltip.add(this.isCreative(stack) ? StringHelper.getTextComponent("info.cofh.infinite_source") : StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + StringHelper.format(fluid.getAmount()) + " / " + StringHelper.format(this.getCapacity(stack)) + " mB"));
        if (FluidHelper.hasPotionTag(fluid)) {
            tooltip.add(StringHelper.getEmptyLine());
            tooltip.add(StringHelper.getTextComponent(StringHelper.localize("info.cofh.effects") + ":"));
            FluidHelper.addPotionTooltip(fluid, tooltip);
        }
    }

    public void addInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, List<EffectInstance> effects) {
        this.addInformation(stack, worldIn, tooltip, flagIn, effects, 1.0f);
    }

    public void addInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, List<EffectInstance> effects, float durationFactor) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add(StringHelper.getFluidName(fluid));
        }
        tooltip.add(this.isCreative(stack) ? StringHelper.getTextComponent("info.cofh.infinite_source") : StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + StringHelper.format(fluid.getAmount()) + " / " + StringHelper.format(this.getCapacity(stack)) + " mB"));
        if (FluidHelper.hasPotionTag(fluid)) {
            tooltip.add(StringHelper.getEmptyLine());
            tooltip.add(StringHelper.getTextComponent(StringHelper.localize("info.cofh.effects") + ":"));
            FluidHelper.addPotionTooltip(effects, tooltip, durationFactor);
        }
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid");
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid"));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative(stack) && this.getFluidAmount(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathHelper.clamp(1.0 - (double)this.getFluidAmount(stack) / (double)this.getCapacity(stack), 0.0, 1.0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidContainerItemWrapper(stack, this);
    }

    @Override
    public boolean isFluidValid(ItemStack container, FluidStack resource) {
        return this.validator.test(resource);
    }

    @Override
    public int getCapacity(ItemStack container) {
        int holding = EnchantmentHelper.func_77506_a((Enchantment)CoreReferences.HOLDING, (ItemStack)container);
        return Utils.getEnchantedCapacity(this.fluidCapacity, holding);
    }

    @Override
    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        CompoundNBT containerTag = container.func_196082_o();
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (this.isCreative(container)) {
            if (action.execute()) {
                CompoundNBT fluidTag = resource.writeToNBT(new CompoundNBT());
                fluidTag.func_74768_a("Amount", capacity - 1000);
                containerTag.func_218657_a("Fluid", (INBT)fluidTag);
            }
            return resource.getAmount();
        }
        if (action.simulate()) {
            if (!containerTag.func_74764_b("Fluid")) {
                return Math.min(capacity, resource.getAmount());
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)containerTag.func_74775_l("Fluid"));
            if (stack.isEmpty()) {
                return Math.min(capacity, resource.getAmount());
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.getAmount(), resource.getAmount());
        }
        if (!containerTag.func_74764_b("Fluid")) {
            CompoundNBT fluidTag = resource.writeToNBT(new CompoundNBT());
            if (capacity < resource.getAmount()) {
                fluidTag.func_74768_a("Amount", capacity);
                containerTag.func_218657_a("Fluid", (INBT)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.getAmount());
            containerTag.func_218657_a("Fluid", (INBT)fluidTag);
            return resource.getAmount();
        }
        CompoundNBT fluidTag = containerTag.func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTag);
        if (stack.isEmpty() || !stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.getAmount();
        if (resource.getAmount() < filled) {
            stack.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            stack.setAmount(capacity);
        }
        containerTag.func_218657_a("Fluid", (INBT)stack.writeToNBT(fluidTag));
        return filled;
    }

    @Override
    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        int drained;
        CompoundNBT containerTag = container.func_196082_o();
        if (!containerTag.func_74764_b("Fluid") || maxDrain == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)containerTag.func_74775_l("Fluid"));
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int n = drained = this.isCreative(container) ? maxDrain : Math.min(stack.getAmount(), maxDrain);
        if (action.execute() && !this.isCreative(container)) {
            if (maxDrain >= stack.getAmount()) {
                containerTag.func_82580_o("Fluid");
                return stack;
            }
            CompoundNBT fluidTag = containerTag.func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            containerTag.func_218657_a("Fluid", (INBT)fluidTag);
        }
        stack.setAmount(drained);
        return stack;
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            return this.getFluidAmount(stack) > 0 ? this.getFluid(stack).getFluid().getAttributes().getColor(this.getFluid(stack)) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }
}

