/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ICoFHItem;
import cofh.core.util.constants.Constants;
import java.util.function.BooleanSupplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCoFH
extends Item
implements ICoFHItem {
    protected BooleanSupplier showInGroups = Constants.TRUE;
    protected BooleanSupplier showEnchantEffect = Constants.TRUE;
    protected int burnTime = -1;
    protected int enchantability;

    public ItemCoFH(Item.Properties builder) {
        super(builder);
    }

    public ItemCoFH setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ItemCoFH setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public ItemCoFH setShowInGroups(BooleanSupplier showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.getAsBoolean()) {
            return;
        }
        super.func_150895_a(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.showEnchantEffect.getAsBoolean() && stack.func_77948_v();
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.enchantability > 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.enchantability;
    }

    public int getBurnTime(ItemStack itemStack) {
        return this.burnTime;
    }
}

