/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network;

import cofh.core.network.packet.IPacket;
import cofh.core.network.packet.IPacketClient;
import cofh.core.network.packet.IPacketServer;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.function.Supplier;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketHandler {
    private static final Logger LOG = LogManager.getLogger((String)"cofh.PacketHandler");
    private final ResourceLocation channelName;
    private final EventNetworkChannel channel;
    private final Byte2ObjectMap<Supplier<IPacket>> packets = new Byte2ObjectArrayMap(255);

    public PacketHandler(ResourceLocation channelName) {
        this.channelName = channelName;
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).networkProtocolVersion(() -> Integer.toString(1)).clientAcceptedVersions(e -> true).serverAcceptedVersions(e -> true).eventNetworkChannel();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.channel.registerObject((Object)new ClientHandler());
        }
        this.channel.registerObject((Object)new ServerHandler());
    }

    public <T extends IPacket> void registerPacket(int id, Supplier<? super T> constructor) {
        if (id <= 0 || id >= 255) {
            throw new IllegalArgumentException(String.format("Packet id(%s) not within bounds id <= 0 || id >= 255", id));
        }
        this.packets.put((byte)id, constructor);
        LOG.debug("Channel {}, Register packet, ID: {}", (Object)this.channelName, (Object)id);
    }

    public ResourceLocation getChannelName() {
        return this.channelName;
    }

    private class ServerHandler {
        private ServerHandler() {
        }

        @SubscribeEvent
        public void onPayload(NetworkEvent.ClientCustomPayloadEvent event) {
            PacketBuffer buf = new PacketBuffer((ByteBuf)event.getPayload());
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            ctx.setPacketHandled(true);
            byte id = (byte)buf.readUnsignedByte();
            Supplier supplier = (Supplier)PacketHandler.this.packets.get(id);
            if (supplier == null) {
                LOG.error("Received unregistered packet! ID: {}, Side: Server", (Object)id);
                return;
            }
            IPacket packet = (IPacket)supplier.get();
            if (!(packet instanceof IPacketServer)) {
                LOG.error("Received packet ID that isn't an IPacketServer? ID: {}", (Object)id);
                return;
            }
            INetHandler netHandler = ctx.getNetworkManager().func_150729_e();
            if (netHandler instanceof ServerPlayNetHandler) {
                ctx.enqueueWork(() -> {
                    packet.read(buf);
                    ((IPacketServer)packet).handleServer(((ServerPlayNetHandler)netHandler).field_147369_b);
                });
            }
        }
    }

    private class ClientHandler {
        private ClientHandler() {
        }

        @SubscribeEvent
        public void onPayload(NetworkEvent.ServerCustomPayloadEvent event) {
            PacketBuffer buf = new PacketBuffer((ByteBuf)event.getPayload());
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            ctx.setPacketHandled(true);
            byte id = (byte)buf.readUnsignedByte();
            Supplier supplier = (Supplier)PacketHandler.this.packets.get(id);
            if (supplier == null) {
                LOG.error("Received unregistered packet! ID: {}, Side: Client", (Object)id);
                return;
            }
            IPacket packet = (IPacket)supplier.get();
            if (!(packet instanceof IPacketClient)) {
                LOG.error("Received packet ID that isn't an IPacketClient? ID: {}", (Object)id);
                return;
            }
            ctx.enqueueWork(() -> {
                packet.read(buf);
                ((IPacketClient)packet).handleClient();
            });
        }
    }
}

