/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.util.FeatureManager;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class FeatureLootCondition
implements ILootCondition {
    private final FeatureManager manager;
    private final String flag;

    public FeatureLootCondition(FeatureManager manager, String flag) {
        this.manager = manager;
        this.flag = flag;
    }

    public boolean test(LootContext lootContext) {
        return this.manager.getFeature(this.flag).getAsBoolean();
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<FeatureLootCondition> {
        private final FeatureManager manager;

        public Serializer(FeatureManager manager, ResourceLocation location) {
            super(location, FeatureLootCondition.class);
            this.manager = manager;
        }

        public void serialize(@Nonnull JsonObject json, @Nonnull FeatureLootCondition value, @Nonnull JsonSerializationContext context) {
            json.addProperty("flag", value.flag);
        }

        @Nonnull
        public FeatureLootCondition deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
            return new FeatureLootCondition(this.manager, json.getAsJsonPrimitive("flag").getAsString());
        }
    }
}

