/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.util.RayTracer;
import cofh.core.util.references.EnsorcReferences;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class AreaEffectHelper {
    private AreaEffectHelper() {
    }

    public static boolean validAreaEffectItem(ItemStack stack) {
        return stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).isPresent() || stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof HoeItem;
    }

    public static boolean validAreaEffectMiningItem(ItemStack stack) {
        return stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).isPresent() || stack.func_77973_b() instanceof ToolItem;
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocks(ItemStack stack, BlockPos pos, PlayerEntity player) {
        int encExcavating = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.EXCAVATING, (ItemStack)stack);
        if (encExcavating > 0) {
            return AreaEffectHelper.getAreaEffectBlocksRadius(stack, pos, player, encExcavating);
        }
        int encTilling = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.TILLING, (ItemStack)stack);
        if (encTilling > 0) {
            return AreaEffectHelper.getAreaEffectBlocksHoeRadius(stack, pos, player, encTilling);
        }
        int encFurrowing = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.FURROWING, (ItemStack)stack);
        if (encFurrowing > 0) {
            return AreaEffectHelper.getAreaEffectBlocksHoeLine(stack, pos, player, encFurrowing * 2);
        }
        return ImmutableList.of();
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocksRadius(ItemStack stack, BlockPos pos, PlayerEntity player, int radius) {
        List area;
        World world = player.func_130014_f_();
        Item tool = stack.func_77973_b();
        BlockRayTraceResult traceResult = RayTracer.retrace(player, RayTraceContext.FluidMode.NONE);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS || player.func_226563_dT_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0) {
            return ImmutableList.of();
        }
        switch (traceResult.func_216354_b()) {
            case DOWN: 
            case UP: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, 0, -radius), (BlockPos)pos.func_177982_a(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::func_185334_h).collect(Collectors.toList());
                break;
            }
            case NORTH: 
            case SOUTH: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, -1, 0), (BlockPos)pos.func_177982_a(radius, 2 * radius - 1, 0)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::func_185334_h).collect(Collectors.toList());
                break;
            }
            default: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(0, -1, -radius), (BlockPos)pos.func_177982_a(0, 2 * radius - 1, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::func_185334_h).collect(Collectors.toList());
            }
        }
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocksDepth(ItemStack stack, BlockPos pos, PlayerEntity player, int radius, int depth) {
        List area;
        World world = player.func_130014_f_();
        Item tool = stack.func_77973_b();
        int depth_min = depth;
        int depth_max = 0;
        BlockRayTraceResult traceResult = RayTracer.retrace(player, RayTraceContext.FluidMode.NONE);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS || player.func_226563_dT_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0 && depth <= 0) {
            return ImmutableList.of();
        }
        switch (traceResult.func_216354_b()) {
            case DOWN: {
                depth_min = 0;
                depth_max = depth;
            }
            case UP: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, -depth_min, -radius), (BlockPos)pos.func_177982_a(radius, depth_max, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::func_185334_h).collect(Collectors.toList());
                break;
            }
            case NORTH: {
                depth_min = 0;
                depth_max = depth;
            }
            case SOUTH: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, -1, -depth_min), (BlockPos)pos.func_177982_a(radius, 2 * radius - 1, depth_max)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::func_185334_h).collect(Collectors.toList());
                break;
            }
            case WEST: {
                depth_min = 0;
                depth_max = depth;
            }
            default: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-depth_min, -1, -radius), (BlockPos)pos.func_177982_a(depth_max, 2 * radius - 1, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::func_185334_h).collect(Collectors.toList());
            }
        }
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocksLine(ItemStack stack, BlockPos pos, PlayerEntity player, int length) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        Item tool = stack.func_77973_b();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (player.func_226563_dT_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || length <= 0) {
            return ImmutableList.of();
        }
        switch (player.func_174811_aO()) {
            case SOUTH: {
                BlockPos query;
                for (int k = z + 1; k < z + length + 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, y, k)); ++k) {
                    area.add(query);
                }
                break;
            }
            case WEST: {
                BlockPos query;
                for (int i = x - 1; i > x - length - 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, z)); --i) {
                    area.add(query);
                }
                break;
            }
            case NORTH: {
                BlockPos query;
                for (int k = z - 1; k > z - length - 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, y, k)); --k) {
                    area.add(query);
                }
                break;
            }
            case EAST: {
                BlockPos query;
                for (int i = x + 1; i < x + length + 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, z)); ++i) {
                    area.add(query);
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocksHoeRadius(ItemStack stack, BlockPos pos, PlayerEntity player, int radius) {
        World world = player.func_130014_f_();
        boolean weeding = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.WEEDING, (ItemStack)stack) > 0;
        BlockRayTraceResult traceResult = RayTracer.retrace(player, RayTraceContext.FluidMode.NONE);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS || traceResult.func_216354_b() == Direction.DOWN || player.func_226563_dT_() || !AreaEffectHelper.canHoeAffect(world, pos, weeding) || radius <= 0) {
            return ImmutableList.of();
        }
        List area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, 0, -radius), (BlockPos)pos.func_177982_a(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocksHoeLine(ItemStack stack, BlockPos pos, PlayerEntity player, int length) {
        Object area;
        boolean weeding;
        World world = player.func_130014_f_();
        boolean bl = weeding = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.WEEDING, (ItemStack)stack) > 0;
        if (player.func_226563_dT_() || !AreaEffectHelper.canHoeAffect(world, pos, weeding) || length <= 0) {
            return ImmutableList.of();
        }
        switch (player.func_174811_aO()) {
            case SOUTH: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(0, 0, 1), (BlockPos)pos.func_177982_a(0, 0, length + 1)).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::func_185334_h).collect(Collectors.toList());
                break;
            }
            case WEST: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, 0), (BlockPos)pos.func_177982_a(-(length + 1), 0, 0)).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::func_185334_h).collect(Collectors.toList());
                break;
            }
            case NORTH: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(0, 0, -1), (BlockPos)pos.func_177982_a(0, 0, -(length + 1))).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::func_185334_h).collect(Collectors.toList());
                break;
            }
            case EAST: {
                area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(1, 0, 0), (BlockPos)pos.func_177982_a(length + 1, 0, 0)).filter(blockPos -> AreaEffectHelper.canHoeAffect(world, blockPos, weeding)).map(BlockPos::func_185334_h).collect(Collectors.toList());
                break;
            }
            default: {
                area = ImmutableList.of();
            }
        }
        area.remove(pos);
        return ImmutableList.copyOf((Collection)area);
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocksSickle(ItemStack stack, BlockPos pos, PlayerEntity player, int radius, int height) {
        World world = player.func_130014_f_();
        Item tool = stack.func_77973_b();
        if (player.func_226563_dT_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0 && height <= 0) {
            return ImmutableList.of();
        }
        List area = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, -height, -radius), (BlockPos)pos.func_177982_a(radius, height, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    private static boolean canToolAffect(Item toolItem, ItemStack toolStack, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_185887_b((IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        return toolItem.canHarvestBlock(toolStack, state) || state.func_185904_a().func_76229_l() && toolItem.func_150893_a(toolStack, state) > 1.0f;
    }

    private static boolean canHoeAffect(World world, BlockPos pos, boolean weeding) {
        BlockState state = world.func_180495_p(pos);
        if (HoeItem.field_195973_b.containsKey(state.func_177230_c())) {
            BlockPos up = pos.func_177984_a();
            BlockState stateUp = world.func_180495_p(up);
            return world.func_175623_d(up) || weeding && (stateUp.func_185904_a() == Material.field_151585_k || stateUp.func_185904_a() == Material.field_151582_l) && stateUp.func_185887_b((IBlockReader)world, up) <= 0.0f;
        }
        return false;
    }
}

