/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.item.IAugmentableItem;
import cofh.core.util.helpers.MathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class AugmentableHelper {
    private AugmentableHelper() {
    }

    public static boolean isAugmentableItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IAugmentableItem;
    }

    public static List<ItemStack> readAugmentsFromItem(ItemStack stack) {
        ListNBT augmentTag = AugmentableHelper.getAugmentNBT(stack);
        if (augmentTag.isEmpty()) {
            return Collections.emptyList();
        }
        return AugmentableHelper.getAugments(augmentTag);
    }

    public static void writeAugmentsToItem(ItemStack stack, List<ItemStack> augments) {
        AugmentableHelper.writeAugmentsToItem(stack, AugmentableHelper.convertAugments(augments));
    }

    public static List<ItemStack> getAugments(ItemStack augmentable) {
        return !AugmentableHelper.isAugmentableItem(augmentable) ? Collections.emptyList() : ((IAugmentableItem)augmentable.func_77973_b()).getAugments(augmentable);
    }

    public static int getAugmentSlots(ItemStack augmentable) {
        return !AugmentableHelper.isAugmentableItem(augmentable) ? 0 : MathHelper.clamp(((IAugmentableItem)augmentable.func_77973_b()).getAugmentSlots(augmentable), 0, 9);
    }

    public static boolean validAugment(ItemStack augmentable, ItemStack augment) {
        return AugmentableHelper.isAugmentableItem(augmentable) && ((IAugmentableItem)augmentable.func_77973_b()).validAugment(augmentable, augment);
    }

    public static void setAugments(ItemStack stack, List<ItemStack> augments) {
        if (!AugmentableHelper.isAugmentableItem(stack)) {
            return;
        }
        ((IAugmentableItem)stack.func_77973_b()).setAugments(stack, augments);
    }

    public static void getAttributeFromAugmentMax(CompoundNBT subTag, CompoundNBT augmentData, String attribute) {
        float mod = Math.max(AugmentableHelper.getAttributeMod(augmentData, attribute), AugmentableHelper.getAttributeMod(subTag, attribute));
        if (mod > 0.0f) {
            subTag.func_74776_a(attribute, mod);
        }
    }

    public static void getAttributeFromAugmentAdd(CompoundNBT subTag, CompoundNBT augmentData, String attribute) {
        float mod = AugmentableHelper.getAttributeMod(augmentData, attribute) + AugmentableHelper.getAttributeMod(subTag, attribute);
        subTag.func_74776_a(attribute, mod);
    }

    public static float getAttributeMod(CompoundNBT augmentData, String key) {
        return augmentData.func_74760_g(key);
    }

    public static float getAttributeModWithDefault(CompoundNBT augmentData, String key, float defaultValue) {
        return augmentData.func_74764_b(key) ? augmentData.func_74760_g(key) : defaultValue;
    }

    public static float getPropertyWithDefault(ItemStack container, String key, float defaultValue) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        return subTag == null ? defaultValue : AugmentableHelper.getAttributeModWithDefault(subTag, key, defaultValue);
    }

    private static void writeAugmentsToItem(ItemStack stack, ListNBT list) {
        CompoundNBT blockTag = stack.func_179543_a("BlockEntityTag");
        if (blockTag != null) {
            blockTag.func_218657_a("Augments", (INBT)list);
            return;
        }
        if (stack.func_77973_b() instanceof BlockItem) {
            blockTag = new CompoundNBT();
            blockTag.func_218657_a("Augments", (INBT)list);
            stack.func_77983_a("BlockEntityTag", (INBT)blockTag);
            return;
        }
        stack.func_77983_a("Augments", (INBT)list);
    }

    private static List<ItemStack> getAugments(ListNBT list) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            ret.add(ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i)));
        }
        return ret.isEmpty() ? Collections.emptyList() : ret;
    }

    private static ListNBT getAugmentNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return new ListNBT();
        }
        CompoundNBT blockTag = stack.func_179543_a("BlockEntityTag");
        if (blockTag != null) {
            return blockTag.func_74764_b("Augments") ? blockTag.func_150295_c("Augments", 10) : new ListNBT();
        }
        return stack.func_77978_p().func_150295_c("Augments", 10);
    }

    private static ListNBT convertAugments(List<ItemStack> augments) {
        ListNBT list = new ListNBT();
        for (ItemStack augment : augments) {
            list.add((Object)augment.func_77955_b(new CompoundNBT()));
        }
        return list;
    }
}

