/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.inventory.container.slot.SlotFalseCopy;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ItemHelper;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex, int endIndex) {
        if (stack.func_190926_b()) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (ItemHelper.itemsEqualWithTags(stack, inventory[i]) && inventory[i].func_77976_d() > inventory[i].func_190916_E()) {
                int hold = inventory[i].func_77976_d() - inventory[i].func_190916_E();
                if (hold >= stack.func_190916_E()) {
                    inventory[i].func_190917_f(stack.func_190916_E());
                    return true;
                }
                stack.func_190918_g(hold);
                inventory[i].func_190917_f(hold);
                continue;
            }
            if (!inventory[i].func_190926_b() || openSlot != -1) continue;
            openSlot = i;
        }
        if (openSlot <= -1) {
            return false;
        }
        inventory[openSlot] = stack;
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, startIndex, inventory.length - 1);
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, 0);
    }

    public static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate) {
        return InventoryHelper.insertStackIntoInventory(handler, stack, simulate, false);
    }

    public static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate, boolean forceEmptySlot) {
        return forceEmptySlot ? ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate) : ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack stackInSlot;
        Slot slot;
        int iterOrder;
        boolean successful = false;
        int i = reverseDirection ? endIndex - 1 : startIndex;
        int n = iterOrder = reverseDirection ? -1 : 1;
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                if (slot instanceof SlotFalseCopy) {
                    i += iterOrder;
                    continue;
                }
                stackInSlot = slot.func_75211_c();
                if (!stackInSlot.func_190926_b() && ItemHelper.itemsEqualWithTags(stackInSlot, stack)) {
                    int maxSize;
                    int size = stackInSlot.func_190916_E() + stack.func_190916_E();
                    if (size <= (maxSize = Math.min(stack.func_77976_d(), slot.func_75219_a()))) {
                        stack.func_190920_e(0);
                        stackInSlot.func_190920_e(size);
                        slot.func_75215_d(stackInSlot);
                        successful = true;
                    } else if (stackInSlot.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - stackInSlot.func_190916_E());
                        stackInSlot.func_190920_e(maxSize);
                        slot.func_75215_d(stackInSlot);
                        successful = true;
                    }
                }
                i += iterOrder;
            }
        }
        if (!stack.func_190926_b()) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                if (slot instanceof SlotFalseCopy) {
                    i += iterOrder;
                    continue;
                }
                stackInSlot = slot.func_75211_c();
                if (stackInSlot.func_190926_b() && slot.func_75214_a(stack)) {
                    int maxSize = Math.min(stack.func_77976_d(), slot.func_75219_a());
                    int splitSize = Math.min(maxSize, stack.func_190916_E());
                    slot.func_75215_d(stack.func_77979_a(splitSize));
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public static boolean extractFromAdjacent(TileEntity tile, ItemStorageCoFH slot, int amount, Direction side) {
        Direction opposite;
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        if (InventoryHelper.hasItemHandlerCap(adjTile, opposite = side.func_176734_d())) {
            IItemHandler handler = InventoryHelper.getItemHandlerCap(adjTile, opposite);
            if (handler == EmptyHandler.INSTANCE) {
                return false;
            }
            int initialAmount = amount;
            for (int i = 0; i < handler.getSlots() && amount > 0; ++i) {
                ItemStack ret;
                ItemStack query = handler.extractItem(i, amount, true);
                if (query.func_190926_b() || (ret = slot.insertItem(0, query, true)).func_190916_E() == query.func_190916_E()) continue;
                slot.insertItem(0, handler.extractItem(i, amount, false), false);
                amount -= query.func_190916_E() - ret.func_190916_E();
            }
            return amount != initialAmount;
        }
        return false;
    }

    public static boolean insertIntoAdjacent(TileEntity tile, ItemStorageCoFH slot, int amount, Direction side) {
        if (slot.isEmpty()) {
            return false;
        }
        ItemStack initialStack = slot.getItemStack().func_77946_l();
        initialStack.func_190920_e(Math.min(amount, initialStack.func_190916_E()));
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        Direction opposite = side.func_176734_d();
        if (InventoryHelper.hasItemHandlerCap(adjTile, opposite)) {
            ItemStack inserted = InventoryHelper.insertStackIntoInventory(InventoryHelper.getItemHandlerCap(adjTile, opposite), initialStack, false);
            if (inserted.func_190916_E() >= initialStack.func_190916_E()) {
                return false;
            }
            slot.modify(inserted.func_190916_E() - initialStack.func_190916_E());
            return true;
        }
        return false;
    }

    public static ItemStack addToInventory(TileEntity tile, Direction side, ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (InventoryHelper.hasItemHandlerCap(tile, side.func_176734_d())) {
            stack = InventoryHelper.insertStackIntoInventory(InventoryHelper.getItemHandlerCap(tile, side.func_176734_d()), stack, false);
        }
        return stack;
    }

    public static boolean hasItemHandlerCap(TileEntity tile, Direction face) {
        return tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent() || tile instanceof IInventory;
    }

    public static IItemHandler getItemHandlerCap(TileEntity tile, Direction face) {
        if (tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent()) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).orElse((Object)EmptyHandler.INSTANCE);
        }
        if (tile instanceof ISidedInventory && face != null) {
            return new SidedInvWrapper((ISidedInventory)tile, face);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return EmptyHandler.INSTANCE;
    }

    public static boolean isEmpty(ItemStack[] inventory) {
        for (ItemStack stack : inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

