/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.datagen;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.datagen.BaseBlockStateProvider;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.blocks.BlazingGeneratorTileEntity;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import mcjty.rftoolspower.modules.monitor.blocks.PowerMonitorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;

public class BlockStates
extends BaseBlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "rftoolspower", exFileHelper);
    }

    protected void registerStatesAndModels() {
        BlockModelBuilder dimCellFrame = (BlockModelBuilder)this.models().getBuilder("block/dimcell/main");
        this.createFrame(dimCellFrame, "#window", 1.0f);
        this.innerCube(dimCellFrame, "#window", 1.0f, 1.0f, 1.0f, 15.0f, 15.0f, 15.0f);
        dimCellFrame.texture("window", this.modLoc("block/dimcell/dimensionalcellwindows"));
        this.createDimensionalCellModel((Block)DimensionalCellModule.DIMENSIONAL_CELL.get(), "", dimCellFrame);
        this.createDimensionalCellModel((Block)DimensionalCellModule.DIMENSIONAL_CELL_SIMPLE.get(), "simple", dimCellFrame);
        this.createDimensionalCellModel((Block)DimensionalCellModule.DIMENSIONAL_CELL_ADVANCED.get(), "advanced", dimCellFrame);
        this.createDimensionalCellModel((Block)DimensionalCellModule.DIMENSIONAL_CELL_CREATIVE.get(), "creative", dimCellFrame);
        ModelFile[][] models = new ModelFile[][]{this.getLogicSlabModels("power_monitor0", this.modLoc("block/monitor/power_monitor0")), this.getLogicSlabModels("power_monitor1", this.modLoc("block/monitor/power_monitor1")), this.getLogicSlabModels("power_monitor2", this.modLoc("block/monitor/power_monitor2")), this.getLogicSlabModels("power_monitor3", this.modLoc("block/monitor/power_monitor3")), this.getLogicSlabModels("power_monitor4", this.modLoc("block/monitor/power_monitor4")), this.getLogicSlabModels("power_monitor5", this.modLoc("block/monitor/power_monitor5"))};
        this.variantBlock((Block)MonitorModule.POWER_MONITOR.get(), state -> models[(Integer)state.func_177229_b((IProperty)PowerMonitorTileEntity.LEVEL)][((LogicFacing)state.func_177229_b((IProperty)LogicSlabBlock.LOGIC_FACING)).getRotationStep()], state -> this.getXRotation(((LogicFacing)state.func_177229_b((IProperty)LogicSlabBlock.LOGIC_FACING)).getSide()), state -> this.getYRotation(((LogicFacing)state.func_177229_b((IProperty)LogicSlabBlock.LOGIC_FACING)).getSide()));
        this.logicSlabBlock((LogicSlabBlock)MonitorModule.POWER_LEVEL.get(), "power_level", this.modLoc("block/monitor/power_level"));
        this.logicSlabBlock((LogicSlabBlock)EndergenicModule.ENDER_MONITOR.get(), "ender_monitor", this.modLoc("block/endergenic/ender_monitor"));
        this.orientedBlock((Block)EndergenicModule.PEARL_INJECTOR.get(), this.frontBasedModel("pearl_injector", this.modLoc("block/endergenic/pearl_injector")));
        this.singleTextureBlock((Block)EndergenicModule.ENDERGENIC.get(), "endergenic", "block/endergenic/endergenic");
        this.registerBlazingGenerator();
        this.simpleBlock((Block)BlazingModule.BLAZING_AGITATOR.get(), (ModelFile)this.models().slab("blazing_agitator", this.modLoc("block/blazing/blazing_agitator_side"), new ResourceLocation("rftoolsbase", "block/base/machinebottom"), new ResourceLocation("rftoolsbase", "block/base/machinetop")));
        this.orientedBlock((Block)BlazingModule.BLAZING_INFUSER.get(), this.frontBasedModel("blazing_infuser", this.modLoc("block/blazing/blazing_infuser")));
    }

    private void registerBlazingGenerator() {
        ModelFile modelIdle = this.frontBasedModel("blazing_generator_idle", this.modLoc("block/blazing/blazing_generator_idle"));
        ModelFile modelBusy = this.frontBasedModel("blazing_generator_busy", this.modLoc("block/blazing/blazing_generator_busy"));
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)BlazingModule.BLAZING_GENERATOR.get());
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            this.applyRotation(builder.partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)direction).with((IProperty)BlazingGeneratorTileEntity.WORKING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelIdle), direction);
            this.applyRotation(builder.partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)direction).with((IProperty)BlazingGeneratorTileEntity.WORKING, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelBusy), direction);
        }
    }

    private void createDimensionalCellModel(Block block, String suffix, BlockModelBuilder dimCellFrame) {
        BlockModelBuilder singleNone = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/dimcell/singlenone" + suffix)).element().from(3.0f, 3.0f, 3.0f).to(13.0f, 13.0f, 13.0f).face(Direction.DOWN).texture("#single").end().end()).texture("single", this.modLoc("block/dimcell/dimensionalcell" + suffix));
        BlockModelBuilder singleIn = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/dimcell/singlein" + suffix)).element().from(3.0f, 3.0f, 3.0f).to(13.0f, 13.0f, 13.0f).face(Direction.DOWN).texture("#single").end().end()).texture("single", this.modLoc("block/dimcell/dimensionalcellin" + suffix));
        BlockModelBuilder singleOut = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/dimcell/singleout" + suffix)).element().from(3.0f, 3.0f, 3.0f).to(13.0f, 13.0f, 13.0f).face(Direction.DOWN).texture("#single").end().end()).texture("single", this.modLoc("block/dimcell/dimensionalcellout" + suffix));
        MultiPartBlockStateBuilder bld = this.getMultipartBuilder(block);
        bld.part().modelFile((ModelFile)dimCellFrame).addModel();
        BlockModelBuilder[] models = new BlockModelBuilder[]{singleNone, singleIn, singleOut};
        for (DimensionalCellTileEntity.Mode mode : DimensionalCellTileEntity.Mode.values()) {
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).addModel()).condition(DimensionalCellBlock.DOWN, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationX(180).addModel()).condition(DimensionalCellBlock.UP, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationX(90).addModel()).condition(DimensionalCellBlock.SOUTH, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationX(270).addModel()).condition(DimensionalCellBlock.NORTH, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationY(90).rotationX(90).addModel()).condition(DimensionalCellBlock.WEST, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationY(270).rotationX(90).addModel()).condition(DimensionalCellBlock.EAST, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
        }
    }
}

