/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.items;

import java.util.List;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolspower.setup.Registration;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class BlazingRod
extends Item {
    public static final float MAXTIME = 600.0f;
    public static final float START_QUALITY = 60000.0f;
    public static final float START_DURATION = 20.0f;
    public static final int MAX_INFUSION_STEPS = 64;
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"time", BlazingRod::isCharging, stack -> BlazingRod.getAgitationTimePercentage(stack) + "%"), TooltipBuilder.parameter((String)"infused", BlazingRod::isInfused, stack -> BlazingRod.getInfusionPercentage(stack) + "%"), TooltipBuilder.parameter((String)"power", stack -> BlazingRod.getRfPerTick(stack) + " RF/t"), TooltipBuilder.parameter((String)"duration", stack -> BlazingRod.getTotalTicks(stack) + " ticks")});

    public BlazingRod() {
        super(Registration.createStandardProperties());
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        super.func_77624_a(itemStack, world, list, flags);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), itemStack, list, flags);
    }

    public static boolean isCharging(ItemStack stack) {
        float left = BlazingRod.getAgitationTimeLeft(stack);
        return left > 0.0f;
    }

    public static boolean isInfused(ItemStack stack) {
        int left = BlazingRod.getInfusionStepsLeft(stack);
        return left < 64;
    }

    public static int getInfusionPercentage(ItemStack stack) {
        int left = BlazingRod.getInfusionStepsLeft(stack);
        return (64 - left) * 100 / 64;
    }

    public static int getInfusionStepsLeft(ItemStack stack) {
        return NBTTools.getInt((ItemStack)stack, (String)"infSteps", (int)64);
    }

    public static void setInfusionStepsLeft(ItemStack stack, int steps) {
        stack.func_196082_o().func_74768_a("infSteps", steps);
    }

    public static float getAgitationTimeLeft(ItemStack stack) {
        return NBTTools.getFloat((ItemStack)stack, (String)"time", (float)600.0f);
    }

    public static void setAgitationTimeLeft(ItemStack stack, float time) {
        stack.func_196082_o().func_74776_a("time", time);
    }

    public static int getAgitationTimePercentage(ItemStack stack) {
        float left = BlazingRod.getAgitationTimeLeft(stack);
        return (int)((600.0f - left) * 100.0f / 600.0f);
    }

    public static float getPowerQuality(ItemStack stack) {
        return NBTTools.getFloat((ItemStack)stack, (String)"quality", (float)60000.0f);
    }

    public static void setPowerQuality(ItemStack stack, float quality) {
        stack.func_196082_o().func_74776_a("quality", quality);
    }

    public static int getRfPerTick(ItemStack stack) {
        return (int)(BlazingRod.getPowerQuality(stack) / 1000.0f);
    }

    public static float getPowerDuration(ItemStack stack) {
        return NBTTools.getFloat((ItemStack)stack, (String)"duration", (float)20.0f);
    }

    public static void setPowerDuration(ItemStack stack, float duration) {
        stack.func_196082_o().func_74776_a("duration", duration);
    }

    public static int getTotalTicks(ItemStack stack) {
        return (int)BlazingRod.getPowerDuration(stack);
    }
}

