/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.blocks;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.modules.various.items.SmartWrenchItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellNetwork;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class DimensionalCellBlock
extends BaseBlock
implements INBTPreservingIngredient {
    public static final EnumProperty<DimensionalCellTileEntity.Mode> NORTH = EnumProperty.func_177709_a((String)"north", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> SOUTH = EnumProperty.func_177709_a((String)"south", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> WEST = EnumProperty.func_177709_a((String)"west", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> EAST = EnumProperty.func_177709_a((String)"east", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> UP = EnumProperty.func_177709_a((String)"up", DimensionalCellTileEntity.Mode.class);
    public static final EnumProperty<DimensionalCellTileEntity.Mode> DOWN = EnumProperty.func_177709_a((String)"down", DimensionalCellTileEntity.Mode.class);
    private final DimensionalCellType type;
    private static final VoxelShape RENDER_SHAPE = VoxelShapes.func_197873_a((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public boolean func_220081_d(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public DimensionalCellType getType() {
        return this.type;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return RENDER_SHAPE;
    }

    public static DimensionalCellType getType(Block block) {
        if (block instanceof DimensionalCellBlock) {
            return ((DimensionalCellBlock)block).getType();
        }
        return DimensionalCellType.UNKNOWN;
    }

    public DimensionalCellBlock(DimensionalCellType type, Supplier<TileEntity> supplier) {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).tileEntitySupplier(supplier).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powerstorage/dimensionalcell")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> {
            String energy = stack.func_77978_p() == null ? "0" : String.valueOf(DimensionalCellBlock.getEnergy(stack));
            String max = String.valueOf((Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * DimensionalCellBlock.getPowerFactor(type) / (Integer)DimensionalCellConfiguration.simpleFactor.get());
            return energy + " (max " + max + " RF/FE)";
        })}));
        this.type = type;
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.singleton("Info");
    }

    private static int getPowerFactor(DimensionalCellType type) {
        if (type.isSimple()) {
            return 1;
        }
        return type.isAdvanced() ? (Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get() : (Integer)DimensionalCellConfiguration.simpleFactor.get();
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, PlayerEntity player) {
        TileEntity te;
        SmartWrenchMode currentMode;
        if (!world.field_72995_K && (currentMode = SmartWrenchItem.getCurrentMode((ItemStack)player.func_184586_b(Hand.MAIN_HAND))) == SmartWrenchMode.MODE_SELECT && (te = world.func_175625_s(pos)) instanceof DimensionalCellTileEntity) {
            DimensionalCellTileEntity dimensionalCellTileEntity = (DimensionalCellTileEntity)te;
            DimensionalCellTileEntity.dumpNetwork(player, dimensionalCellTileEntity);
        }
        return true;
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof DimensionalCellTileEntity) {
            DimensionalCellTileEntity dimensionalCellTileEntity = (DimensionalCellTileEntity)te;
            dimensionalCellTileEntity.toggleMode(side);
        }
        return true;
    }

    private static int getEnergy(ItemStack stack) {
        return (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"energy", (Object)0);
    }

    private static void setEnergy(ItemStack stack, int energy) {
        NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74768_a, (String)"energy", (Object)energy);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        DimensionalCellTileEntity dimensionalCellTileEntity;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_77942_o() && !world.field_72995_K) {
            int networkId;
            DimensionalCellTileEntity dimensionalCellTileEntity2 = (DimensionalCellTileEntity)world.func_175625_s(pos);
            if (dimensionalCellTileEntity2 != null && (networkId = dimensionalCellTileEntity2.getNetworkId()) != -1) {
                int energy = DimensionalCellBlock.getEnergy(stack);
                DimensionalCellNetwork dimensionalCellNetwork = DimensionalCellNetwork.get(world);
                DimensionalCellNetwork.Network network = dimensionalCellNetwork.getChannel(networkId);
                network.receiveEnergy(energy);
                Block block = world.func_180495_p(pos).func_177230_c();
                network.add(world, dimensionalCellTileEntity2.getGlobalPos(), DimensionalCellBlock.getType(block));
                dimensionalCellNetwork.save();
                if (world.field_72995_K) {
                    // empty if block
                }
            }
        } else if (!stack.func_77942_o() && !world.field_72995_K && (dimensionalCellTileEntity = (DimensionalCellTileEntity)world.func_175625_s(pos)) != null && this.type.isCreative()) {
            dimensionalCellTileEntity.setAllOutput();
        }
        if (placer instanceof PlayerEntity) {
            // empty if block
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        DimensionalCellNetwork.Network network;
        TileEntity te;
        System.out.println("DimensionalCellBlock.getDrops");
        ServerWorld world = builder.func_216018_a();
        BlockPos pos = (BlockPos)builder.func_216019_b(LootParameters.field_216286_f);
        List drops = super.func_220076_a(state, builder);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof DimensionalCellTileEntity && (network = ((DimensionalCellTileEntity)te).getNetwork()) != null) {
            int energy = network.getEnergySingleBlock(this.getType());
            System.out.println("getDrops: energy = " + energy);
            if (!drops.isEmpty()) {
                DimensionalCellBlock.setEnergy((ItemStack)drops.get(0), energy);
            }
        }
        return drops;
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        DimensionalCellTileEntity cellTileEntity;
        DimensionalCellNetwork.Network network;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof DimensionalCellTileEntity && (network = (cellTileEntity = (DimensionalCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.type);
            Block block = world.func_180495_p(pos).func_177230_c();
            network.remove(world, cellTileEntity.getGlobalPos(), DimensionalCellBlock.getType(block));
            DimensionalCellNetwork.get(world).save();
            cellTileEntity.setNetworkId(-1);
        }
        super.func_180652_a(world, pos, explosion);
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        if (!world.field_72995_K && state.func_177230_c() != newstate.func_177230_c()) {
            DimensionalCellTileEntity cellTileEntity;
            DimensionalCellNetwork.Network network;
            System.out.println("DimensionalCellBlock.onReplaced");
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof DimensionalCellTileEntity && (network = (cellTileEntity = (DimensionalCellTileEntity)te).getNetwork()) != null) {
                int a = network.extractEnergySingleBlock(this.type);
                System.out.println("a = " + a);
                Block block = world.func_180495_p(pos).func_177230_c();
                network.remove(world, cellTileEntity.getGlobalPos(), DimensionalCellBlock.getType(block));
                DimensionalCellNetwork.get(world).save();
            }
        }
        super.func_196243_a(state, world, pos, newstate, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }
}

