/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.data.EnderMonitorMode;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EnderMonitorTileEntity
extends LogicTileEntity
implements ITickableTileEntity,
TickOrderHandler.IOrderTicker {
    public static final String CMD_MODE = "endermonitor.setMode";
    private EnderMonitorMode mode = EnderMonitorMode.MODE_LOSTPEARL;
    private boolean needpulse = false;
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Ender Monitor").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)EndergenicModule.CONTAINER_ENDER_MONITOR.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)));

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/endergenic")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(EnderMonitorTileEntity::new));
    }

    public EnderMonitorTileEntity() {
        super((TileEntityType)EndergenicModule.TYPE_ENDER_MONITOR.get());
    }

    public EnderMonitorMode getMode() {
        return this.mode;
    }

    public void setMode(EnderMonitorMode mode) {
        this.mode = mode;
        this.markDirtyClient();
    }

    public void fireFromEndergenic(EnderMonitorMode mode) {
        if (this.mode != mode) {
            return;
        }
        this.needpulse = true;
        this.markDirtyQuick();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
        }
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_2;
    }

    public void tickServer() {
        int newout = 0;
        if (this.needpulse) {
            this.markDirtyQuick();
            newout = 15;
            this.needpulse = false;
        }
        this.setRedstoneState(newout);
    }

    public DimensionId getDimension() {
        return DimensionId.fromWorld((World)this.field_145850_b);
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.needpulse = tagCompound.func_74767_n("needPulse");
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        int m = info.func_74762_e("mode");
        this.mode = EnderMonitorMode.values()[m];
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("needPulse", this.needpulse);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        this.getOrCreateInfo(tagCompound).func_74768_a("mode", this.mode.ordinal());
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = (String)params.get(ChoiceLabel.PARAM_CHOICE);
            this.setMode(EnderMonitorMode.getMode(m));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

