/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.network.PacketSendClientCommand;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.client.IHudSupport;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsbase.modules.hud.network.PacketGetHudLog;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.ClientCommandHandler;
import mcjty.rftoolspower.modules.endergenic.EndergenicConfiguration;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EnderMonitorTileEntity;
import mcjty.rftoolspower.modules.endergenic.client.GuiEndergenic;
import mcjty.rftoolspower.modules.endergenic.data.EnderMonitorMode;
import mcjty.rftoolspower.modules.endergenic.data.EndergenicPearl;
import mcjty.rftoolspower.setup.RFToolsPowerMessages;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

public class EndergenicTileEntity
extends GenericTileEntity
implements ITickableTileEntity,
IHudSupport,
TickOrderHandler.IOrderTicker {
    private static Random random = new Random();
    public static final String CMD_GETSTATS = "getStats";
    public static Key<Long> PARAM_STATRF = new Key("statrf", Type.LONG);
    public static Key<Integer> PARAM_STATLOST = new Key("statlost", Type.INTEGER);
    public static Key<Integer> PARAM_STATLAUNCHED = new Key("statlaunched", Type.INTEGER);
    public static Key<Integer> PARAM_STATOPPORTUNITIES = new Key("statopportunities", Type.INTEGER);
    public static final int CHARGE_IDLE = 0;
    public static final int CHARGE_HOLDING = -1;
    public static final Key<BlockPos> VALUE_DESTINATION = new Key("destination", Type.BLOCKPOS);
    public static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.002, (double)0.002, (double)0.002, (double)0.998, (double)0.998, (double)0.998);
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)EndergenicConfiguration.MAXENERGY.get()).intValue(), 0L);
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<IMachineInformation> infoHandler = LazyOptional.of(this::createMachineInfo);
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> this.infusable);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Endergenic").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)EndergenicModule.CONTAINER_ENDERGENIC.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)).energyHandler(() -> this.energyStorage));
    private int chargingMode = 0;
    private int currentAge = 0;
    private BlockPos destination = null;
    private int distance = 0;
    private boolean prevIn = false;
    private long rfGained = 0L;
    private long rfLost = 0L;
    private int pearlsLaunched = 0;
    private int pearlsLost = 0;
    private int chargeCounter = 0;
    private int pearlArrivedAt = -2;
    private int ticks = 100;
    private long lastRfPerTick = 0L;
    private long lastRfGained = 0L;
    private long lastRfLost = 0L;
    private int lastPearlsLost = 0;
    private int lastPearlsLaunched = 0;
    private int lastChargeCounter = 0;
    private int lastPearlArrivedAt = 0;
    private String lastPearlsLostReason = "";
    private List<EndergenicPearl> pearls = new ArrayList<EndergenicPearl>();
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    private int badCounter = 0;
    private int goodCounter = 0;
    private static long[] rfPerHit = new long[]{0L, 100L, 150L, 200L, 400L, 800L, 1600L, 3200L, 6400L, 8000L, 12800L, 8000L, 6400L, 2500L, 1000L, 100L};
    private int tickCounter = 0;
    private long ticker = -1L;
    public static final Direction[] HORIZ_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_DESTINATION, this::getDestination, this::setDestination)};
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/endergenic")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(EndergenicTileEntity::new)){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    public EndergenicTileEntity() {
        super((TileEntityType)EndergenicModule.TYPE_ENDERGENIC.get());
    }

    public void func_73660_a() {
        if (this.badCounter > 0) {
            --this.badCounter;
            this.markDirtyQuick();
        }
        if (this.goodCounter > 0) {
            --this.goodCounter;
            this.markDirtyQuick();
        }
    }

    public long getTicker() {
        return this.ticker;
    }

    public void setTicker(long ticker) {
        this.ticker = ticker;
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_1;
    }

    public Direction getBlockOrientation() {
        return null;
    }

    public boolean isBlockAboveAir() {
        return this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a());
    }

    public List<String> getHudLog() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.BLUE + "Last 5 seconds:");
        list.add("    Charged: " + this.getLastChargeCounter());
        list.add("    Fired: " + this.getLastPearlsLaunched());
        list.add("    Lost: " + this.getLastPearlsLost());
        if (this.getLastPearlsLost() > 0) {
            list.add(TextFormatting.RED + "    " + this.getLastPearlsLostReason());
        }
        if (this.getLastPearlArrivedAt() > -2) {
            list.add("    Last pearl at " + this.getLastPearlArrivedAt());
        }
        list.add(TextFormatting.BLUE + "Power:");
        list.add(TextFormatting.GREEN + "    RF Gain " + this.getLastRfGained());
        list.add(TextFormatting.RED + "    RF Lost " + this.getLastRfLost());
        list.add(TextFormatting.GREEN + "    RF/t " + this.getLastRfPerTick());
        return list;
    }

    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    public int getBadCounter() {
        return this.badCounter;
    }

    public long getLastRfPerTick() {
        return this.lastRfPerTick;
    }

    public long getLastRfGained() {
        return this.lastRfGained;
    }

    public long getLastRfLost() {
        return this.lastRfLost;
    }

    public int getLastPearlsLost() {
        return this.lastPearlsLost;
    }

    public int getLastPearlsLaunched() {
        return this.lastPearlsLaunched;
    }

    public int getLastChargeCounter() {
        return this.lastChargeCounter;
    }

    public int getLastPearlArrivedAt() {
        return this.lastPearlArrivedAt;
    }

    public String getLastPearlsLostReason() {
        return this.lastPearlsLostReason;
    }

    public int getGoodCounter() {
        return this.goodCounter;
    }

    public void tickServer() {
        ++this.tickCounter;
        --this.ticks;
        if (this.ticks < 0) {
            this.lastRfGained = this.rfGained;
            this.lastRfLost = this.rfLost;
            this.lastRfPerTick = (this.rfGained - this.rfLost) / 100L;
            this.lastPearlsLost = this.pearlsLost;
            this.lastPearlsLaunched = this.pearlsLaunched;
            this.lastChargeCounter = this.chargeCounter;
            this.lastPearlArrivedAt = this.pearlArrivedAt;
            this.ticks = 100;
            this.rfGained = 0L;
            this.rfLost = 0L;
            this.pearlsLaunched = 0;
            this.pearlsLost = 0;
            this.chargeCounter = 0;
            this.pearlArrivedAt = -2;
        }
        this.handlePearls();
        this.handleSendingEnergy();
        if (this.chargingMode == -1 && random.nextInt(1000) <= (Integer)EndergenicConfiguration.chanceLost.get()) {
            this.log("Server Tick: discard pearl randomly");
            this.discardPearl("Random pearl discard");
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            if (this.chargingMode == 0) {
                this.log("Server Tick: pulse -> start charging");
                this.startCharging();
                return;
            }
            if (this.chargingMode == -1) {
                this.log("Server Tick: pulse -> fire pearl");
                this.firePearl();
                return;
            }
        }
        if (this.chargingMode == 0) {
            return;
        }
        if (this.chargingMode == -1) {
            long rf = ((Integer)EndergenicConfiguration.rfToHoldPearl.get()).intValue();
            rf = (long)((float)rf * (3.0f - this.infusable.getInfusedFactor()) / 3.0f);
            long rfStored = this.energyStorage.getEnergy();
            if (rfStored < rf) {
                this.log("Server Tick: insufficient energy to hold pearl (" + rfStored + " vs " + rf + ")");
                this.discardPearl("Not enough energy to hold pearl");
            } else {
                long rfExtracted = this.energyStorage.extractEnergy((int)rf, false);
                this.log("Server Tick: holding pearl, consume " + rfExtracted + " RF");
                this.rfLost += rfExtracted;
            }
            return;
        }
        this.markDirtyQuick();
        ++this.chargingMode;
        if (this.chargingMode >= 16) {
            this.log("Server Tick: charging mode ends -> idle");
            this.chargingMode = 0;
        }
    }

    public DimensionId getDimension() {
        return DimensionId.fromWorld((World)this.field_145850_b);
    }

    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"rftick", "lost", "launched", "opportunities"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"Average RF/tick for the last 5 seconds", "Amount of pearls that were lost during the last 5 seconds", "Amount of pearls that were launched during the last 5 seconds", "Number of opportunities for the last 5 seconds"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                switch (index) {
                    case 0: {
                        return Long.toString(EndergenicTileEntity.this.lastRfPerTick);
                    }
                    case 1: {
                        return Integer.toString(EndergenicTileEntity.this.lastPearlsLost);
                    }
                    case 2: {
                        return Integer.toString(EndergenicTileEntity.this.lastPearlsLaunched);
                    }
                    case 3: {
                        return Integer.toString(EndergenicTileEntity.this.lastChargeCounter);
                    }
                }
                return null;
            }
        };
    }

    private void log(String message) {
    }

    public void modifyEnergyStored(long e) {
        long energy;
        long capacity = this.energyStorage.getCapacity();
        if (e > capacity - (energy = this.energyStorage.getEnergy())) {
            e = capacity - energy;
        } else if (e < -energy) {
            e = -energy;
        }
        this.energyStorage.setEnergy(energy += e);
    }

    private void fireMonitors(EnderMonitorMode mode) {
        BlockPos pos = this.func_174877_v();
        for (Direction dir : OrientationTools.DIRECTION_VALUES) {
            EnderMonitorTileEntity enderMonitorTileEntity;
            Direction inputSide;
            BlockPos c = pos.func_177972_a(dir);
            TileEntity te = this.field_145850_b.func_175625_s(c);
            if (!(te instanceof EnderMonitorTileEntity) || (inputSide = (enderMonitorTileEntity = (EnderMonitorTileEntity)te).getFacing(this.field_145850_b.func_180495_p(c)).getInputSide()) != dir.func_176734_d()) continue;
            enderMonitorTileEntity.fireFromEndergenic(mode);
        }
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy() - (long)((Integer)EndergenicConfiguration.ENDERGENIC_KEEPRF.get()).intValue();
        if (storedPower <= 0L) {
            return;
        }
        EnergyTools.handleSendingEnergy((World)this.field_145850_b, (BlockPos)this.field_174879_c, (long)storedPower, (long)((Integer)EndergenicConfiguration.ENDERGENIC_SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    private void handlePearls() {
        if (this.pearls.isEmpty()) {
            return;
        }
        ArrayList<EndergenicPearl> newlist = new ArrayList<EndergenicPearl>();
        for (EndergenicPearl pearl : this.pearls) {
            this.log("Pearls: age=" + pearl.getAge() + ", ticks left=" + pearl.getTicksLeft());
            if (pearl.handleTick(this.field_145850_b)) continue;
            newlist.add(pearl);
        }
        this.pearls = newlist;
    }

    private void markDirtyClientNoRender() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175647_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(32.0), p -> this.field_174879_c.func_218140_a(p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_(), true) < 1024.0).stream().forEach(p -> RFToolsPowerMessages.INSTANCE.sendTo((Object)new PacketSendClientCommand("rftoolspower", "flashEndergenic", TypedMap.builder().put(ClientCommandHandler.PARAM_POS, (Object)this.func_174877_v()).put(ClientCommandHandler.PARAM_GOODCOUNTER, (Object)this.goodCounter).put(ClientCommandHandler.PARAM_BADCOUNTER, (Object)this.badCounter).build()), ((ServerPlayerEntity)p).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    public void syncCountersFromServer(int goodCounter, int badCounter) {
        this.goodCounter = goodCounter;
        this.badCounter = badCounter;
    }

    private void discardPearl(String reason) {
        this.badCounter = 20;
        this.markDirtyClientNoRender();
        ++this.pearlsLost;
        this.lastPearlsLostReason = reason;
        this.chargingMode = 0;
        this.fireMonitors(EnderMonitorMode.MODE_LOSTPEARL);
    }

    public EndergenicTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.destination);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        this.destination = null;
        this.markDirtyClient();
        return null;
    }

    public void firePearl() {
        this.markDirtyQuick();
        this.getDestinationTE();
        if (this.destination == null) {
            this.log("Fire Pearl: pearl lost due to lack of destination");
            this.discardPearl("Missing destination");
        } else {
            this.log("Fire Pearl: pearl is launched to " + this.destination.func_177958_n() + "," + this.destination.func_177956_o() + "," + this.destination.func_177952_p());
            this.chargingMode = 0;
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, this.currentAge + 1));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void firePearlFromInjector() {
        this.markDirtyQuick();
        this.getDestinationTE();
        this.chargingMode = 0;
        if (this.destination == null) {
            this.log("Fire Pearl from injector: pearl lost due to lack of destination");
            this.discardPearl("Missing destination");
        } else {
            this.log("Fire Pearl from injector: pearl is launched to " + this.destination.func_177958_n() + "," + this.destination.func_177956_o() + "," + this.destination.func_177952_p());
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, 0));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void receivePearl(int age) {
        this.fireMonitors(EnderMonitorMode.MODE_PEARLARRIVED);
        this.markDirtyQuick();
        if (this.chargingMode == -1) {
            this.log("Receive Pearl: pearl arrives but already holding -> both are lost");
            this.discardPearl("Pearl arrived while holding");
        } else if (this.chargingMode == 0) {
            this.log("Receive Pearl: pearl arrives but generator is idle -> pearl is lost");
            this.discardPearl("Pearl arrived while idle");
        } else {
            this.pearlArrivedAt = this.chargingMode;
            long rf = (long)((double)rfPerHit[this.chargingMode] * (Double)EndergenicConfiguration.powergenFactor.get());
            rf = (long)((float)rf * (this.infusable.getInfusedFactor() + 2.0f) / 2.0f);
            int a = age * 5;
            if (a > 100) {
                a = 100;
            }
            rf += rf * (long)a / 100L;
            this.rfGained += rf;
            this.log("Receive Pearl: pearl arrives at tick " + this.chargingMode + ", age=" + age + ", RF=" + rf);
            this.modifyEnergyStored(rf);
            this.goodCounter = 10;
            this.markDirtyClientNoRender();
            this.chargingMode = -1;
            this.currentAge = age;
        }
    }

    public void startCharging() {
        this.markDirtyQuick();
        this.chargingMode = 1;
        ++this.chargeCounter;
    }

    public void useWrench(PlayerEntity player) {
        BlockPos thisCoord = this.func_174877_v();
        BlockPos coord = RFToolsBase.instance.clientInfo.getSelectedTE();
        TileEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.field_145850_b.func_175625_s(coord);
        }
        if (!(tileEntity instanceof EndergenicTileEntity)) {
            RFToolsBase.instance.clientInfo.setSelectedTE(thisCoord);
            EndergenicTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFToolsBase.instance.clientInfo.setDestinationTE(null);
                Logging.message((PlayerEntity)player, (String)"Select another endergenic generator as destination");
            } else {
                RFToolsBase.instance.clientInfo.setDestinationTE(destinationTE.func_174877_v());
                int distance = this.getDistanceInTicks();
                Logging.message((PlayerEntity)player, (String)("Select another endergenic generator as destination (current distance " + distance + ")"));
            }
        } else if (coord.equals((Object)thisCoord)) {
            RFToolsBase.instance.clientInfo.setSelectedTE(null);
            RFToolsBase.instance.clientInfo.setDestinationTE(null);
        } else {
            EndergenicTileEntity otherTE = (EndergenicTileEntity)tileEntity;
            int distance = otherTE.calculateDistance(thisCoord);
            if (distance >= 5) {
                Logging.warn((PlayerEntity)player, (String)"Distance is too far (maximum 4)");
                return;
            }
            otherTE.setDestination(thisCoord);
            RFToolsBase.instance.clientInfo.setSelectedTE(null);
            RFToolsBase.instance.clientInfo.setDestinationTE(null);
            Logging.message((PlayerEntity)player, (String)("Destination is set (distance " + otherTE.getDistanceInTicks() + " ticks)"));
        }
    }

    public int getChargingMode() {
        return this.chargingMode;
    }

    public int calculateDistance(BlockPos destination) {
        double d = new Vec3d((Vec3i)destination).func_72438_d(new Vec3d((Vec3i)this.func_174877_v()));
        return (int)(d / 3.0) + 1;
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public void setDestination(BlockPos destination) {
        this.markDirtyQuick();
        this.destination = destination;
        this.distance = this.calculateDistance(destination);
        if (this.field_145850_b.field_72995_K) {
            this.valueToServer(RFToolsPowerMessages.INSTANCE, VALUE_DESTINATION, destination);
        }
    }

    public int getDistanceInTicks() {
        return this.distance;
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.chargingMode = tagCompound.func_74762_e("charging");
        this.currentAge = tagCompound.func_74762_e("age");
        this.destination = BlockPosTools.read((CompoundNBT)tagCompound, (String)"dest");
        this.distance = tagCompound.func_74762_e("distance");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.badCounter = tagCompound.func_74771_c("bad");
        this.goodCounter = tagCompound.func_74771_c("good");
        this.pearls.clear();
        ListNBT list = tagCompound.func_150295_c("pearls", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tc = list.func_150305_b(i);
            EndergenicPearl pearl = new EndergenicPearl(tc);
            this.pearls.add(pearl);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("charging", this.chargingMode);
        tagCompound.func_74768_a("age", this.currentAge);
        BlockPosTools.write((CompoundNBT)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.func_74768_a("distance", this.distance);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74774_a("bad", (byte)this.badCounter);
        tagCompound.func_74774_a("good", (byte)this.goodCounter);
        ListNBT pearlList = new ListNBT();
        for (EndergenicPearl pearl : this.pearls) {
            pearlList.add((Object)pearl.getTagCompound());
        }
        tagCompound.func_218657_a("pearls", (INBT)pearlList);
        return tagCompound;
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETSTATS.equals(command)) {
            return TypedMap.builder().put(PARAM_STATRF, (Object)this.lastRfPerTick).put(PARAM_STATLOST, (Object)this.lastPearlsLost).put(PARAM_STATLAUNCHED, (Object)this.lastPearlsLaunched).put(PARAM_STATOPPORTUNITIES, (Object)this.lastChargeCounter).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap value) {
        boolean rc = super.receiveDataFromServer(command, value);
        if (rc) {
            return true;
        }
        if (CMD_GETSTATS.equals(command)) {
            GuiEndergenic.fromServer_lastRfPerTick = (Long)value.get(PARAM_STATRF);
            GuiEndergenic.fromServer_lastPearlsLost = (Integer)value.get(PARAM_STATLOST);
            GuiEndergenic.fromServer_lastPearlsLaunched = (Integer)value.get(PARAM_STATLAUNCHED);
            GuiEndergenic.fromServer_lastPearlOpportunities = (Integer)value.get(PARAM_STATOPPORTUNITIES);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List list = super.executeWithResultList(command, args, type);
        if (!list.isEmpty()) {
            return list;
        }
        if (PacketGetHudLog.CMD_GETHUDLOG.equals(command)) {
            return type.convert(this.getHudLog());
        }
        return list;
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if (PacketGetHudLog.CLIENTCMD_GETHUDLOG.equals(command)) {
            this.clientHudLog = Type.STRING.convert(list);
            return true;
        }
        return false;
    }

    public boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        if (world.field_72995_K) {
            SoundEvent pling = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.note.pling"));
            world.func_184133_a(player, pos, pling, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.useWrench(player);
        }
        return true;
    }

    public long getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        if (cap == CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY) {
            return this.infoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

