/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.generator.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.generator.CoalGeneratorConfig;
import mcjty.rftoolspower.modules.generator.CoalGeneratorModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CoalGeneratorTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final int SLOT_COALINPUT = 0;
    public static final int SLOT_CHARGEITEM = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151044_h), new ItemStack((IItemProvider)Items.field_196155_l), new ItemStack((IItemProvider)Blocks.field_150402_ci)}).in(), "container", 0, 82, 24).slot(SlotDefinition.specific(EnergyTools::isEnergyItem).in().out(), "container", 1, 118, 24).playerSlots(10, 70));
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)CoalGeneratorConfig.MAXENERGY.get()).intValue(), 0L);
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Crafter").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)CoalGeneratorModule.CONTAINER_COALGENERATOR.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage));
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> this.infusable);
    private final LazyOptional<IPowerInformation> powerInfoHandler = LazyOptional.of(this::createPowerInfo);
    private int burning;

    public CoalGeneratorTileEntity() {
        super((TileEntityType)CoalGeneratorModule.TYPE_COALGENERATOR.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(CoalGeneratorTileEntity::new).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/coalgenerator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> Long.toString(((Integer)CoalGeneratorConfig.RFPERTICK.get()).intValue()) + " RF/FE")})){

            protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208190_q});
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.markDirtyClient();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.markDirtyQuick();
            this.handleChargingItem((IItemHandler)this.items);
            this.handleSendingEnergy();
            if (!this.isMachineEnabled()) {
                return;
            }
            this.handlePowerGeneration();
        }
    }

    private void handlePowerGeneration() {
        if (this.burning > 0) {
            --this.burning;
            long rf = this.getRfPerTick();
            this.energyStorage.produceEnergy(rf);
        } else if (!this.items.getStackInSlot(0).func_190926_b()) {
            ItemStack extracted = this.items.extractItem(0, 1, false);
            this.burning = (Integer)CoalGeneratorConfig.TICKSPERCOAL.get();
            if (extracted.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
                this.burning *= 9;
            }
            float factor = this.infusable.getInfusedFactor();
            this.burning += (int)((float)this.burning * factor / 2.0f);
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q)).booleanValue() != this.isWorking()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.isWorking())), 3);
        }
    }

    public long getRfPerTick() {
        long rf = ((Integer)CoalGeneratorConfig.RFPERTICK.get()).intValue();
        float factor = this.infusable.getInfusedFactor();
        rf += (long)((float)rf * factor);
        return rf;
    }

    public boolean isWorking() {
        return this.burning > 0 && this.isMachineEnabled();
    }

    private void handleChargingItem(IItemHandler handler) {
        ItemStack stack = handler.getStackInSlot(1);
        if (!stack.func_190926_b()) {
            long storedPower = this.energyStorage.getEnergy();
            long rfToGive = Math.min((long)((Integer)CoalGeneratorConfig.CHARGEITEMPERTICK.get()).intValue(), storedPower);
            long received = EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
            this.energyStorage.consumeEnergy(received);
        }
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy();
        EnergyTools.handleSendingEnergy((World)this.field_145850_b, (BlockPos)this.field_174879_c, (long)storedPower, (long)((Integer)CoalGeneratorConfig.SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.burning = info.func_74762_e("burning");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.func_74768_a("burning", this.burning);
        return tagCompound;
    }

    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return CoalGeneratorTileEntity.this.burning > 0 ? CoalGeneratorTileEntity.this.getRfPerTick() : 0L;
            }

            @Nullable
            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            public boolean isMachineRunning() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            @Nullable
            public String getMachineStatus() {
                return CoalGeneratorTileEntity.this.burning > 0 ? "generating power" : "idle";
            }
        };
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CONTAINER_FACTORY.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return stack.func_77973_b() == Items.field_151044_h || stack.func_77973_b() == Items.field_196155_l || stack.func_77973_b() == Items.field_221896_ff;
                }
                return EnergyTools.isEnergyItem((ItemStack)stack);
            }

            public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                return this.isItemValid(slot, stack);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        if (cap == CapabilityPowerInformation.POWER_INFORMATION_CAPABILITY) {
            return this.powerInfoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

