/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class PowerMonitorTileEntity
extends LogicTileEntity
implements ITickableTileEntity {
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Power Monitor").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)MonitorModule.CONTAINER_POWER_MONITOR.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)));
    public static IntegerProperty LEVEL = IntegerProperty.func_177719_a((String)"level", (int)0, (int)5);
    public static final Key<Integer> VALUE_MINIMUM = new Key("minimum", Type.INTEGER);
    public static final Key<Integer> VALUE_MAXIMUM = new Key("maximum", Type.INTEGER);
    private int minimum;
    private int maximum;
    private int rflevel = 0;
    private boolean inAlarm = false;
    private int counter = 20;

    public PowerMonitorTileEntity() {
        super((TileEntityType)MonitorModule.TYPE_POWER_MONITOR.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powermonitor/powermonitor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PowerMonitorTileEntity::new)){

            protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new IProperty[]{LEVEL});
            }
        };
    }

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_MINIMUM, this::getMinimum, this::setMinimum), new DefaultValue(VALUE_MAXIMUM, this::getMaximum, this::setMaximum)};
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.markDirtyClient();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.markDirtyClient();
    }

    public void setInvalid() {
        this.changeRfLevel(0);
        this.setRedstoneState(0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        Direction inputSide = this.getFacing(this.field_145850_b.func_180495_p(this.func_174877_v())).getInputSide();
        BlockPos inputPos = this.func_174877_v().func_177972_a(inputSide);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(inputPos);
        if (!EnergyTools.isEnergyTE((TileEntity)tileEntity, null)) {
            this.setInvalid();
            return;
        }
        EnergyTools.EnergyLevel energy = EnergyTools.getEnergyLevelMulti((TileEntity)tileEntity, null);
        long maxEnergy = energy.getMaxEnergy();
        int ratio = 0;
        boolean alarm = false;
        if (maxEnergy > 0L) {
            long stored = energy.getEnergy();
            ratio = (int)(1L + stored * 5L / maxEnergy);
            if (ratio < 1) {
                ratio = 1;
            } else if (ratio > 5) {
                ratio = 5;
            }
            long percentage = stored * 100L / maxEnergy;
            boolean bl = alarm = percentage >= (long)this.minimum && percentage <= (long)this.maximum;
        }
        if (this.rflevel != ratio) {
            this.changeRfLevel(ratio);
            this.markDirtyClient();
        }
        if (alarm != this.inAlarm) {
            this.inAlarm = alarm;
            this.setRedstoneState(this.inAlarm ? 15 : 0);
            this.func_70296_d();
        }
    }

    private void changeRfLevel(int newRfLevel) {
        if (newRfLevel != this.rflevel) {
            this.rflevel = newRfLevel;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)LEVEL, (Comparable)Integer.valueOf(this.rflevel)), 3);
            this.func_70296_d();
        }
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.inAlarm = tagCompound.func_74767_n("inAlarm");
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.rflevel = info.func_74762_e("rflevel");
        this.minimum = info.func_74771_c("minimum");
        this.maximum = info.func_74771_c("maximum");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("inAlarm", this.inAlarm);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("rflevel", this.rflevel);
        info.func_74774_a("minimum", (byte)this.minimum);
        info.func_74774_a("maximum", (byte)this.maximum);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

