/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import mcjty.rftoolspower.modules.monitor.blocks.PowerLevelTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class PowerLevelRenderer
extends TileEntityRenderer<PowerLevelTileEntity> {
    public static final ResourceLocation[] DIGITS = new ResourceLocation[]{new ResourceLocation("rftoolspower", "block/monitor/powerlevel_0"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_1"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_2"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_3"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_4"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_5"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_6"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_7"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_8"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_9")};

    public PowerLevelRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(PowerLevelTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228643_e_());
        BlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        Block block = state.func_177230_c();
        if (!(block instanceof LogicSlabBlock)) {
            return;
        }
        LogicFacing logicFacing = (LogicFacing)state.func_177229_b((IProperty)LogicSlabBlock.LOGIC_FACING);
        Direction facing = logicFacing.getSide();
        RenderHelper.adjustTransformToDirection((MatrixStack)matrixStack, (Direction)facing);
        int level = te.getPowerOutput();
        if (level > 9) {
            level = 9;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(DIGITS[level]);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        ModelBuilder.FaceRotation rotation = ModelBuilder.FaceRotation.values()[logicFacing.getRotationStep()];
        RenderHelper.renderNorthSouthQuad((IVertexBuilder)builder, (Matrix4f)matrix, (TextureAtlasSprite)sprite, (ModelBuilder.FaceRotation)rotation, (float)0.73f);
        matrixStack.func_227865_b_();
    }

    public static void register() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)MonitorModule.TYPE_POWER_LEVEL.get()), PowerLevelRenderer::new);
    }
}

