/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.file.RegionDetection;
import xaero.map.region.MapRegion;

public class MapLimiter {
    private static final int MIN_LIMIT = 50;
    private int availableVRAM = -1;
    private int mostRegionsAtATime;
    private IntBuffer vramBuffer = BufferUtils.createByteBuffer((int)64).asIntBuffer();
    private int driverType = -1;

    public int getAvailableVRAM() {
        return this.availableVRAM;
    }

    private void determineDriverType() {
        boolean debugEnabled = false;
        boolean debugSyncEnabled = false;
        if (GL.getCapabilities().GL_KHR_debug) {
            debugEnabled = GL11.glIsEnabled((int)37600);
            debugSyncEnabled = GL11.glIsEnabled((int)33346);
            GL11.glDisable((int)37600);
            GL11.glDisable((int)33346);
        } else if (GL.getCapabilities().GL_ARB_debug_output) {
            debugSyncEnabled = GL11.glIsEnabled((int)33346);
            GL11.glDisable((int)33346);
        }
        GL11.glGetIntegerv((int)36937, (IntBuffer)this.vramBuffer);
        int error = GL11.glGetError();
        if (this.vramBuffer.get(0) == -1 || error != 0) {
            this.vramBuffer.position(0);
            GL11.glGetIntegerv((int)34812, (IntBuffer)this.vramBuffer);
            error = GL11.glGetError();
            this.driverType = error != 0 ? 2 : 1;
        } else {
            this.driverType = 0;
        }
        if (GL.getCapabilities().GL_KHR_debug) {
            if (debugEnabled) {
                GL11.glEnable((int)37600);
            }
            if (debugSyncEnabled) {
                GL11.glEnable((int)33346);
            }
        } else if (GL.getCapabilities().GL_ARB_debug_output && debugSyncEnabled) {
            GL11.glEnable((int)33346);
        }
        this.vramBuffer.clear();
        this.vramBuffer.put(0, -1);
    }

    public void updateAvailableVRAM() {
        this.vramBuffer.clear();
        this.vramBuffer.put(0, -1);
        if (this.driverType == -1) {
            this.determineDriverType();
        }
        switch (this.driverType) {
            case 0: {
                GL11.glGetIntegerv((int)36937, (IntBuffer)this.vramBuffer);
                this.availableVRAM = this.vramBuffer.get(0);
                break;
            }
            case 1: {
                GL11.glGetIntegerv((int)34812, (IntBuffer)this.vramBuffer);
                this.availableVRAM = this.vramBuffer.get(0);
            }
        }
    }

    public int getMostRegionsAtATime() {
        return this.mostRegionsAtATime;
    }

    public void setMostRegionsAtATime(int mostRegionsAtATime) {
        this.mostRegionsAtATime = mostRegionsAtATime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyLimit(List<MapRegion> regionsSorted, MapProcessor mapProcessor) {
        int limit = Math.max(this.mostRegionsAtATime, 50);
        int vramDetermined = 0;
        if (this.availableVRAM != -1) {
            vramDetermined = regionsSorted.size();
            if (this.availableVRAM >= 102400) return;
            vramDetermined = vramDetermined * 3 / 4;
        } else {
            vramDetermined = 400;
        }
        if (vramDetermined > limit) {
            limit = vramDetermined;
        }
        mapProcessor.pushRenderPause(false, true);
        MapRegion nextToLoad = mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
        for (int i = 0; i < regionsSorted.size() && regionsSorted.size() > limit; ++i) {
            MapRegion region = regionsSorted.get(i);
            if (region.getLoadState() != 4 && region.getLoadState() != 0) continue;
            region.deleteTexturesAndBuffers();
            region.pushWriterPause();
            RegionDetection restoredDetection = new RegionDetection(region.getWorld(), region.getRegionX(), region.getRegionZ(), region.getRegionFile(), mapProcessor.getGlobalVersion());
            restoredDetection.transferInfoFrom(region);
            mapProcessor.addRegionDetection(restoredDetection);
            mapProcessor.removeMapRegion(region);
            mapProcessor.removeToProcess(region);
            mapProcessor.getMapSaveLoad().removeToLoad(region);
            mapProcessor.getMapSaveLoad().cancelAllLoadRequests(region);
            mapProcessor.getMapSaveLoad().removeToCache(region);
            region.popWriterPause();
            if (region == nextToLoad) {
                mapProcessor.getMapSaveLoad().setNextToLoadByViewing(null);
            }
            --i;
        }
        mapProcessor.popRenderPause(false, true);
    }
}

