/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.GameData;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.controls.ControlsHandler;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.graphics.TextureUploader;

public class WorldMapSession {
    private ControlsHandler controlsHandler;
    private MapProcessor mapProcessor;
    private MapWriter mapWriter;
    private boolean finalized;

    public void init() throws NoSuchFieldException {
        MapSaveLoad mapSaveLoad = new MapSaveLoad(WorldMap.overlayManager, WorldMap.pngExporter, WorldMap.oldFormatSupport);
        TextureUploader textureUploader = new TextureUploader(WorldMap.normalTextureUploadPool, WorldMap.normalWithDownloadTextureUploadPool, WorldMap.compressedTextureUploadPool, WorldMap.textureUploadBenchmark);
        SimpleRegistry biomeRegistry = GameData.getWrapper(Biome.class);
        BlockStateColorTypeCache blockStateColorTypeCache = new BlockStateColorTypeCache((SimpleRegistry<Biome>)biomeRegistry);
        blockStateColorTypeCache.updateGrassColor();
        WorldDataReader worldDataReader = new WorldDataReader(WorldMap.overlayManager, blockStateColorTypeCache);
        WorldDataHandler worldDataHandler = new WorldDataHandler(worldDataReader);
        this.mapWriter = new MapWriter(WorldMap.overlayManager, blockStateColorTypeCache, (SimpleRegistry<Biome>)biomeRegistry);
        this.mapProcessor = new MapProcessor(mapSaveLoad, this.mapWriter, WorldMap.mapLimiter, WorldMap.bufferDeallocator, WorldMap.tilePool, WorldMap.overlayManager, textureUploader, worldDataHandler);
        this.mapWriter.setMapProcessor(this.mapProcessor);
        mapSaveLoad.setMapProcessor(this.mapProcessor);
        worldDataReader.setMapProcessor(this.mapProcessor);
        this.controlsHandler = new ControlsHandler(this.mapProcessor);
        this.mapProcessor.onInit();
        System.out.println("New world map session initialized!");
    }

    public void cleanup() {
        this.mapProcessor.stop();
        this.finalized = true;
        System.out.println("World map session finalized.");
    }

    public ControlsHandler getControlsHandler() {
        return this.controlsHandler;
    }

    public MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public static WorldMapSession getCurrentSession() {
        return WorldMapSession.getForPlayer(Minecraft.func_71410_x().field_71439_g);
    }

    public static WorldMapSession getForPlayer(ClientPlayerEntity player) {
        if (player == null || player.field_71174_a == null) {
            return null;
        }
        return ((IWorldMapClientPlayNetHandler)player.field_71174_a).getXaero_worldmapSession();
    }
}

