/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.util.Hashtable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import xaero.map.WorldMap;

public class BlockStateColorTypeCache {
    private Hashtable<BlockState, Integer> colorTypes = new Hashtable();
    private Hashtable<BlockState, Integer> overlayColorTypes = new Hashtable();
    private int grassColor;
    private int foliageColor;
    private BlockState grassState;
    private BlockState oakLeavesState;
    private BlockState waterState;
    private SimpleRegistry<Biome> biomeRegistry;

    public BlockStateColorTypeCache(SimpleRegistry<Biome> biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
        this.grassState = Blocks.field_196658_i.func_176223_P();
        this.oakLeavesState = Blocks.field_196642_W.func_176223_P();
        this.waterState = Blocks.field_150355_j.func_176223_P();
    }

    public void getBlockBiomeColour(World world, BlockState state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_213162_bc();
        if (colorType == -1 && isRenderThread) {
            Material material;
            try {
                customColour = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, 0);
            }
            catch (Throwable t) {
                customColour = 0;
            }
            if (customColour != -1 && customColour != this.grassColor && customColour != this.foliageColor && (material = state.func_185904_a()) != null && (material.func_151565_r() == MaterialColor.field_151661_c || material.func_151565_r() == MaterialColor.field_151669_i)) {
                customColour = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (ILightReader)world, pos, 0);
                gotFullCC = true;
                if (material.func_151565_r() == MaterialColor.field_151661_c && customColour == Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.grassState, (ILightReader)world, pos, 0)) {
                    customColour = this.grassColor;
                } else if (material.func_151565_r() == MaterialColor.field_151669_i && customColour == Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.oakLeavesState, (ILightReader)world, pos, 0)) {
                    customColour = this.foliageColor;
                }
            }
            if (customColour == this.grassColor) {
                colorType = 1;
            } else if (customColour == this.foliageColor) {
                colorType = 2;
            } else {
                if (!gotFullCC) {
                    customColour = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (ILightReader)world, pos, 0);
                    gotFullCC = true;
                }
                colorType = customColour != 0xFFFFFF && customColour != -1 ? 3 : 0;
            }
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if ((colorType == 1 || colorType == 2) && biomeId == -1) {
            if (isRenderThread) {
                biomeId = this.biomeRegistry.func_148757_b((Object)world.func_226691_t_(pos));
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        if (colorType == -1) {
            dest[1] = biomeId;
        } else if (colorType == 1 || colorType == 2) {
            dest[1] = biomeId;
        } else if (colorType == 3) {
            if (!gotFullCC) {
                customColour = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (ILightReader)world, pos, 0);
            }
            dest[2] = customColour;
        }
    }

    public void getOverlayBiomeColour(World world, BlockState state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.overlayColorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_213162_bc();
        if (colorType == -1 && isRenderThread) {
            if (state.func_177230_c() == Blocks.field_150355_j) {
                colorType = 1;
            } else {
                Material material;
                customColour = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (ILightReader)world, pos, 0);
                gotFullCC = true;
                colorType = customColour != 0xFFFFFF && customColour != -1 ? ((material = state.func_185904_a()) != null && material.func_151565_r() == MaterialColor.field_151662_n && customColour == Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.waterState, (ILightReader)world, pos, 0) ? 1 : 2) : 0;
            }
            this.overlayColorTypes.put(state, colorType);
        } else if (colorType == 2 && !isRenderThread) {
            colorType = -1;
        }
        dest[0] = colorType;
        if (colorType == 1) {
            dest[1] = biomeId != -1 ? biomeId : this.biomeRegistry.func_148757_b((Object)world.func_226691_t_(pos));
        } else if (colorType == 2) {
            if (!gotFullCC) {
                customColour = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (ILightReader)world, pos, 0);
            }
            dest[2] = customColour;
        }
    }

    public void updateGrassColor() {
        this.grassColor = Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.grassState, null, null, 0);
        this.foliageColor = Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.oakLeavesState, null, null, 0);
        if (WorldMap.settings.debug) {
            System.out.println("Default grass colour: " + this.grassColor);
        }
    }
}

