/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.lang.reflect.Field;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.realms.RealmsScreenProxy;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;
import xaero.patreon.GuiUpdateAll2;
import xaero.patreon.Patreon5;

public class Events {
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;

    @SubscribeEvent
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent event) {
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof WorldSelectionScreen) {
            // empty if block
        }
        if (event.getGui() instanceof RealmsScreenProxy && ((RealmsScreenProxy)event.getGui()).getScreen() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                RealmsTasks.RealmsGetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("field_224248_l");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = RealmsTasks.RealmsGetServerDetailsTask.class.getDeclaredField("field_225007_b");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)((RealmsScreenProxy)event.getGui()).getScreen())) instanceof RealmsTasks.RealmsGetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (RealmsTasks.RealmsGetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.id != this.latestRealm.id)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) throws Exception {
        WorldMapSession worldmapSession;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END) {
            WorldMap.glObjectDeleter.work();
        }
        if (mc.field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.phase == TickEvent.Phase.END) {
                mapProcessor.onRenderProcess(mc);
                mc.field_71454_w = false;
                mapProcessor.resetRenderStartTime();
                Queue<Runnable> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                Runnable task = mapProcessor.getRenderStartTimeUpdater();
                Runnable[] currentTasks = minecraftScheduledTasks.toArray(new Runnable[0]);
                minecraftScheduledTasks.clear();
                minecraftScheduledTasks.add(task);
                for (Runnable t : currentTasks) {
                    minecraftScheduledTasks.add(t);
                }
            } else if (event.phase == TickEvent.Phase.START) {
                if (mc.field_71462_r instanceof GuiMap) {
                    RenderSystem.enableDepthTest();
                    mc.field_71460_t.func_195458_a(1.0f, Util.func_211178_c(), false);
                    mc.field_71454_w = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon5.needsNotification() && event.getGui() instanceof MainMenuScreen && (!SupportMods.minimap() || SupportMods.xaeroMinimap.compatibilityVersion < 1)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiUpdateAll2());
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    @SubscribeEvent
    public void spawnSet(PlayerSetSpawnEvent event) {
        if (event.getPlayer().field_70170_p instanceof ClientWorld) {
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(event.getNewSpawn(), (ClientWorld)event.getPlayer().field_70170_p);
        }
    }

    @SubscribeEvent
    public void worldCapabilities(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof ServerWorld) {
            event.addCapability(new ResourceLocation("xaeroworldmap", "server_world_caps"), (ICapabilityProvider)new ServerWorldCapabilities());
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        WorldMapSession worldmapSession;
        if (Minecraft.func_71410_x().field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.getWorld() == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld sw = (ServerWorld)event.getWorld();
            WorldDataHandler.onServerWorldUnload(sw);
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        WorldMapSession worldmapSession;
        MapProcessor mapProcessor;
        String crosshairMessage;
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && (crosshairMessage = (mapProcessor = (worldmapSession = WorldMapSession.getCurrentSession()).getMapProcessor()).getCrosshairMessage()) != null) {
            int messageWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(crosshairMessage);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(crosshairMessage, (float)(event.getWindow().func_198107_o() / 2 - messageWidth / 2), (float)(event.getWindow().func_198087_p() / 2 + 60), -1);
        }
    }
}

