/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.file.MapRegionInfo;
import xaero.map.file.OldFormatSupport;
import xaero.map.file.PNGExporter;
import xaero.map.file.RegionDetection;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;
import xaero.map.region.state.UnknownBlockState;
import xaero.map.world.MapDimension;

public class MapSaveLoad {
    private static final int currentSaveMajorVersion = 2;
    private static final int currentSaveMinorVersion = 1;
    public static final int SAVE_TIME = 60000;
    public static final int currentCacheSaveVersion = 5;
    private ArrayList<MapRegion> toSave = new ArrayList();
    private ArrayList<MapRegion> toLoad = new ArrayList();
    private ArrayList<MapRegion> toRequestToLoad = new ArrayList();
    private ArrayList<MapRegion> prioritizedToRequestToLoad = new ArrayList();
    private ArrayList<File> cacheToConvertFromTemp;
    private MapRegion nextToLoadByViewing;
    private boolean regionDetectionComplete;
    private ArrayList<Path> cacheFolders = new ArrayList();
    private Path lastRealmOwnerPath;
    public boolean loadingFiles;
    private OverlayBuilder overlayBuilder;
    private PNGExporter pngExporter;
    private OldFormatSupport oldFormatSupport;
    private HashMap<BlockState, Integer> regionSavePalette;
    private ArrayList<BlockState> regionLoadPalette;
    private List<MapDimension> workingDimList;
    public boolean saveAll;
    private MapProcessor mapProcessor;

    public MapSaveLoad(OverlayManager overlayManager, PNGExporter pngExporter, OldFormatSupport oldFormatSupport) {
        this.cacheToConvertFromTemp = new ArrayList();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.pngExporter = pngExporter;
        this.oldFormatSupport = oldFormatSupport;
        this.regionSavePalette = new HashMap();
        this.regionLoadPalette = new ArrayList();
        this.workingDimList = new ArrayList<MapDimension>();
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public void exportPNG() {
        this.mapProcessor.pushProcessorPause();
        try {
            this.pngExporter.export(this.mapProcessor);
        }
        catch (Throwable e) {
            WorldMap.LOGGER.info("Failed to export PNG with exception!");
            WorldMap.crashHandler.setCrashedBy(e);
        }
        this.mapProcessor.popProcessorPause();
    }

    private File getSecondaryFile(String extension, File realFile) {
        if (realFile == null) {
            return null;
        }
        String p = realFile.getPath();
        return new File(p.substring(0, p.lastIndexOf(".")) + extension);
    }

    public File getTempFile(File realFile) {
        return this.getSecondaryFile(".zip.temp", realFile);
    }

    public void updateCacheFolderList(Path subFolder) {
        Stream<Path> allFiles;
        try {
            allFiles = Files.list(subFolder);
        }
        catch (Exception e) {
            this.cacheFolders.clear();
            return;
        }
        Object[] filesArray = allFiles.toArray();
        allFiles.close();
        this.cacheFolders.clear();
        for (int i = 0; i < filesArray.length; ++i) {
            Path path = (Path)filesArray[i];
            if (!Files.isDirectory(path, new LinkOption[0]) || !path.getFileName().toString().startsWith("cache_") || path.getFileName().toString().split("_")[1].equals("" + this.mapProcessor.getGlobalVersion())) continue;
            this.cacheFolders.add(path);
            if (!WorldMap.settings.debug) continue;
            WorldMap.LOGGER.info(path.toString());
        }
        this.cacheFolders.add(subFolder);
    }

    public Path getCacheFolder(Path subFolder) {
        if (subFolder != null) {
            return subFolder.resolve("cache_" + this.mapProcessor.getGlobalVersion());
        }
        return null;
    }

    public File getCacheFile(MapRegionInfo region, boolean checkOldFolders, boolean requestCache) throws IOException {
        Path subFolder = this.getSubFolder(region.getWorld());
        Path latestCacheFolder = this.getCacheFolder(subFolder);
        if (latestCacheFolder == null) {
            return null;
        }
        Files.createDirectories(latestCacheFolder, new FileAttribute[0]);
        Path cacheFile = latestCacheFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xwmc");
        if (!checkOldFolders || Files.exists(cacheFile, new LinkOption[0])) {
            return cacheFile.toFile();
        }
        if (requestCache) {
            region.setShouldCache(true, "cache file");
        }
        for (int i = 0; i < this.cacheFolders.size(); ++i) {
            Path oldCacheFolder = this.cacheFolders.get(i);
            Path oldCacheFile = oldCacheFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xwmc");
            if (!Files.exists(oldCacheFile, new LinkOption[0])) continue;
            return oldCacheFile.toFile();
        }
        return cacheFile.toFile();
    }

    public File getFile(MapRegion region) {
        if (region.getWorld() == null) {
            return null;
        }
        File detectedFile = region.getRegionFile();
        boolean realms = this.mapProcessor.isWorldRealms(region.getWorld());
        boolean multiplayer = region.isMultiplayer();
        if (!multiplayer) {
            if (detectedFile != null) {
                return detectedFile;
            }
            return this.mapProcessor.getWorldDataHandler().getWorldDir().toPath().resolve("region").resolve("r." + region.getRegionX() + "." + region.getRegionZ() + ".mca").toFile();
        }
        Path mainFolder = this.getMainFolder(region.getWorld(), true);
        Path subFolder = this.getSubFolder(region.getWorld(), mainFolder, true);
        try {
            File subFolderFile = subFolder.toFile();
            if (!subFolderFile.exists()) {
                Path ownerPath;
                Files.createDirectories(subFolderFile.toPath(), new FileAttribute[0]);
                if (realms && WorldMap.events.getLatestRealm() != null && !(ownerPath = mainFolder.resolve(WorldMap.events.getLatestRealm().owner + ".owner")).equals(this.lastRealmOwnerPath)) {
                    if (!Files.exists(ownerPath, new LinkOption[0])) {
                        Files.createFile(ownerPath, new FileAttribute[0]);
                    }
                    this.lastRealmOwnerPath = ownerPath;
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (detectedFile != null && detectedFile.getName().endsWith(".xaero")) {
            File zipFile = subFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".zip").toFile();
            if (detectedFile.exists() && !zipFile.exists()) {
                this.xaeroToZip(detectedFile);
            }
            region.setRegionFile(zipFile);
            return zipFile;
        }
        return detectedFile == null ? subFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".zip").toFile() : detectedFile;
    }

    public Path getMainFolder(String world, boolean hasMW) {
        if (world == null) {
            return null;
        }
        if (!hasMW) {
            return WorldMap.saveFolder.toPath().resolve(world);
        }
        return WorldMap.saveFolder.toPath().resolve(world.substring(0, world.lastIndexOf("_")));
    }

    Path getSubFolder(String world, Path mainFolder, boolean hasMW) {
        if (world == null) {
            return null;
        }
        if (!hasMW) {
            return mainFolder;
        }
        return mainFolder.resolve(world.substring(world.lastIndexOf("_") + 1));
    }

    public Path getSubFolder(String world) {
        if (world == null) {
            return null;
        }
        boolean mp = this.mapProcessor.isWorldMultiplayer(false, world) || this.mapProcessor.isWorldRealms(world);
        return this.getSubFolder(world, this.getMainFolder(world, mp), mp);
    }

    private void xaeroToZip(File xaero) {
        File zipFile = xaero.toPath().getParent().resolve(xaero.getName().substring(0, xaero.getName().lastIndexOf(46)) + ".zip").toFile();
        try {
            int got;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(xaero), 1024);
            ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            ZipEntry e = new ZipEntry("region.xaero");
            zipOutput.putNextEntry(e);
            byte[] bytes = new byte[1024];
            while ((got = in.read(bytes)) > 0) {
                zipOutput.write(bytes, 0, got);
            }
            zipOutput.closeEntry();
            zipOutput.flush();
            zipOutput.close();
            in.close();
            Files.deleteIfExists(xaero.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void detectRegions() {
        this.mapProcessor.getMapWorld().getCurrentDimension().createDetectedRegions().clear();
        String worldString = this.mapProcessor.getCurrentWorldString();
        if (worldString == null) {
            return;
        }
        if (this.mapProcessor.isWorldMultiplayer(this.mapProcessor.isWorldRealms(worldString), worldString)) {
            Path mapFolder = this.getSubFolder(worldString);
            if (!mapFolder.toFile().exists()) {
                return;
            }
            this.detectRegionsFromFiles(worldString, mapFolder, "^-?\\d+_-?\\d+\\.(zip|xaero)$", "_", 0, 1, 0);
        } else {
            File worldDir = this.mapProcessor.getWorldDataHandler().getWorldDir();
            if (worldDir == null) {
                return;
            }
            Path worldFolder = worldDir.toPath().resolve("region");
            if (!worldFolder.toFile().exists()) {
                return;
            }
            this.detectRegionsFromFiles(worldString, worldFolder, "^r\\.(-{0,1}[0-9]+\\.){2}mc[ar]$", "\\.", 1, 2, 8192);
        }
    }

    public void detectRegionsFromFiles(String worldString, Path folder, String regex, String splitRegex, int xIndex, int zIndex, int emptySize) {
        int total = 0;
        try {
            Stream<Path> files = Files.list(folder);
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                String regionName;
                Path file = (Path)iter.next();
                if (Files.isDirectory(file, new LinkOption[0]) || !(regionName = file.getFileName().toString()).matches(regex) || Files.size(file) <= (long)emptySize) continue;
                String[] args = regionName.substring(0, regionName.lastIndexOf(46)).split(splitRegex);
                int x = Integer.parseInt(args[xIndex]);
                int z = Integer.parseInt(args[zIndex]);
                RegionDetection regionDetection = new RegionDetection(worldString, x, z, file.toFile(), this.mapProcessor.getGlobalVersion());
                File cacheFile = this.getCacheFile(regionDetection, true, true);
                regionDetection.setCacheFile(cacheFile);
                this.mapProcessor.addRegionDetection(regionDetection);
                ++total;
            }
            files.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (WorldMap.settings.debug) {
            System.out.println(String.format("%d regions detected!", total));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveRegion(MapRegion region) {
        try {
            if (!region.isMultiplayer()) {
                if (WorldMap.settings.debug) {
                    System.out.println("Save not required for singleplayer: " + region + " " + region.getWorld());
                }
                return region.countChunks() > 0;
            }
            File permFile = this.getFile(region);
            File file = this.getTempFile(permFile);
            if (file == null) {
                return true;
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            boolean regionIsEmpty = true;
            try (FilterOutputStream out = null;){
                ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                out = new DataOutputStream(zipOut);
                ZipEntry e = new ZipEntry("region.xaero");
                zipOut.putNextEntry(e);
                int fullVersion = 131073;
                ((DataOutputStream)out).write(255);
                ((DataOutputStream)out).writeInt(fullVersion);
                this.regionSavePalette.clear();
                for (int o = 0; o < 8; ++o) {
                    for (int p = 0; p < 8; ++p) {
                        MapTileChunk chunk = region.getChunk(o, p);
                        if (chunk == null) continue;
                        if (chunk.includeInSave()) {
                            ((DataOutputStream)out).write(o << 4 | p);
                            boolean chunkIsEmpty = true;
                            for (int i = 0; i < 4; ++i) {
                                for (int j = 0; j < 4; ++j) {
                                    MapTile tile = chunk.getTile(i, j);
                                    if (tile != null && tile.isLoaded()) {
                                        chunkIsEmpty = false;
                                        for (int x = 0; x < 16; ++x) {
                                            MapBlock[] c = tile.getBlockColumn(x);
                                            for (int z = 0; z < 16; ++z) {
                                                this.savePixel(c[z], (DataOutputStream)out);
                                            }
                                        }
                                        continue;
                                    }
                                    ((DataOutputStream)out).writeInt(-1);
                                }
                            }
                            if (chunkIsEmpty) continue;
                            regionIsEmpty = false;
                            continue;
                        }
                        region.setChunk(o, p, null);
                    }
                }
                zipOut.closeEntry();
            }
            if (regionIsEmpty) {
                this.safeDelete(permFile.toPath(), ".zip");
                this.safeDelete(file.toPath(), ".temp");
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("Save cancelled because the region is empty: " + region + " " + region.getWorld());
                }
                return false;
            }
            this.safeMove(file.toPath(), permFile.toPath(), ".temp", ".zip", StandardCopyOption.REPLACE_EXISTING);
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Region saved: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + this.mapProcessor.getMapWriter().getUpdateCounter());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    private Path getBackupFolder(Path filePath, int saveVersion, int backupVersion) {
        return filePath.getParent().resolve(saveVersion + "_backup_" + backupVersion);
    }

    public void backupFile(File file, int saveVersion) throws IOException {
        if (file.getName().endsWith(".mca") || file.getName().endsWith(".mcr")) {
            throw new RuntimeException("World save protected: " + file);
        }
        Path filePath = file.toPath();
        int backupVersion = 0;
        Path backupFolder = this.getBackupFolder(filePath, saveVersion, backupVersion);
        String backupName = filePath.getFileName().toString();
        Path backup = backupFolder.resolve(backupName);
        while (Files.exists(backup, new LinkOption[0])) {
            backupFolder = this.getBackupFolder(filePath, saveVersion, ++backupVersion);
            backup = backupFolder.resolve(backupName);
        }
        Files.createDirectories(backupFolder, new FileAttribute[0]);
        Files.move(file.toPath(), backup, new CopyOption[0]);
        WorldMap.LOGGER.info("File " + file.getPath() + " backed up to " + backupFolder.toFile().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean loadRegion(World world, MapRegion region) {
        boolean multiplayer = region.isMultiplayer();
        File file = this.getFile(region);
        if (file == null || !file.exists()) {
            if (region.getLoadState() == 4) {
                region.setBeingWritten(false);
                region.setSaveExists(null);
            }
            return false;
        }
        int minorSaveVersion = -1;
        int majorSaveVersion = 0;
        boolean versionReached = false;
        int[] overlayBiomeBuffer = new int[3];
        try {
            boolean result;
            MapRegion mapRegion = region;
            synchronized (mapRegion) {
                region.setLoadState((byte)1);
            }
            region.setSaveExists(true);
            region.restoreBufferUpdateObjects();
            int totalChunks = 0;
            if (multiplayer) {
                this.regionLoadPalette.clear();
                try (FilterInputStream in = null;){
                    ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(file), 2048));
                    in = new DataInputStream(zipIn);
                    zipIn.getNextEntry();
                    int firstByte = in.read();
                    if (firstByte == 255) {
                        int fullVersion = ((DataInputStream)in).readInt();
                        minorSaveVersion = fullVersion & 0xFFFF;
                        majorSaveVersion = fullVersion >> 16 & 0xFFFF;
                        if (1 < minorSaveVersion || 2 < majorSaveVersion) {
                            zipIn.closeEntry();
                            in.close();
                            System.out.println("Trying to load a newer region " + region.getRegionX() + "_" + region.getRegionZ() + " save using an older version of Xaero's World Map!");
                            this.backupFile(file, fullVersion);
                            region.setSaveExists(null);
                            boolean bl = false;
                            return bl;
                        }
                        firstByte = -1;
                    }
                    versionReached = true;
                    while (true) {
                        int chunkCoords;
                        int n = chunkCoords = firstByte == -1 ? in.read() : firstByte;
                        if (chunkCoords == -1) break;
                        firstByte = -1;
                        int o = chunkCoords >> 4;
                        int p = chunkCoords & 0xF;
                        MapTileChunk chunk = region.getChunk(o, p);
                        if (chunk == null) {
                            chunk = new MapTileChunk(region, region.getRegionX() * 8 + o, region.getRegionZ() * 8 + p);
                            region.setChunk(o, p, chunk);
                        }
                        chunk.setLoadState((byte)1);
                        chunk.resetMasks();
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                Integer nextTile = ((DataInputStream)in).readInt();
                                if (nextTile == -1) continue;
                                MapTile tile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunk.getX() * 4 + i, chunk.getZ() * 4 + j);
                                for (int x = 0; x < 16; ++x) {
                                    MapBlock[] c = tile.getBlockColumn(x);
                                    for (int z = 0; z < 16; ++z) {
                                        if (c[z] == null) {
                                            c[z] = new MapBlock();
                                        } else {
                                            c[z].prepareForWriting();
                                        }
                                        this.loadPixel(nextTile, c[z], (DataInputStream)in, minorSaveVersion, majorSaveVersion, world, tile.getChunkX() * 16 + x, tile.getChunkZ() * 16 + z, overlayBiomeBuffer);
                                        nextTile = null;
                                    }
                                }
                                chunk.setTile(i, j, tile);
                                tile.setLoaded(true);
                            }
                        }
                        if (!chunk.includeInSave()) {
                            chunk = null;
                            region.setChunk(o, p, null);
                            continue;
                        }
                        region.pushWriterPause();
                        ++totalChunks;
                        chunk.setToUpdateBuffers(true);
                        chunk.setLoadState((byte)2);
                        region.popWriterPause();
                    }
                    zipIn.closeEntry();
                }
                if (totalChunks > 0) {
                    if (WorldMap.settings.debug) {
                        System.out.println("Region loaded: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + majorSaveVersion + " " + minorSaveVersion);
                    }
                    return true;
                }
                region.setSaveExists(null);
                this.safeDelete(file.toPath(), ".zip");
                if (WorldMap.settings.debug) {
                    System.out.println("Cancelled loading an empty region: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + majorSaveVersion + " " + minorSaveVersion);
                }
                return false;
            }
            int[] chunkCount = new int[1];
            WorldDataHandler.Result buildResult = this.mapProcessor.getWorldDataHandler().buildRegion(region, world, true, chunkCount);
            if (buildResult == WorldDataHandler.Result.CANCEL) {
                RegionDetection restoredDetection = new RegionDetection(region.getWorld(), region.getRegionX(), region.getRegionZ(), region.getRegionFile(), this.mapProcessor.getGlobalVersion());
                restoredDetection.transferInfoFrom(region);
                this.mapProcessor.addRegionDetection(restoredDetection);
                this.mapProcessor.removeMapRegion(region);
                this.mapProcessor.removeToProcess(region);
                System.out.println("Region cancelled from world save: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ());
                return false;
            }
            region.setRegionFile(file);
            boolean bl = result = buildResult == WorldDataHandler.Result.SUCCESS && chunkCount[0] > 0;
            if (!result) {
                region.setSaveExists(null);
                if (WorldMap.settings.debug) {
                    System.out.println("Region failed to load from world save: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ());
                }
            } else if (WorldMap.settings.debug) {
                System.out.println("Region loaded from world save: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ());
            }
            return result;
        }
        catch (Throwable e) {
            region.setSaveExists(null);
            System.out.println("Region failed to load: " + region.getRegionX() + "_" + region.getRegionZ() + (versionReached ? " " + majorSaveVersion + " " + minorSaveVersion : ""));
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beingLoaded(int regX, int regZ) {
        if (this.loadingFiles) {
            return true;
        }
        for (int i = 0; i < this.toLoad.size(); ++i) {
            ArrayList<MapRegion> arrayList = this.toLoad;
            synchronized (arrayList) {
                if (i >= this.toLoad.size()) {
                    return false;
                }
                MapRegion r = this.toLoad.get(i);
                if (r != null && r.getRegionX() == regX && r.getRegionZ() == regZ) {
                    return true;
                }
                continue;
            }
        }
        return false;
    }

    public boolean beingSaved(MapDimension dim, int regX, int regZ) {
        for (int i = 0; i < this.toSave.size(); ++i) {
            MapRegion r = this.toSave.get(i);
            if (r == null || r.getDim() != dim || r.getRegionX() != regX || r.getRegionZ() != regZ) continue;
            return true;
        }
        return false;
    }

    public void requestLoad(MapRegion region, String reason) {
        this.requestLoad(region, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLoad(MapRegion region, String reason, boolean prioritize) {
        region.setReloadHasBeenRequested(true, reason);
        if (prioritize) {
            ArrayList<MapRegion> arrayList = this.prioritizedToRequestToLoad;
            synchronized (arrayList) {
                this.prioritizedToRequestToLoad.remove(region);
                this.prioritizedToRequestToLoad.add(region);
            }
        }
        ArrayList<MapRegion> arrayList = this.toRequestToLoad;
        synchronized (arrayList) {
            if (!this.toRequestToLoad.contains(region)) {
                this.toRequestToLoad.add(region);
            }
        }
        if (WorldMap.settings.debug && reason != null) {
            WorldMap.LOGGER.info("Requesting load for: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllLoadRequests(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.prioritizedToRequestToLoad;
        synchronized (arrayList) {
            this.prioritizedToRequestToLoad.remove(region);
        }
        arrayList = this.toRequestToLoad;
        synchronized (arrayList) {
            this.toRequestToLoad.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLoadRequests() {
        ArrayList<MapRegion> arrayList = this.prioritizedToRequestToLoad;
        synchronized (arrayList) {
            this.prioritizedToRequestToLoad.clear();
        }
        arrayList = this.toRequestToLoad;
        synchronized (arrayList) {
            this.toRequestToLoad.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLoad(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToLoad(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearToLoad() {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.clear();
        }
    }

    public int getSizeOfToLoad() {
        return this.toLoad.size();
    }

    public boolean saveExists(MapRegion region) {
        if (region.getSaveExists() != null) {
            return region.getSaveExists();
        }
        boolean result = true;
        File file = this.getFile(region);
        if (file == null || !file.exists()) {
            result = false;
        }
        region.setSaveExists(result);
        return result;
    }

    public void updateSave(MapRegion region) {
        if (region.getLoadState() == 2 && region.isBeingWritten() && System.currentTimeMillis() - region.getLastSaveTime() > 60000L && !this.beingSaved(region.getDim(), region.getRegionX(), region.getRegionZ())) {
            this.toSave.add(region);
            region.setSaveExists(true);
            region.setLastSaveTime(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(World world) throws Exception {
        MapRegion region;
        ArrayList<MapRegion> arrayList;
        int limit;
        for (limit = this.toRequestToLoad.size(); !this.toRequestToLoad.isEmpty() && limit > 0; --limit) {
            arrayList = this.toRequestToLoad;
            synchronized (arrayList) {
                if (this.toRequestToLoad.isEmpty()) {
                    break;
                }
                region = this.toRequestToLoad.remove(0);
            }
            if (region.getLoadState() != 0 && region.getLoadState() != 4 || this.beingLoaded(region.getRegionX(), region.getRegionZ())) continue;
            this.addToLoad(region);
        }
        for (limit = this.prioritizedToRequestToLoad.size(); !this.prioritizedToRequestToLoad.isEmpty() && limit > 0; --limit) {
            arrayList = this.prioritizedToRequestToLoad;
            synchronized (arrayList) {
                if (this.prioritizedToRequestToLoad.isEmpty()) {
                    break;
                }
                region = this.prioritizedToRequestToLoad.remove(0);
            }
            if (region.getLoadState() != 0 && region.getLoadState() != 4) continue;
            arrayList = this.toLoad;
            synchronized (arrayList) {
                this.toLoad.remove(region);
                this.toLoad.add(0, region);
                continue;
            }
        }
        if (!this.toLoad.isEmpty() && this.mapProcessor.caveStartIsDetermined()) {
            boolean loaded = false;
            arrayList = this.mapProcessor.loadingSync;
            synchronized (arrayList) {
                this.loadingFiles = true;
                while (!(this.mapProcessor.isWaitingForWorldUpdate() || loaded || this.toLoad.isEmpty())) {
                    boolean needsLoading;
                    MapRegion region2;
                    ArrayList<MapRegion> arrayList2 = this.toLoad;
                    synchronized (arrayList2) {
                        if (this.toLoad.isEmpty()) {
                            break;
                        }
                        region2 = this.toLoad.get(0);
                    }
                    MapRegion mapRegion = region2;
                    synchronized (mapRegion) {
                        boolean bl = needsLoading = region2.getLoadState() == 0 || region2.getLoadState() == 4;
                        if (needsLoading) {
                            if (region2.hasVersion() && region2.getVersion() != this.mapProcessor.getGlobalVersion() || !region2.hasVersion() && region2.getInitialVersion() != this.mapProcessor.getGlobalVersion()) {
                                region2.setShouldCache(true, "loading");
                            }
                            region2.setVersion(this.mapProcessor.getGlobalVersion());
                        }
                    }
                    if (needsLoading) {
                        MapRegion nextRegion;
                        boolean shouldLoadProperly;
                        if (region2.getLoadState() == 0) {
                            this.requestCacheIfNeeded(region2);
                        }
                        this.mapProcessor.addToProcess(region2);
                        MapRegion mapRegion2 = region2;
                        synchronized (mapRegion2) {
                            boolean goingToPrepareCache = region2.shouldCache() && (region2.getLoadState() == 4 || region2.getCacheFile() == null || !region2.getCacheFile().exists());
                            boolean bl = shouldLoadProperly = region2.isBeingWritten() || goingToPrepareCache;
                            if (!shouldLoadProperly) {
                                region2.setLoadState((byte)3);
                            } else if (region2.shouldCache()) {
                                region2.setRecacheHasBeenRequested(true, "loading");
                            }
                        }
                        if (shouldLoadProperly) {
                            loaded = this.loadRegion(world, region2);
                            if (!loaded) {
                                region2.setShouldCache(false, "couldn't load");
                                region2.setRecacheHasBeenRequested(false, "couldn't load");
                                if (region2.getSaveExists() == null) {
                                    region2.deleteTexturesAndBuffers();
                                    if (region2.isBeingWritten()) {
                                        region2.clean(this.mapProcessor);
                                    } else {
                                        this.mapProcessor.removeMapRegion(region2);
                                        this.mapProcessor.removeToProcess(region2);
                                    }
                                }
                            } else {
                                nextRegion = this.mapProcessor.getMapRegion(region2.getRegionX(), region2.getRegionZ() + 1, false);
                                if (nextRegion != null) {
                                    nextRegion.onTopRegionLoaded(region2);
                                }
                            }
                            nextRegion = region2;
                            synchronized (nextRegion) {
                                if (region2.getLoadState() <= 1) {
                                    region2.setLoadState((byte)2);
                                }
                                region2.setLastSaveTime(System.currentTimeMillis());
                            }
                        } else {
                            nextRegion = this.mapProcessor.getMapRegion(region2.getRegionX(), region2.getRegionZ() + 1, false);
                            if (nextRegion != null) {
                                nextRegion.onTopRegionLoaded(region2);
                            }
                            if (WorldMap.settings.debug) {
                                WorldMap.LOGGER.info("Loaded from cache only for " + region2);
                            }
                        }
                        region2.setReloadHasBeenRequested(false, "loading");
                    }
                    this.removeToLoad(region2);
                }
                this.loadingFiles = false;
            }
        }
        int regionsToSave = 3;
        while (!this.toSave.isEmpty() && (this.saveAll || regionsToSave > 0)) {
            boolean regionLoaded;
            MapRegion region3;
            MapRegion needsLoading = region3 = this.toSave.get(0);
            synchronized (needsLoading) {
                regionLoaded = region3.getLoadState() == 2;
            }
            if (regionLoaded) {
                if (!region3.isBeingWritten()) {
                    throw new Exception("Saving a weird region: " + region3.getRegionX() + "_" + region3.getRegionZ());
                }
                region3.pushWriterPause();
                boolean notEmpty = this.saveRegion(region3);
                if (notEmpty) {
                    if (!region3.isAllCachePrepared()) {
                        MapRegion shouldLoadProperly = region3;
                        synchronized (shouldLoadProperly) {
                            region3.requestRefresh(this.mapProcessor);
                        }
                    }
                    region3.setRecacheHasBeenRequested(true, "saving");
                    region3.setShouldCache(true, "saving");
                    region3.setBeingWritten(false);
                    --regionsToSave;
                } else {
                    this.mapProcessor.removeMapRegion(region3);
                    this.mapProcessor.removeToProcess(region3);
                }
                region3.popWriterPause();
                if (region3.getWorld() == null || !region3.getWorld().equals(this.mapProcessor.getCurrentWorldString())) {
                    if (region3.getCacheFile() != null) {
                        try {
                            Files.deleteIfExists(region3.getCacheFile().toPath());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (WorldMap.settings.debug) {
                            WorldMap.LOGGER.info(String.format("Deleting cache for region %s because it IS outdated.", this));
                        }
                    }
                    region3.clearRegion(this.mapProcessor);
                }
            } else if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Tried to save a weird region: " + region3 + " " + region3.getWorld() + " " + region3.getRegionX() + "_" + region3.getRegionZ() + " " + region3.getLoadState());
            }
            this.toSave.remove(region3);
        }
        this.saveAll = false;
        if (this.mapProcessor.getMapWorld().getCurrentDimensionId() != null) {
            this.workingDimList.clear();
            this.mapProcessor.getMapWorld().getDimensions(this.workingDimList);
            for (int d = 0; d < this.workingDimList.size(); ++d) {
                MapDimension dim = this.workingDimList.get(d);
                while (!dim.regionsToCache.isEmpty()) {
                    MapRegion region4 = this.removeToCache(dim, 0);
                    region4.pushWriterPause();
                    if (!region4.shouldCache() || region4.getVersion() != this.mapProcessor.getGlobalVersion()) {
                        if (WorldMap.settings.detailed_debug) {
                            System.out.println("toCache cancel: " + region4.getRegionX() + "_" + region4.getRegionZ() + " " + !region4.shouldCache() + " " + !region4.isAllCachePrepared() + " " + (region4.getVersion() != this.mapProcessor.getGlobalVersion()) + " " + region4.getVersion() + " " + this.mapProcessor.getGlobalVersion());
                        }
                        if (region4.shouldCache()) {
                            region4.deleteBuffers();
                        }
                        region4.setShouldCache(false, "toCache cancel");
                        region4.setRecacheHasBeenRequested(false, "toCache cancel");
                        region4.popWriterPause();
                        continue;
                    }
                    if (!region4.isAllCachePrepared()) {
                        throw new RuntimeException("Trying to save cache for a region with cache not prepared: " + region4);
                    }
                    File permFile = this.getCacheFile(region4, false, false);
                    File tempFile = this.getSecondaryFile(".xwmc.temp", permFile);
                    region4.saveCacheTextures(tempFile);
                    this.cacheToConvertFromTemp.add(permFile);
                    region4.setCacheFile(permFile);
                    region4.setShouldCache(false, "toCache normal");
                    region4.setRecacheHasBeenRequested(false, "toCache normal");
                    region4.popWriterPause();
                    for (int i = 0; i < this.cacheFolders.size(); ++i) {
                        Path oldCacheFolder = this.cacheFolders.get(i);
                        Path oldCacheFile = oldCacheFolder.resolve(permFile.getName());
                        Path oldPngFile = oldCacheFolder.resolve(permFile.getName().substring(0, permFile.getName().indexOf(46)) + ".png");
                        Files.deleteIfExists(oldCacheFile);
                        Files.deleteIfExists(oldPngFile);
                        if (!oldCacheFolder.getFileName().toString().startsWith("cache_")) continue;
                        Stream<Path> dirContent = Files.list(oldCacheFolder);
                        if (!dirContent.iterator().hasNext()) {
                            Files.deleteIfExists(oldCacheFolder);
                            this.cacheFolders.remove(i--);
                        }
                        dirContent.close();
                    }
                }
            }
        }
        for (int i = 0; i < this.cacheToConvertFromTemp.size(); ++i) {
            File permFile = this.cacheToConvertFromTemp.get(i);
            File tempFile = this.getSecondaryFile(".xwmc.temp", permFile);
            try {
                if (Files.exists(tempFile.toPath(), new LinkOption[0])) {
                    Files.move(tempFile.toPath(), permFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                this.cacheToConvertFromTemp.remove(i);
                --i;
                continue;
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    }

    private void requestCacheIfNeeded(MapRegion region) {
        if (!region.isBeingWritten()) {
            region.loadCacheTextures(this.mapProcessor);
        }
    }

    private void savePixel(MapBlock pixel, DataOutputStream out) throws IOException {
        boolean isGrass = pixel.isGrass();
        boolean inPalette = false;
        BlockState state = null;
        int parametres = pixel.getParametres();
        if (!isGrass && !(inPalette = this.regionSavePalette.containsKey(state = pixel.getState()))) {
            parametres |= 0x200000;
        }
        out.writeInt(parametres);
        if (!isGrass) {
            if (inPalette) {
                out.writeInt(this.regionSavePalette.get(state));
            } else {
                if (state instanceof UnknownBlockState) {
                    ((UnknownBlockState)state).write(out);
                } else {
                    CompressedStreamTools.func_74800_a((CompoundNBT)NBTUtil.func_190009_a((BlockState)state), (DataOutput)out);
                }
                this.regionSavePalette.put(state, this.regionSavePalette.size());
            }
        }
        if (pixel.getNumberOfOverlays() != 0) {
            out.write(pixel.getOverlays().size());
            for (int i = 0; i < pixel.getOverlays().size(); ++i) {
                this.saveOverlay(pixel.getOverlays().get(i), out);
            }
        }
        if (pixel.getColourType() == 3) {
            out.writeInt(pixel.getCustomColour());
        }
        if (pixel.getBiome() != -1) {
            out.write(pixel.getBiome());
        }
    }

    private void loadPixel(Integer next, MapBlock pixel, DataInputStream in, int minorSaveVersion, int majorSaveVersion, World world, int globalX, int globalZ, int[] overlayBiomeBuffer) throws IOException {
        int parametres = next != null ? next.intValue() : in.readInt();
        if ((parametres & 1) != 0) {
            if (majorSaveVersion == 0) {
                int state = in.readInt();
                pixel.setState(this.oldFormatSupport.getStateForId(state));
            } else {
                BlockState state;
                boolean paletteNew;
                boolean bl = paletteNew = (parametres & 0x200000) != 0;
                if (paletteNew) {
                    CompoundNBT nbt = CompressedStreamTools.func_74794_a((DataInputStream)in);
                    if (majorSaveVersion == 1) {
                        this.oldFormatSupport.fixBlockName1314(nbt);
                    }
                    state = WorldMap.unknownBlockStateCache.getBlockStateFromNBT(nbt);
                    this.regionLoadPalette.add(state);
                } else {
                    int paletteIndex = in.readInt();
                    state = this.regionLoadPalette.get(paletteIndex);
                }
                pixel.setState(state);
            }
        } else {
            pixel.setState(Blocks.field_196658_i.func_176223_P());
        }
        pixel.setHeightType((byte)(parametres >> 4 & 3));
        if ((parametres & 0x40) != 0) {
            pixel.setHeight(in.read());
        } else {
            pixel.setHeight(parametres >> 12 & 0xFF);
        }
        if ((parametres & 2) != 0) {
            int amount = in.read();
            this.overlayBuilder.startBuilding();
            for (int i = 0; i < amount; ++i) {
                this.loadOverlay(pixel, in, minorSaveVersion, majorSaveVersion, world, overlayBiomeBuffer);
            }
            this.overlayBuilder.finishBuilding(pixel);
        }
        pixel.setColourType((byte)(parametres >> 2 & 3));
        if (pixel.getColourType() == 3) {
            pixel.setCustomColour(in.readInt());
        }
        if (pixel.getColourType() != 0 && pixel.getColourType() != 3 || (parametres & 0x100000) != 0) {
            pixel.setBiome(in.read());
        }
        if (pixel.getColourType() == 3 && pixel.getCustomColour() == -1) {
            pixel.setColourType((byte)0);
        }
        pixel.setCaveBlock((parametres & 0x80) != 0);
        pixel.setLight((byte)(parametres >> 8 & 0xF));
        pixel.setGlowing(this.mapProcessor.getMapWriter().isGlowing(pixel.getState()));
    }

    private void saveOverlay(Overlay o, DataOutputStream out) throws IOException {
        boolean isWater = o.isWater();
        boolean inPalette = false;
        BlockState state = null;
        int parametres = o.getParametres();
        if (!isWater && !(inPalette = this.regionSavePalette.containsKey(state = o.getState()))) {
            parametres |= 0x400;
        }
        out.writeInt(parametres);
        if (!isWater) {
            if (inPalette) {
                out.writeInt(this.regionSavePalette.get(state));
            } else {
                if (state instanceof UnknownBlockState) {
                    ((UnknownBlockState)state).write(out);
                } else {
                    CompressedStreamTools.func_74800_a((CompoundNBT)NBTUtil.func_190009_a((BlockState)state), (DataOutput)out);
                }
                this.regionSavePalette.put(state, this.regionSavePalette.size());
            }
        }
        if (o.getColourType() == 2) {
            out.writeInt(o.getCustomColour());
        }
        if (o.getOpacity() > 1) {
            out.writeInt(o.getOpacity());
        }
    }

    private void loadOverlay(MapBlock pixel, DataInputStream in, int minorSaveVersion, int majorSaveVersion, World world, int[] overlayBiomeBuffer) throws IOException {
        BlockState state;
        int parametres = in.readInt();
        if ((parametres & 1) != 0) {
            if (majorSaveVersion == 0) {
                state = this.oldFormatSupport.getStateForId(in.readInt());
            } else {
                boolean paletteNew;
                boolean bl = paletteNew = (parametres & 0x400) != 0;
                if (paletteNew) {
                    CompoundNBT nbt = CompressedStreamTools.func_74794_a((DataInputStream)in);
                    state = WorldMap.unknownBlockStateCache.getBlockStateFromNBT(nbt);
                    this.regionLoadPalette.add(state);
                } else {
                    int paletteIndex = in.readInt();
                    state = this.regionLoadPalette.get(paletteIndex);
                }
            }
        } else {
            state = Blocks.field_150355_j.func_176223_P();
        }
        int opacity = 1;
        if (minorSaveVersion < 1 && (parametres & 2) != 0) {
            in.readInt();
        }
        overlayBiomeBuffer[2] = -1;
        overlayBiomeBuffer[1] = -1;
        overlayBiomeBuffer[0] = (byte)(parametres >> 8 & 3);
        if (overlayBiomeBuffer[0] == 2 || (parametres & 4) != 0) {
            overlayBiomeBuffer[0] = 2;
            overlayBiomeBuffer[2] = in.readInt();
            if (overlayBiomeBuffer[2] == -1) {
                overlayBiomeBuffer[0] = 0;
            }
        }
        if ((parametres & 8) != 0) {
            opacity = in.readInt();
        }
        byte light = (byte)(parametres >> 4 & 0xF);
        this.overlayBuilder.build(state, overlayBiomeBuffer, opacity, light, world, this.mapProcessor);
    }

    public boolean isRegionDetectionComplete() {
        return this.regionDetectionComplete;
    }

    public void setRegionDetectionComplete(boolean regionDetectionComplete) {
        this.regionDetectionComplete = regionDetectionComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCache(MapRegion region) {
        if (!this.toCacheContains(region)) {
            ArrayList<MapRegion> arrayList = region.getDim().regionsToCache;
            synchronized (arrayList) {
                region.getDim().regionsToCache.add(region);
            }
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Requesting cache! " + region.getRegionX() + "_" + region.getRegionZ());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegion removeToCache(MapDimension mapDim, int index) {
        ArrayList<MapRegion> arrayList = mapDim.regionsToCache;
        synchronized (arrayList) {
            return mapDim.regionsToCache.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToCache(MapRegion region) {
        ArrayList<MapRegion> arrayList = region.getDim().regionsToCache;
        synchronized (arrayList) {
            region.getDim().regionsToCache.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toCacheContains(MapRegion region) {
        ArrayList<MapRegion> arrayList = region.getDim().regionsToCache;
        synchronized (arrayList) {
            return region.getDim().regionsToCache.contains(region);
        }
    }

    public ArrayList<MapRegion> getToSave() {
        return this.toSave;
    }

    public MapRegion getNextToLoadByViewing() {
        return this.nextToLoadByViewing;
    }

    public void setNextToLoadByViewing(MapRegion nextToLoadByViewing) {
        this.nextToLoadByViewing = nextToLoadByViewing;
    }

    public OldFormatSupport getOldFormatSupport() {
        return this.oldFormatSupport;
    }

    public void safeDelete(Path filePath, String extension) throws IOException {
        if (!filePath.getFileName().toString().endsWith(extension)) {
            throw new RuntimeException("Incorrect file extension: " + filePath);
        }
        Files.deleteIfExists(filePath);
    }

    public void safeMove(Path fromPath, Path toPath, String fromExtension, String toExtension, CopyOption ... options) throws IOException {
        if (!toPath.getFileName().toString().endsWith(toExtension) || !fromPath.getFileName().toString().endsWith(fromExtension)) {
            throw new RuntimeException("Incorrect file extension: " + fromPath + " " + toPath);
        }
        Files.move(fromPath, toPath, options);
    }
}

