/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.Misc;
import xaero.map.WorldMap;
import xaero.map.animation.Animation;
import xaero.map.animation.SinAnimation;
import xaero.map.animation.SlowingAnimation;
import xaero.map.controls.ControlsHandler;
import xaero.map.controls.ControlsRegister;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.gui.GuiDimensionSettings;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.MapMouseButtonPress;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;

public class GuiMap
extends Screen {
    public static final VertexFormatElement TEX_2F_1 = new VertexFormatElement(1, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormatElement TEX_2F_2 = new VertexFormatElement(2, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormat POSITION_TEX_TEX_TEX = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181715_o).add((Object)TEX_2F_1).add((Object)TEX_2F_2).build());
    private static FloatBuffer brightnessBuffer = GLAllocation.func_74529_h((int)4);
    private static final double ZOOM_STEP = 1.2;
    public static final int WAYPOINT_MENU_SIZE = 7;
    private static final int white = -1;
    private static final int whiteTrans = 0x28FFFFFF;
    private static final int redTrans = 687800320;
    private static final int black = -16777216;
    private static int lastAmountOfRegionsViewed = 1;
    private long loadingAnimationStart;
    private PlayerEntity player;
    private double screenScale = 0.0;
    private int mouseDownPosX = -1;
    private int mouseDownPosY = -1;
    private int prevMouseDownPosX = -1;
    private int prevMouseDownPosY = -1;
    private float mouseDownCameraX = -1.0f;
    private float mouseDownCameraZ = -1.0f;
    private long mouseDownStartTimeNano = -1L;
    private long prevMouseDownStartTimeNano = -1L;
    private float cameraX = 0.0f;
    private float cameraZ = 0.0f;
    private int[] cameraDestination = null;
    private SlowingAnimation cameraDestinationAnimX = null;
    private SlowingAnimation cameraDestinationAnimZ = null;
    private double scale;
    private static double destScale = 3.0;
    private Waypoint viewed = null;
    private float waypointHintAlpha = 0.0f;
    private float waypointHintAlphaDest = 0.0f;
    private Animation zoomAnim;
    private SlowingAnimation waypointHintAlphaAnim = null;
    private boolean waypointMenu = false;
    private boolean shouldRenderWaypointMenu = false;
    private int waypointMenuSelected = 0;
    private int waypointMenuOffset = 0;
    private Waypoint waypointMenuSelectedObject = null;
    private Animation waypointMenuAnimation = null;
    private StringBuilder waypointMenuSearch = new StringBuilder();
    private Pattern waypointMenuSearchPattern = null;
    private Pattern waypointMenuSearchStartPattern = null;
    private static ImprovedFramebuffer primaryScaleFBO = null;
    private float[] colourBuffer = new float[4];
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private Integer lastViewedDimensionId;
    private String lastViewedMultiworldId;
    private int mouseBlockPosX;
    private int mouseBlockPosY;
    private int mouseBlockPosZ;
    private long lastStartTime;
    private List<GuiDropDown> dropdowns;
    private GuiDimensionSettings dimensionSettings;
    private MapMouseButtonPress leftMouseButton;
    private MapMouseButtonPress rightMouseButton;
    private MapProcessor mapProcessor;

    public GuiMap(MapProcessor mapProcessor, PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_world_map_screen", new Object[0]));
        this.player = player;
        this.cameraX = (float)player.func_226277_ct_();
        this.cameraZ = (float)player.func_226281_cx_();
        this.leftMouseButton = new MapMouseButtonPress();
        this.rightMouseButton = new MapMouseButtonPress();
        this.dimensionSettings = new GuiDimensionSettings(mapProcessor);
        this.dropdowns = new ArrayList<GuiDropDown>();
        this.scale = destScale * 1.5;
        this.zoomAnim = new SlowingAnimation(this.scale, destScale, 0.88, 0.001);
        this.mapProcessor = mapProcessor;
    }

    public void addButton(Button b) {
        super.addButton((Widget)b);
    }

    public void init() {
        super.init();
        this.dropdowns.clear();
        this.dimensionSettings.init(this, this.dropdowns, this.minecraft, this.width, this.height);
        this.loadingAnimationStart = System.currentTimeMillis();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
        }
        this.screenScale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        boolean toReturn = false;
        for (GuiDropDown d : this.dropdowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.height)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.height);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropdowns) {
            if (d.onDropDown((int)par1, (int)par2, this.height)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.height);
                return true;
            }
            d.setClosed(true);
        }
        toReturn = super.mouseClicked(par1, par2, par3);
        if (!toReturn) {
            if (par3 == 0) {
                this.leftMouseButton.isDown = true;
                this.leftMouseButton.pressedAtX = (int)this.minecraft.field_71417_B.func_198024_e();
                this.leftMouseButton.pressedAtY = (int)this.minecraft.field_71417_B.func_198026_f();
            } else if (par3 == 1) {
                this.rightMouseButton.isDown = true;
                this.rightMouseButton.pressedAtX = (int)this.minecraft.field_71417_B.func_198024_e();
                this.rightMouseButton.pressedAtY = (int)this.minecraft.field_71417_B.func_198026_f();
            } else if (par3 == ControlsRegister.keyOpenMap.getKey().func_197937_c()) {
                super.keyPressed(256, 1, 0);
                toReturn = true;
            }
        }
        return toReturn;
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropdowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.height);
        }
        int mouseX = (int)this.minecraft.field_71417_B.func_198024_e();
        int mouseY = (int)this.minecraft.field_71417_B.func_198026_f();
        if (this.leftMouseButton.isDown && par3 == 0) {
            this.leftMouseButton.isDown = false;
            if (Math.abs(this.leftMouseButton.pressedAtX - mouseX) < 5 && Math.abs(this.leftMouseButton.pressedAtY - mouseY) < 5) {
                this.mapClicked(0, this.leftMouseButton.pressedAtX, this.leftMouseButton.pressedAtY);
            }
            this.leftMouseButton.pressedAtX = -1;
            this.leftMouseButton.pressedAtY = -1;
        }
        if (this.rightMouseButton.isDown && par3 == 1) {
            this.rightMouseButton.isDown = false;
            if (Math.abs(this.rightMouseButton.pressedAtX - mouseX) < 5 && Math.abs(this.rightMouseButton.pressedAtY - mouseY) < 5) {
                this.mapClicked(1, this.rightMouseButton.pressedAtX, this.rightMouseButton.pressedAtY);
            }
            this.rightMouseButton.pressedAtX = -1;
            this.rightMouseButton.pressedAtY = -1;
        }
        return super.mouseReleased(par1, par2, par3);
    }

    public boolean mouseScrolled(double par1, double par2, double wheel) {
        int direction;
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            for (GuiDropDown d : this.dropdowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.height)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.height);
                return true;
            }
        }
        int n = direction = wheel > 0.0 ? 1 : -1;
        if (this.waypointMenu) {
            this.scrollWaypoints(direction);
        } else {
            this.changeZoom(wheel);
        }
        return super.mouseScrolled(par1, par2, wheel);
    }

    private void scrollWaypoints(int direction) {
        this.waypointMenuSelected += direction;
        if (this.waypointMenuSelected < 0) {
            this.waypointMenuSelected = 0;
        }
        if (this.waypointMenuSelected == this.waypointMenuOffset + 7 - 1) {
            ++this.waypointMenuOffset;
        }
        if (this.waypointMenuOffset > 0 && this.waypointMenuSelected == this.waypointMenuOffset) {
            --this.waypointMenuOffset;
        }
    }

    private void changeZoom(double factor) {
        this.cameraDestinationAnimX = null;
        this.cameraDestinationAnimZ = null;
        if ((destScale *= Math.pow(1.2, factor)) < 0.5) {
            destScale = 0.5;
        } else if (destScale > 50.0) {
            destScale = 50.0;
        }
    }

    public void removed() {
        super.removed();
        this.leftMouseButton.isDown = false;
        this.rightMouseButton.isDown = false;
    }

    public int getTextureSize(double scale) {
        if (scale >= 1.0) {
            return 16;
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int scaledMouseX, int scaledMouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        long startTime = System.currentTimeMillis();
        this.dimensionSettings.preMapRender(this, this.dropdowns, this.minecraft, this.width, this.height);
        if (!this.waypointMenu) {
            int direction;
            long passed = this.lastStartTime == 0L ? 16L : startTime - this.lastStartTime;
            double passedScrolls = (float)passed / 64.0f;
            int n = ControlsHandler.isDown(ControlsRegister.keyZoomIn) ? 1 : (direction = ControlsHandler.isDown(ControlsRegister.keyZoomOut) ? -1 : 0);
            if (direction != 0) {
                this.changeZoom((double)direction * passedScrolls);
            }
        }
        this.lastStartTime = startTime;
        if (this.cameraDestination != null) {
            this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraDestination[0], 0.9, 0.001);
            this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraDestination[1], 0.9, 0.001);
            this.cameraDestination = null;
        }
        if (this.cameraDestinationAnimX != null) {
            this.cameraX = (float)this.cameraDestinationAnimX.getCurrent();
            if ((double)this.cameraX == this.cameraDestinationAnimX.getDestination()) {
                this.cameraDestinationAnimX = null;
            }
        }
        if (this.cameraDestinationAnimZ != null) {
            this.cameraZ = (float)this.cameraDestinationAnimZ.getCurrent();
            if ((double)this.cameraZ == this.cameraDestinationAnimZ.getDestination()) {
                this.cameraDestinationAnimZ = null;
            }
        }
        this.lastViewedDimensionId = null;
        this.lastViewedMultiworldId = null;
        this.mouseBlockPosY = -1;
        Iterator<GuiDropDown> iterator = this.mapProcessor.renderThreadPauseSync;
        synchronized (iterator) {
            if (!this.mapProcessor.isRenderingPaused()) {
                if (this.mapProcessor.getCurrentWorldString() != null && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete()) {
                    MapRegion region;
                    MapTileChunk chunk;
                    this.lastViewedDimensionId = this.mapProcessor.getMapWorld().getCurrentDimension().getDimId();
                    this.lastViewedMultiworldId = this.mapProcessor.getMapWorld().getCurrentDimension().getCurrentMultiworld();
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.checkWaypoints(this.mapProcessor.getMapWorld().isMultiplayer(), this.lastViewedDimensionId, this.lastViewedMultiworldId);
                    }
                    int mouseXPos = (int)Misc.getMouseX(mc);
                    int mouseYPos = (int)Misc.getMouseY(mc);
                    if (!this.leftMouseButton.isDown) {
                        if (this.mouseDownPosX != -1) {
                            double downTime = System.nanoTime() - this.mouseDownStartTimeNano;
                            int draggedX = mouseXPos - this.mouseDownPosX;
                            int draggedY = mouseYPos - this.mouseDownPosY;
                            if ((downTime < 3.2E7 || draggedX == 0 && draggedY == 0) && this.prevMouseDownStartTimeNano != -1L) {
                                downTime = System.nanoTime() - this.prevMouseDownStartTimeNano;
                                draggedX = mouseXPos - this.prevMouseDownPosX;
                                draggedY = mouseYPos - this.prevMouseDownPosY;
                            }
                            double frameTime60FPS = 1.6666666666666666E7;
                            double speedScale = downTime / frameTime60FPS;
                            double speed_x = (double)(-draggedX) / this.scale / speedScale;
                            double speed_z = (double)(-draggedY) / this.scale / speedScale;
                            this.mouseDownPosX = -1;
                            this.prevMouseDownPosX = -1;
                            this.mouseDownPosY = -1;
                            this.prevMouseDownPosX = -1;
                            this.prevMouseDownStartTimeNano = -1L;
                            double speed = Math.sqrt(speed_x * speed_x + speed_z * speed_z);
                            if (speed > 0.0) {
                                double cos = speed_x / speed;
                                double sin = speed_z / speed;
                                speed = Math.abs(speed) > 500.0 ? Math.copySign(500.0, speed) : speed;
                                double speed_factor = 0.9;
                                double ln = Math.log(speed_factor);
                                double move_distance = -speed / ln;
                                double moveX = cos * move_distance;
                                double moveZ = sin * move_distance;
                                this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, (double)this.cameraX + moveX, 0.9, 0.001);
                                this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, (double)this.cameraZ + moveZ, 0.9, 0.001);
                            }
                        }
                    } else {
                        if (this.mouseDownPosX != -1) {
                            this.cameraX = (float)((double)(this.mouseDownPosX - mouseXPos) / this.scale + (double)this.mouseDownCameraX);
                            this.cameraZ = (float)((double)(this.mouseDownPosY - mouseYPos) / this.scale + (double)this.mouseDownCameraZ);
                        }
                        if (this.mouseDownPosX == -1 || System.nanoTime() - this.mouseDownStartTimeNano > 30000000L) {
                            this.prevMouseDownPosX = this.mouseDownPosX;
                            this.prevMouseDownPosY = this.mouseDownPosY;
                            this.prevMouseDownStartTimeNano = this.mouseDownStartTimeNano;
                            this.mouseDownPosX = mouseXPos;
                            this.mouseDownPosY = mouseYPos;
                            this.mouseDownCameraX = this.cameraX;
                            this.mouseDownCameraZ = this.cameraZ;
                            this.mouseDownStartTimeNano = System.nanoTime();
                            this.cameraDestinationAnimX = null;
                            this.cameraDestinationAnimZ = null;
                        }
                    }
                    int mouseFromCentreX = mouseXPos - mc.func_228018_at_().func_198109_k() / 2;
                    int mouseFromCentreY = mouseYPos - mc.func_228018_at_().func_198091_l() / 2;
                    double oldMousePosX = (double)mouseFromCentreX / this.scale + (double)this.cameraX;
                    double oldMousePosZ = (double)mouseFromCentreY / this.scale + (double)this.cameraZ;
                    double preScale = this.scale;
                    if (destScale != this.scale) {
                        if (this.zoomAnim != null) {
                            this.scale = this.zoomAnim.getCurrent();
                        }
                        if (this.zoomAnim == null || Misc.round(this.zoomAnim.getDestination(), 4) != Misc.round(destScale, 4)) {
                            this.zoomAnim = new SinAnimation(this.scale, destScale, 100L);
                        }
                    }
                    if (this.scale > preScale) {
                        this.cameraX = (float)(oldMousePosX - (double)mouseFromCentreX / this.scale);
                        this.cameraZ = (float)(oldMousePosZ - (double)mouseFromCentreY / this.scale);
                    }
                    RenderSystem.pushMatrix();
                    double mousePosX = (double)mouseFromCentreX / this.scale + (double)this.cameraX;
                    double mousePosZ = (double)mouseFromCentreY / this.scale + (double)this.cameraZ;
                    RenderSystem.pushMatrix();
                    RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
                    if (WorldMap.settings.displayZoom) {
                        this.drawString(mc.field_71466_p, (double)Math.round(destScale * 100.0) / 100.0 + "x", 2, 2, -1);
                    }
                    this.mouseBlockPosX = (int)Math.floor(mousePosX);
                    this.mouseBlockPosZ = (int)Math.floor(mousePosZ);
                    int mouseRegX = this.mouseBlockPosX >> 9;
                    int mouseRegZ = this.mouseBlockPosZ >> 9;
                    MapRegion reg = this.mapProcessor.getMapRegion(mouseRegX, mouseRegZ, false);
                    MapTileChunk mapTileChunk = chunk = reg != null ? reg.getChunk(this.mouseBlockPosX >> 6 & 7, this.mouseBlockPosZ >> 6 & 7) : null;
                    if (WorldMap.settings.debug) {
                        if (reg != null) {
                            if (chunk != null) {
                                MapBlock block;
                                this.drawString(mc.field_71466_p, chunk.getX() + " " + chunk.getZ(), 5, 15, -1);
                                this.drawString(mc.field_71466_p, "loadState: " + chunk.getLoadState(), 5, 25, -1);
                                this.drawString(mc.field_71466_p, "shouldUpload: " + chunk.shouldUpload(), 5, 35, -1);
                                this.drawString(mc.field_71466_p, String.format("buffers exist: %s, %s", chunk.getColorBuffer() != null, chunk.getLightBuffer() != null), 5, 45, -1);
                                this.drawString(mc.field_71466_p, "glColorTexture: " + chunk.getGlColorTexture() + " glLightTexture: " + chunk.getGlLightTexture(), 5, 55, -1);
                                this.drawString(mc.field_71466_p, String.format("success mask: %s bhv mask: %d", chunk.getSuccessMask(), chunk.getHeightValueMask() >> 12), 5, 65, -1);
                                this.drawString(mc.field_71466_p, String.format("changed: %s include: %s", chunk.wasChanged(), chunk.includeInSave()), 5, 75, -1);
                                this.drawString(mc.field_71466_p, "cachePrepared: " + chunk.isCachePrepared(), 5, 85, -1);
                                MapTile mouseTile = chunk.getTile(this.mouseBlockPosX >> 4 & 3, this.mouseBlockPosZ >> 4 & 3);
                                if (mouseTile != null && (block = mouseTile.getBlock(this.mouseBlockPosX & 0xF, this.mouseBlockPosZ & 0xF)) != null) {
                                    this.drawCenteredString(mc.field_71466_p, block.toString(), this.width / 2, 12, -1);
                                    if (block.getNumberOfOverlays() != 0) {
                                        for (int i = 0; i < block.getOverlays().size(); ++i) {
                                            this.drawCenteredString(mc.field_71466_p, block.getOverlays().get(i).toString(), this.width / 2, 22 + i * 10, -1);
                                        }
                                    }
                                }
                            }
                            this.drawString(mc.field_71466_p, "paused: " + reg.isWritingPaused(), 5, 105, -1);
                            this.drawString(mc.field_71466_p, String.format("writing: %s refreshing: %s", reg.isBeingWritten(), reg.isRefreshing()), 5, 115, -1);
                            this.drawString(mc.field_71466_p, "shouldCache: " + reg.shouldCache(), 5, 125, -1);
                            this.drawString(mc.field_71466_p, "saveExists: " + reg.getSaveExists(), 5, 135, -1);
                            this.drawString(mc.field_71466_p, mouseRegX + " " + mouseRegZ, 5, 145, -1);
                            this.drawString(mc.field_71466_p, String.format("reg loadState: %s version: %d/%d", reg.getLoadState(), reg.getVersion(), this.mapProcessor.getGlobalVersion()), 5, 155, -1);
                            this.drawString(mc.field_71466_p, "processed: " + this.mapProcessor.getToProcess().contains(reg), 5, 165, -1);
                            this.drawString(mc.field_71466_p, String.format("recache: %s reload: %s", reg.recacheHasBeenRequested(), reg.reloadHasBeenRequested()), 5, 175, -1);
                        }
                        if (this.mapProcessor.getMapWorld().isMultiplayer()) {
                            this.drawString(mc.field_71466_p, "MultiWorld ID: " + this.mapProcessor.getMapWorld().getCurrentMultiworld(), 5, 185, -1);
                        }
                        this.drawString(mc.field_71466_p, String.format("regions: %d processed: %d viewed: %d", this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegionsList().size(), this.mapProcessor.getToProcess().size(), lastAmountOfRegionsViewed), 5, 195, -1);
                        this.drawString(mc.field_71466_p, String.format("toLoad: %d toSave: %d tile pool: %d overlays: %d", this.mapProcessor.getMapSaveLoad().getSizeOfToLoad(), this.mapProcessor.getMapSaveLoad().getToSave().size(), this.mapProcessor.getTilePool().size(), this.mapProcessor.getOverlayManager().getNumberOfUniqueOverlays()), 5, 205, -1);
                        long i = Runtime.getRuntime().maxMemory();
                        long j = Runtime.getRuntime().totalMemory();
                        long k = Runtime.getRuntime().freeMemory();
                        long l = j - k;
                        int debugFPS = this.mapProcessor.getDebugFPS(mc);
                        this.drawString(mc.field_71466_p, String.format("FPS: %d", debugFPS), 5, 225, -1);
                        this.drawString(mc.field_71466_p, String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, GuiMap.bytesToMb(l), GuiMap.bytesToMb(i)), 5, 235, -1);
                        this.drawString(mc.field_71466_p, String.format("Allocated: % 2d%% %03dMB", j * 100L / i, GuiMap.bytesToMb(j)), 5, 245, -1);
                        this.drawString(mc.field_71466_p, String.format("Available VRAM: %dMB", this.mapProcessor.getMapLimiter().getAvailableVRAM() / 1024), 5, 255, -1);
                    }
                    if (chunk != null) {
                        this.mouseBlockPosY = chunk.getHeight(this.mouseBlockPosX & 0x3F, this.mouseBlockPosZ & 0x3F);
                    }
                    if (WorldMap.settings.coordinates) {
                        String coordsString = "X: " + this.mouseBlockPosX;
                        if (this.mouseBlockPosY != -1) {
                            coordsString = coordsString + " Y: " + this.mouseBlockPosY;
                        }
                        coordsString = coordsString + " Z: " + this.mouseBlockPosZ;
                        this.drawCenteredString(mc.field_71466_p, coordsString, this.width / 2, 2, -1);
                    }
                    RenderSystem.popMatrix();
                    int preferredTextureSize = this.getTextureSize(this.scale);
                    if (primaryScaleFBO == null || GuiMap.primaryScaleFBO.field_147621_c != mc.func_228018_at_().func_198109_k() || GuiMap.primaryScaleFBO.field_147618_d != mc.func_228018_at_().func_198091_l()) {
                        primaryScaleFBO = new ImprovedFramebuffer(mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), false);
                    }
                    double fboScale = 0.5;
                    if (preferredTextureSize > 8) {
                        fboScale = Math.max(1.0, Math.floor(this.scale));
                    }
                    double secondaryScale = this.scale / fboScale;
                    if (GuiMap.primaryScaleFBO.field_147616_f == -1) {
                        RenderSystem.popMatrix();
                        return;
                    }
                    primaryScaleFBO.func_147610_a(false);
                    GuiMap.fill((int)0, (int)0, (int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l(), (int)-16777216);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.scaled((double)(1.0f / (float)this.screenScale), (double)(1.0f / (float)this.screenScale), (double)1.0);
                    RenderSystem.translatef((float)(mc.func_228018_at_().func_198109_k() / 2), (float)(mc.func_228018_at_().func_198091_l() / 2), (float)0.0f);
                    RenderSystem.pushMatrix();
                    RenderSystem.disableCull();
                    int flooredCameraX = (int)Math.floor(this.cameraX);
                    int flooredCameraY = (int)Math.floor(this.cameraZ);
                    double secondaryOffsetX = (double)(this.cameraX - (float)flooredCameraX) * fboScale;
                    double secondaryOffsetY = (double)(this.cameraZ - (float)flooredCameraY) * fboScale;
                    if (fboScale == 0.5) {
                        if ((flooredCameraX & 1) != 0) {
                            --flooredCameraX;
                            secondaryOffsetX += 0.5;
                        }
                        if ((flooredCameraY & 1) != 0) {
                            --flooredCameraY;
                            secondaryOffsetY += 0.5;
                        }
                    } else {
                        int offset;
                        if (secondaryOffsetX >= 1.0) {
                            offset = (int)secondaryOffsetX;
                            RenderSystem.translatef((float)(-offset), (float)0.0f, (float)0.0f);
                            secondaryOffsetX -= (double)offset;
                        }
                        if (secondaryOffsetY >= 1.0) {
                            offset = (int)secondaryOffsetY;
                            RenderSystem.translatef((float)0.0f, (float)offset, (float)0.0f);
                            secondaryOffsetY -= (double)offset;
                        }
                    }
                    RenderSystem.scaled((double)fboScale, (double)(-fboScale), (double)1.0);
                    RenderSystem.translatef((float)(-flooredCameraX), (float)(-flooredCameraY), (float)0.0f);
                    GL11.glEnable((int)3553);
                    double leftBorder = (double)this.cameraX - (double)(mc.func_228018_at_().func_198109_k() / 2) / this.scale;
                    double rightBorder = leftBorder + (double)mc.func_228018_at_().func_198109_k() / this.scale;
                    double topBorder = (double)this.cameraZ - (double)(mc.func_228018_at_().func_198091_l() / 2) / this.scale;
                    double bottomBorder = topBorder + (double)mc.func_228018_at_().func_198091_l() / this.scale;
                    int minRegX = (int)leftBorder >> 9;
                    int maxRegX = (int)rightBorder >> 9;
                    int minRegZ = (int)topBorder >> 9;
                    int maxRegZ = (int)bottomBorder >> 9;
                    lastAmountOfRegionsViewed = (maxRegX - minRegX + 1) * (maxRegZ - minRegZ + 1);
                    if (this.mapProcessor.getMapLimiter().getMostRegionsAtATime() < lastAmountOfRegionsViewed) {
                        this.mapProcessor.getMapLimiter().setMostRegionsAtATime(lastAmountOfRegionsViewed);
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.disableAlphaTest();
                    this.regionBuffer.clear();
                    float brightness = this.mapProcessor.getBrightness();
                    for (int regX = minRegX; regX <= maxRegX; ++regX) {
                        for (int regZ = minRegZ; regZ <= maxRegZ; ++regZ) {
                            region = this.mapProcessor.getMapRegion(regX, regZ, this.mapProcessor.regionExists(regX, regZ));
                            if (region == null) continue;
                            MapRegion mapRegion = region;
                            synchronized (mapRegion) {
                                if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (region.getVersion() != this.mapProcessor.getGlobalVersion() || region.getLoadState() == 4 && region.shouldCache())) {
                                    if (region.isBeingWritten() && region.getLoadState() == 2) {
                                        region.requestRefresh(this.mapProcessor);
                                    } else {
                                        if (WorldMap.settings.detailed_debug) {
                                            WorldMap.LOGGER.info("Added to buffer: " + region + " " + region.getVersion() + " " + this.mapProcessor.getGlobalVersion());
                                        }
                                        this.regionBuffer.add(region);
                                    }
                                }
                            }
                            if (!this.mapProcessor.isUploadingPaused()) {
                                List<MapRegion> regions = this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegionsList();
                                regions.remove(region);
                                regions.add(region);
                            }
                            if (region.getLoadState() < 2) {
                                RenderSystem.pushMatrix();
                                RenderSystem.translatef((float)(512 * region.getRegionX() + 256), (float)(512 * region.getRegionZ() + 256), (float)0.0f);
                                float loadingAnimationPassed = System.currentTimeMillis() - this.loadingAnimationStart;
                                if (loadingAnimationPassed > 0.0f) {
                                    int period = 2000;
                                    int numbersOfActors = 3;
                                    float loadingAnimation = loadingAnimationPassed % (float)period / (float)period * 360.0f;
                                    float step = 360.0f / (float)numbersOfActors;
                                    RenderSystem.rotatef((float)loadingAnimation, (float)0.0f, (float)0.0f, (float)1.0f);
                                    int numberOfVisibleActors = 1 + (int)loadingAnimationPassed % (3 * period) / period;
                                    for (int i = 0; i < numberOfVisibleActors; ++i) {
                                        RenderSystem.rotatef((float)step, (float)0.0f, (float)0.0f, (float)1.0f);
                                        GuiMap.fill((int)16, (int)-8, (int)32, (int)8, (int)-1);
                                    }
                                }
                                RenderSystem.popMatrix();
                            }
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    chunk = region.getChunk(o, p);
                                    if (chunk == null || chunk.getGlColorTexture() == -1 || (double)((chunk.getX() + 1) * 64) < leftBorder || (double)(chunk.getX() * 64) > rightBorder || (double)(chunk.getZ() * 64) > bottomBorder || (double)((chunk.getZ() + 1) * 64) < topBorder || chunk.getGlColorTexture() == -1) continue;
                                    GuiMap.bindMapTextureWithLighting(brightness, chunk, 9728, preferredTextureSize == 8 ? 1 : 0);
                                    GuiMap.renderTexturedModalRectWithLighting(64.0f * (float)chunk.getX(), 64.0f * (float)chunk.getZ(), 0, 0, 64.0f, 64.0f);
                                    if (!WorldMap.settings.debug || p != 0 || chunk.getSuccessMask() == 15) continue;
                                    GuiMap.restoreTextureStates();
                                    GuiMap.fill((int)(64 * chunk.getX()), (int)(64 * chunk.getZ()), (int)(64 * (chunk.getX() + 1)), (int)(64 * (chunk.getZ() + 1)), (int)687800320);
                                }
                            }
                            GuiMap.restoreTextureStates();
                            if (!WorldMap.settings.debug) continue;
                            RenderSystem.pushMatrix();
                            RenderSystem.translatef((float)(512 * region.getRegionX() + 32), (float)(512 * region.getRegionZ() + 32), (float)0.0f);
                            RenderSystem.scaled((double)10.0, (double)10.0, (double)1.0);
                            RenderSystem.enableCull();
                            GL11.glDisable((int)2884);
                            this.drawString(mc.field_71466_p, "" + region.getLoadState(), 0, 0, -1);
                            RenderSystem.disableCull();
                            RenderSystem.popMatrix();
                        }
                    }
                    MapRegion nextToLoad = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                    boolean shouldRequest = false;
                    if (nextToLoad != null) {
                        region = nextToLoad;
                        synchronized (region) {
                            if (!nextToLoad.reloadHasBeenRequested()) {
                                shouldRequest = true;
                            }
                        }
                    } else {
                        shouldRequest = true;
                    }
                    if (shouldRequest) {
                        int toRequest = 1;
                        int counter = 0;
                        MapRegion.setComparison(this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9);
                        Collections.sort(this.regionBuffer);
                        for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                            MapRegion region2 = this.regionBuffer.get(i);
                            if (region2 == nextToLoad && this.regionBuffer.size() > 1) continue;
                            MapRegion loadingAnimation = region2;
                            synchronized (loadingAnimation) {
                                if (region2.reloadHasBeenRequested() || region2.recacheHasBeenRequested() || region2.getLoadState() != 0 && region2.getLoadState() != 4) {
                                    continue;
                                }
                                this.mapProcessor.getMapSaveLoad().requestLoad(region2, "Gui");
                                if (counter == 0) {
                                    this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region2);
                                }
                                ++counter;
                                if (region2.getLoadState() == 4) {
                                    break;
                                }
                                continue;
                            }
                        }
                    }
                    GuiMap.fill((int)((this.mouseBlockPosX >> 4) * 16), (int)((this.mouseBlockPosZ >> 4) * 16), (int)(((this.mouseBlockPosX >> 4) + 1) * 16), (int)(((this.mouseBlockPosZ >> 4) + 1) * 16), (int)0x28FFFFFF);
                    RenderSystem.enableBlend();
                    RenderSystem.enableAlphaTest();
                    RenderSystem.disableBlend();
                    RenderSystem.disableAlphaTest();
                    primaryScaleFBO.func_147609_e();
                    Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
                    RenderSystem.enableCull();
                    RenderSystem.popMatrix();
                    RenderSystem.pushMatrix();
                    RenderSystem.scaled((double)secondaryScale, (double)secondaryScale, (double)1.0);
                    primaryScaleFBO.func_147612_c();
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    int lineX = -mc.func_228018_at_().func_198109_k() / 2;
                    int lineY = mc.func_228018_at_().func_198091_l() / 2 - 5;
                    int lineW = mc.func_228018_at_().func_198109_k();
                    int lineH = 6;
                    GuiMap.fill((int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)-16777216);
                    lineX = mc.func_228018_at_().func_198109_k() / 2 - 5;
                    lineY = -mc.func_228018_at_().func_198091_l() / 2;
                    lineW = 6;
                    lineH = mc.func_228018_at_().func_198091_l();
                    GuiMap.fill((int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)-16777216);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableDepthTest();
                    GuiMap.renderTexturedModalRect((float)(-mc.func_228018_at_().func_198109_k() / 2) - (float)secondaryOffsetX, (float)(-mc.func_228018_at_().func_198091_l() / 2) - (float)secondaryOffsetY, 0, 0, mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l());
                    RenderSystem.popMatrix();
                    RenderSystem.scaled((double)this.scale, (double)this.scale, (double)1.0);
                    RenderSystem.translatef((float)(-this.cameraX), (float)(-this.cameraZ), (float)0.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.enableAlphaTest();
                    ArrayList<Waypoint> renderResult = null;
                    if (SupportMods.minimap() && WorldMap.settings.waypoints) {
                        boolean waypointMenuReal;
                        RenderSystem.disableCull();
                        Waypoint oldViewed = this.viewed;
                        renderResult = SupportMods.xaeroMinimap.renderWaypoints(this, this.cameraX, this.cameraZ, mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), this.screenScale, this.scale, mousePosX, mousePosZ, this.waypointMenuSearchPattern, this.waypointMenuSearchStartPattern, brightness);
                        boolean bl = waypointMenuReal = renderResult != null && (renderResult.size() > 1 || this.waypointMenu) && scaledMouseX > this.width - 20 && scaledMouseY > this.height - 20;
                        if (this.waypointMenu != waypointMenuReal) {
                            int animationEnd;
                            this.waypointMenu = waypointMenuReal;
                            int animationStart = this.waypointMenuAnimation != null ? (int)this.waypointMenuAnimation.getCurrent() : (this.waypointMenu ? 500 : 0);
                            int n = animationEnd = this.waypointMenu ? 0 : 500;
                            if (this.waypointMenu) {
                                this.waypointMenuAnimation = new SlowingAnimation(animationStart, animationEnd, 0.7, 0.001);
                                this.shouldRenderWaypointMenu = true;
                            } else {
                                this.waypointMenuAnimation = new Animation(animationStart, animationEnd, 500L);
                            }
                        }
                        if (!this.shouldRenderWaypointMenu) {
                            this.waypointMenuSelected = 0;
                            this.waypointMenuOffset = 0;
                        }
                        Waypoint waypoint = this.viewed = renderResult != null ? renderResult.remove(0) : null;
                        if (this.viewed != oldViewed) {
                            this.waypointHintAlphaDest = this.viewed != null ? 255.0f : 0.0f;
                            this.waypointHintAlphaAnim = new SlowingAnimation(this.waypointHintAlpha, this.waypointHintAlphaDest, this.waypointHintAlpha < this.waypointHintAlphaDest ? 0.9 : 0.95, 1.0);
                        }
                        if (this.waypointHintAlphaAnim != null) {
                            this.waypointHintAlpha = (float)this.waypointHintAlphaAnim.getCurrent();
                        }
                        RenderSystem.enableCull();
                        RenderSystem.enableBlend();
                    } else {
                        this.viewed = null;
                    }
                    if (WorldMap.settings.footsteps) {
                        for (int i = 0; i < this.mapProcessor.getFootprints().size(); ++i) {
                            Double[] coords = this.mapProcessor.getFootprints().get(i);
                            this.setColourBuffer(1.0f, 0.1f, 0.1f, 1.0f);
                            this.drawDotOnMap(coords[0], coords[1], 0.0f, 1.0 / this.scale);
                        }
                    }
                    if (WorldMap.settings.renderArrow) {
                        boolean toTheLeft = this.player.func_226277_ct_() < leftBorder;
                        boolean toTheRight = this.player.func_226277_ct_() > rightBorder;
                        boolean down = this.player.func_226281_cx_() > bottomBorder;
                        boolean up = this.player.func_226281_cx_() < topBorder;
                        RenderSystem.enableBlend();
                        if (toTheLeft || toTheRight || up || down) {
                            double arrowX = this.player.func_226277_ct_();
                            double arrowZ = this.player.func_226281_cx_();
                            float a = 0.0f;
                            if (toTheLeft) {
                                a = up ? 1.5f : (down ? 0.5f : 1.0f);
                                arrowX = leftBorder;
                            } else if (toTheRight) {
                                a = up ? 2.5f : (down ? 3.5f : 3.0f);
                                arrowX = rightBorder;
                            }
                            if (down) {
                                arrowZ = bottomBorder;
                            } else if (up) {
                                if (a == 0.0f) {
                                    a = 2.0f;
                                }
                                arrowZ = topBorder;
                            }
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawFarArrowOnMap(arrowX, arrowZ + 2.0 / this.scale, a, 1.0 / this.scale);
                            this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                            this.drawFarArrowOnMap(arrowX, arrowZ, a, 1.0 / this.scale);
                        } else {
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawArrowOnMap(this.player.func_226277_ct_(), this.player.func_226281_cx_() + 2.0 / this.scale, this.player.field_70177_z, 1.0 / this.scale);
                            this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                            this.drawArrowOnMap(this.player.func_226277_ct_(), this.player.func_226281_cx_(), this.player.field_70177_z, 1.0 / this.scale);
                        }
                    }
                    RenderSystem.popMatrix();
                    if (this.shouldRenderWaypointMenu && renderResult != null) {
                        if (this.waypointMenuSelected >= renderResult.size()) {
                            this.waypointMenuSelected = renderResult.size() - 1;
                            this.waypointMenuOffset = Math.max(this.waypointMenuSelected - 7 + 2, 0);
                        }
                        if (this.waypointMenuSelected < 0) {
                            this.waypointMenuSelected = 0;
                        }
                        this.waypointMenuSelectedObject = renderResult.size() > 0 ? (Waypoint)renderResult.get(this.waypointMenuSelected) : null;
                        SupportMods.xaeroMinimap.renderSideWaypoints(this, renderResult, this.scale, this.width + (int)this.waypointMenuAnimation.getCurrent(), this.height, this.waypointMenuOffset, this.waypointMenuSelected);
                        if (this.waypointMenu && this.waypointMenuSearch != null && this.waypointMenuSearch.length() > 0) {
                            this.drawCenteredString(mc.field_71466_p, this.waypointMenuSearch.toString(), this.width / 2, this.height - 15, -1);
                        }
                        if (!this.waypointMenu && this.waypointMenuAnimation.getCurrent() == this.waypointMenuAnimation.getDestination()) {
                            this.shouldRenderWaypointMenu = false;
                            this.waypointMenuSearch = new StringBuilder();
                            this.waypointMenuSearchPattern = null;
                            this.waypointMenuSearchStartPattern = null;
                        }
                    }
                    this.dimensionSettings.renderText(this.minecraft, scaledMouseX, scaledMouseY, this.width, this.height);
                    if ((int)this.waypointHintAlpha > 3) {
                        int hintColour = (int)this.waypointHintAlpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                        RenderSystem.enableBlend();
                        RenderSystem.enableAlphaTest();
                        if (SupportMods.xaeroMinimap.canTeleport()) {
                            this.drawCenteredString(mc.field_71466_p, "Edit - Right Click     Teleport - T     Disable - H     Delete - Delete", this.width / 2, this.height - 25, hintColour);
                        } else {
                            this.drawCenteredString(mc.field_71466_p, "Edit - Right Click     Disable - H     Delete - Delete", this.width / 2, this.height - 25, hintColour);
                        }
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    this.renderLoadingScreen();
                }
            } else {
                this.renderLoadingScreen();
            }
            mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
            this.blit(this.width - 35, 2, 0, 37, 32, 32);
        }
        RenderSystem.enableDepthTest();
        super.render(scaledMouseX, scaledMouseY, partialTicks);
        for (GuiDropDown d : this.dropdowns) {
            if (!d.isClosed()) continue;
            d.drawButton(scaledMouseX, scaledMouseY, this.height);
        }
        for (GuiDropDown d : this.dropdowns) {
            if (d.isClosed()) continue;
            d.drawButton(scaledMouseX, scaledMouseY, this.height);
        }
        this.dimensionSettings.postMapRender(this.minecraft, scaledMouseX, scaledMouseY, this.width, this.height);
    }

    private void renderLoadingScreen() {
        GuiMap.fill((int)0, (int)0, (int)this.minecraft.func_228018_at_().func_198109_k(), (int)this.minecraft.func_228018_at_().func_198091_l(), (int)-16777216);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
        this.drawCenteredString(this.minecraft.field_71466_p, "Preparing World Map...", this.minecraft.func_228018_at_().func_198107_o() / 2, this.minecraft.func_228018_at_().func_198087_p() / 2, -1);
        RenderSystem.popMatrix();
    }

    public void drawDotOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 2.5f, 2.5f, 0, 69, 5, 5, 9729);
    }

    public void drawArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 13.0f, 5.0f, 0, 0, 28, 29, 9729);
    }

    public void drawFarArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle * 90.0f, sc, 27.0f, 13.0f, 26, 0, 54, 13, 9729);
    }

    public void drawObjectOnMap(double x, double z, float angle, double sc, float offX, float offY, int textureX, int textureY, int w, int h, int filter) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)this.colourBuffer[0], (float)this.colourBuffer[1], (float)this.colourBuffer[2], (float)this.colourBuffer[3]);
        RenderSystem.translated((double)x, (double)z, (double)0.0);
        RenderSystem.scaled((double)sc, (double)sc, (double)1.0);
        if (angle != 0.0f) {
            RenderSystem.rotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.minecraft.func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GuiMap.renderTexturedModalRect(-offX, -offY, textureX, textureY, w, h, 256.0f, 256.0f);
        if (filter != 9728) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public static void renderTexturedModalRectWithLighting(float x, float y, int textureX, int textureY, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, POSITION_TEX_TEX_TEX);
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + height), 0.0);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 1.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 1.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + 0.0f), 0.0);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 1.0f, 0.0f);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + 0.0f), 0.0);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        GuiMap.anyIndexFloatUV(vertexBuffer, 0.0f, 0.0f);
        vertexBuffer.func_181675_d();
        tessellator.func_78381_a();
    }

    private static void anyIndexFloatUV(BufferBuilder vertexBuffer, float u, float v) {
        vertexBuffer.func_225590_a_(0, u);
        vertexBuffer.func_225590_a_(4, v);
        vertexBuffer.func_181667_k();
    }

    public static void renderTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float textureWidth, float textureHeight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float normalizedTextureX = (float)textureX / textureWidth;
        float normalizedTextureY = (float)textureY / textureHeight;
        float normalizedTextureX2 = ((float)textureX + width) / textureWidth;
        float normalizedTextureY2 = ((float)textureY + height) / textureHeight;
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + height), 0.0).func_225583_a_(normalizedTextureX, normalizedTextureY2).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(normalizedTextureX2, normalizedTextureY2).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + 0.0f), 0.0).func_225583_a_(normalizedTextureX2, normalizedTextureY).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_225583_a_(normalizedTextureX, normalizedTextureY).func_181675_d();
        tessellator.func_78381_a();
    }

    public void mapClicked(int button, int x, int y) {
        if (!this.waypointMenu && this.viewed != null) {
            SupportMods.xaeroMinimap.openWaypoint(this, this.viewed);
            this.mouseDownPosX = -1;
            this.mouseDownPosY = -1;
        }
        if (this.waypointMenu && this.waypointMenuSelectedObject != null) {
            this.cameraDestination = new int[]{this.waypointMenuSelectedObject.getX(), this.waypointMenuSelectedObject.getZ()};
        }
    }

    private void setSearch(String search, String preChange) {
        try {
            this.waypointMenuSearchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.waypointMenuSearchStartPattern = search.charAt(0) == '^' ? this.waypointMenuSearchPattern : Pattern.compile('^' + search.toString().toLowerCase());
            } else {
                this.waypointMenuSearchPattern = null;
                this.waypointMenuSearchStartPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            if (preChange != null) {
                this.waypointMenuSearch = new StringBuilder(preChange);
                this.setSearch(preChange, null);
            }
            throw e;
        }
    }

    public boolean charTyped(char par1, int par2) {
        if (this.waypointMenu) {
            String preChange = this.waypointMenuSearch.toString();
            this.waypointMenuSearch.append(par1);
            this.setSearch(this.waypointMenuSearch.toString(), preChange);
        }
        return super.charTyped(par1, par2);
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (this.waypointMenu) {
            if (par1 != 0) {
                if (par1 == ControlsRegister.keyZoomIn.getKey().func_197937_c()) {
                    this.scrollWaypoints(1);
                } else if (par1 == ControlsRegister.keyZoomOut.getKey().func_197937_c()) {
                    this.scrollWaypoints(-1);
                } else {
                    String preChange = this.waypointMenuSearch.toString();
                    if (par1 == 259) {
                        if (this.waypointMenuSearch.length() > 0) {
                            this.waypointMenuSearch.deleteCharAt(this.waypointMenuSearch.length() - 1);
                        }
                    } else if (par1 == 257) {
                        this.waypointMenuSearch = new StringBuilder();
                    }
                    this.setSearch(this.waypointMenuSearch.toString(), preChange);
                }
            }
        } else {
            if (par1 == ControlsRegister.keyOpenMap.getKey().func_197937_c()) {
                return super.keyPressed(256, 1, par3);
            }
            if (par1 == 257 && this.dimensionSettings.active) {
                this.dimensionSettings.confirm(this, this.minecraft, this.width, this.height);
            }
            if (this.viewed != null) {
                switch (par1) {
                    case 72: {
                        SupportMods.xaeroMinimap.disableWaypoint(this.viewed);
                        break;
                    }
                    case 261: {
                        SupportMods.xaeroMinimap.deleteWaypoint(this.viewed);
                    }
                }
            }
        }
        return super.keyPressed(par1, par2, par3);
    }

    public boolean func_223281_a_(int par1, int par2, int par3) {
        if (!this.waypointMenu && SupportMods.minimap() && this.lastViewedDimensionId != null) {
            if (this.viewed != null) {
                switch (par1) {
                    case 84: {
                        SupportMods.xaeroMinimap.teleportToWaypoint(this, this.viewed);
                    }
                }
            }
            if (par1 == SupportMods.xaeroMinimap.getWaypointKeyCode() && WorldMap.settings.waypoints && this.mouseBlockPosY != -1) {
                SupportMods.xaeroMinimap.createWaypoint(this, this.mouseBlockPosX, this.mouseBlockPosY + 1, this.mouseBlockPosZ);
            }
            if (par1 == SupportMods.xaeroMinimap.getTempWaypointKeyCode() && WorldMap.settings.waypoints && this.mouseBlockPosY != -1) {
                SupportMods.xaeroMinimap.createTempWaypoint(this.mouseBlockPosX, this.mouseBlockPosY + 1, this.mouseBlockPosZ);
            }
        }
        return super.func_223281_a_(par1, par2, par3);
    }

    public static void bindMapTextureWithLighting(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        int glLightTexture = chunk.getGlLightTexture();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.enableTexture();
        if (glLightTexture != -1) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            chunk.bindLightTexture(false, magFilter);
            float toSubtract = 1.0f - brightness;
            brightnessBuffer.position(0);
            brightnessBuffer.put(toSubtract);
            brightnessBuffer.put(toSubtract);
            brightnessBuffer.put(toSubtract);
            brightnessBuffer.put(1.0f);
            brightnessBuffer.flip();
            GL11.glTexEnvfv((int)8960, (int)8705, (FloatBuffer)brightnessBuffer);
            GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
            GL11.glTexEnvi((int)8960, (int)34161, (int)34023);
            GL11.glTexEnvi((int)8960, (int)34176, (int)5890);
            GL11.glTexEnvi((int)8960, (int)34192, (int)769);
            GL11.glTexEnvi((int)8960, (int)34177, (int)34166);
            GL11.glTexEnvi((int)8960, (int)34193, (int)768);
            GL11.glTexEnvi((int)8960, (int)34162, (int)7681);
            GL11.glTexEnvi((int)8960, (int)34184, (int)34166);
            GL11.glTexEnvi((int)8960, (int)34200, (int)770);
        } else {
            RenderSystem.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            chunk.bindColorTexture(false, magFilter);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        }
        RenderSystem.activeTexture((int)33985);
        RenderSystem.matrixMode((int)5890);
        RenderSystem.loadIdentity();
        if (glLightTexture != -1) {
            RenderSystem.enableTexture();
            chunk.bindLightTexture(false, magFilter);
            GL11.glTexEnvi((int)8960, (int)8704, (int)260);
        } else {
            RenderSystem.disableTexture();
        }
        RenderSystem.activeTexture((int)33986);
        RenderSystem.loadIdentity();
        if (glLightTexture != -1) {
            RenderSystem.enableTexture();
            chunk.bindColorTexture(false, magFilter);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        } else {
            RenderSystem.disableTexture();
        }
        RenderSystem.matrixMode((int)5888);
    }

    public static void restoreTextureStates() {
        RenderSystem.activeTexture((int)33985);
        RenderSystem.disableTexture();
        RenderSystem.activeTexture((int)33986);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        RenderSystem.disableTexture();
        RenderSystem.activeTexture((int)33984);
        GL11.glTexEnvi((int)8960, (int)34161, (int)8448);
        GL11.glTexEnvi((int)8960, (int)34192, (int)768);
        GL11.glTexEnvi((int)8960, (int)34177, (int)34168);
        GL11.glTexEnvi((int)8960, (int)34162, (int)8448);
        GL11.glTexEnvi((int)8960, (int)34184, (int)5890);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private void setColourBuffer(float r, float g, float b, float a) {
        this.colourBuffer[0] = r;
        this.colourBuffer[1] = g;
        this.colourBuffer[2] = b;
        this.colourBuffer[3] = a;
    }
}

