/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.MapProcessor;
import xaero.map.gui.MySmallButton;
import xaero.map.world.MapDimension;

public class GuiMapName
extends Screen {
    private Screen parentGuiScreen;
    private TextFieldWidget nameTextField;
    private MapDimension mapDimension;
    private String editingMWId;
    private String currentNameFieldContent;
    private MapProcessor mapProcessor;

    public GuiMapName(MapProcessor mapProcessor, Screen par1GuiScreen, MapDimension mapDimension, String editingMWId) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_map_name", new Object[0]));
        this.parentGuiScreen = par1GuiScreen;
        this.mapDimension = mapDimension;
        this.editingMWId = editingMWId;
        this.currentNameFieldContent = editingMWId == null ? "" : mapDimension.getMultiworldName(editingMWId);
        this.mapProcessor = mapProcessor;
    }

    public void init() {
        super.init();
        if (this.nameTextField != null) {
            this.currentNameFieldContent = this.nameTextField.func_146179_b();
        }
        this.nameTextField = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, I18n.func_135052_a((String)"gui.xaero_map_name", (Object[])new Object[0]));
        this.nameTextField.func_146180_a(this.currentNameFieldContent);
        this.setFocused((IGuiEventListener)this.nameTextField);
        this.nameTextField.func_146195_b(true);
        this.children.add(this.nameTextField);
        this.addButton((Widget)new MySmallButton(this.width / 2 - 155, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            if (this.canConfirm()) {
                Object object = this.mapProcessor.uiSync;
                synchronized (object) {
                    if (this.mapProcessor.getMapWorld() == this.mapDimension.getMapWorld()) {
                        String mwIdFixed;
                        String unfilteredName = this.nameTextField.func_146179_b();
                        if (this.editingMWId == null) {
                            String mwId = unfilteredName.toLowerCase().replaceAll("[^a-z0-9]+", "");
                            if (mwId.isEmpty()) {
                                mwId = "map";
                            }
                            mwId = "mw$" + mwId;
                            boolean mwAdded = false;
                            mwIdFixed = mwId;
                            int fix = 1;
                            while (!mwAdded) {
                                mwAdded = this.mapDimension.addMultiworldChecked(mwIdFixed);
                                if (mwAdded) continue;
                                mwIdFixed = mwId + ++fix;
                            }
                            Path dimensionFolderPath = this.mapDimension.getMainFolderPath();
                            Path multiworldFolderPath = dimensionFolderPath.resolve(mwIdFixed);
                            try {
                                Files.createDirectories(multiworldFolderPath, new FileAttribute[0]);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            this.mapDimension.setMultiworldUnsynced(mwIdFixed);
                        } else {
                            mwIdFixed = this.editingMWId;
                        }
                        this.mapDimension.setMultiworldName(mwIdFixed, unfilteredName);
                        this.mapDimension.saveConfigUnsynced();
                        this.minecraft.func_147108_a(this.parentGuiScreen);
                    }
                }
            }
        }));
        this.addButton((Widget)new MySmallButton(this.width / 2 + 5, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.minecraft.func_147108_a(this.parentGuiScreen)));
        this.minecraft.field_195559_v.func_197967_a(true);
        this.updateConfirmButton();
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    private boolean canConfirm() {
        return this.nameTextField.func_146179_b().length() > 0;
    }

    private void updateConfirmButton() {
        ((Button)this.buttons.get((int)0)).active = this.canConfirm();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257 && this.canConfirm()) {
            ((Widget)this.buttons.get(0)).onClick(0.0, 0.0);
            return true;
        }
        return result;
    }

    public void tick() {
        this.updateConfirmButton();
        this.nameTextField.func_146178_a();
    }

    public void render(int par1, int par2, float par3) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        this.nameTextField.render(par1, par2, par3);
        super.render(par1, par2, par3);
    }
}

