/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.MySmallButton;
import xaero.map.gui.MyTinyButton;
import xaero.map.settings.ModOptions;

public class GuiWorldMapSettings
extends GuiSettings {
    private static final int PAGES = 2;
    public Button pngButton;
    public Button prevButton;
    public Button nextButton;
    private int page;

    public GuiWorldMapSettings() {
        this(null);
    }

    public GuiWorldMapSettings(Screen parent) {
        super(parent, WorldMap.settings, (ITextComponent)new TranslationTextComponent("gui.xaero_world_map_settings", new Object[0]));
    }

    @Override
    public void init() {
        if (this.page == 0) {
            this.options = new ModOptions[]{ModOptions.LIGHTING, ModOptions.COLOURS, ModOptions.LOAD, ModOptions.UPDATE, ModOptions.DEPTH, ModOptions.SLOPES, ModOptions.STEPS, ModOptions.COORDINATES, ModOptions.WAYPOINTS, ModOptions.BIOMES, ModOptions.WAYPOINT_SCALE};
            this.pngButton = new MySmallButton(this.width / 2 + 5, this.height / 7 + 120, "Export PNG", b -> {
                this.pngButton.active = false;
                WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                mapProcessor.getMapSaveLoad().exportPNG();
                Util.func_110647_a().func_195641_a(WorldMap.configFolder.toPath().getParent().resolve("map exports").toFile());
                this.pngButton.active = true;
            });
            this.addButton((Widget)this.pngButton);
            this.pngButton.active = Minecraft.func_71410_x().field_71439_g != null;
        } else {
            this.options = new ModOptions[]{ModOptions.FLOWERS, ModOptions.DISPLAY_ZOOM, ModOptions.COMPRESSION, ModOptions.ARROW, ModOptions.IGNORE_HEIGHTMAPS, ModOptions.DEBUG};
        }
        this.nextButton = new MyTinyButton(this.width / 2 + 80, this.height / 7 + 144, I18n.func_135052_a((String)"gui.xaero_wm_next", (Object[])new Object[0]), b -> this.onNextButton());
        this.addButton((Widget)this.nextButton);
        this.nextButton.active = this.isNextButtonEnabled();
        this.prevButton = new MyTinyButton(this.width / 2 - 155, this.height / 7 + 144, I18n.func_135052_a((String)"gui.xaero_wm_previous", (Object[])new Object[0]), b -> this.onPrevButton());
        this.addButton((Widget)this.prevButton);
        this.prevButton.active = this.isPrevButtonEnabled();
        super.init();
    }

    private void onPrevButton() {
        --this.page;
        if (this.page < 0) {
            this.page = 0;
        }
        this.init(this.minecraft, this.width, this.height);
    }

    private void onNextButton() {
        ++this.page;
        if (this.page >= 2) {
            this.page = 1;
        }
        this.init(this.minecraft, this.width, this.height);
    }

    private boolean isPrevButtonEnabled() {
        return this.page > 0;
    }

    private boolean isNextButtonEnabled() {
        return this.page < 1;
    }

    @Override
    public void render(int par1, int par2, float par3) {
        super.render(par1, par2, par3);
        for (int k = 0; k < this.buttons.size(); ++k) {
            Widget b = (Widget)this.buttons.get(k);
            if (par1 >= b.x && par2 >= b.y && par1 < b.x + 150 && par2 >= b.y + 20) continue;
        }
    }
}

