/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.region.MapBlock;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;

public class MapPixel {
    protected BlockState state;
    protected byte colourType = (byte)-1;
    protected int customColour;
    protected byte light = 0;
    protected boolean glowing = false;

    public void getPixelColours(int[] result_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTile prevTile, MapTile mapTile, int x, int z, MapBlock block, int height, ArrayList<Overlay> overlays, BlockPos.Mutable mutableGlobalPos) {
        int colour = 0;
        int topLightValue = this.light;
        float brightness = 1.0f;
        mutableGlobalPos.func_181079_c(mapTile.getChunkX() * 16 + x, height, mapTile.getChunkZ() * 16 + z);
        if (this.state.func_177230_c() != Blocks.field_150350_a) {
            if (WorldMap.settings.colours == 0) {
                colour = mapWriter.loadBlockColourFromTexture(this.state, true, world, (BlockPos)mutableGlobalPos);
            } else {
                try {
                    colour = this.state.func_177230_c() instanceof FlowingFluidBlock && RenderTypeLookup.canRenderInLayer((IFluidState)this.state.func_204520_s(), (RenderType)RenderType.func_228645_f_()) ? 25825 : this.state.func_185909_g((IBlockReader)world, (BlockPos)mutableGlobalPos).field_76291_p;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        boolean isFinalBlock = this instanceof MapBlock;
        if (!isFinalBlock && ((Overlay)this).isWater()) {
            this.colourType = 1;
        }
        if (this.colourType == -1) {
            if (isFinalBlock) {
                mapWriter.getColorTypeCache().getBlockBiomeColour(world, this.state, (BlockPos)mutableGlobalPos, result_dest, block.getBiome());
                this.colourType = (byte)result_dest[0];
                if (result_dest[1] != -1) {
                    block.setBiome(result_dest[1]);
                }
                this.customColour = result_dest[2];
            } else {
                mapWriter.getColorTypeCache().getOverlayBiomeColour(world, this.state, (BlockPos)mutableGlobalPos, result_dest, 1);
                this.colourType = (byte)result_dest[0];
                this.customColour = result_dest[2];
            }
        }
        if (this.colourType != 0 && (WorldMap.settings.biomeColorsVanillaMode || WorldMap.settings.colours == 0)) {
            int c = this.customColour;
            if (isFinalBlock) {
                if (this.colourType == 1) {
                    c = mapWriter.getBiomeColor(0, mutableGlobalPos, mapTile, world);
                } else if (this.colourType == 2) {
                    c = mapWriter.getBiomeColor(1, mutableGlobalPos, mapTile, world);
                }
            } else if (this.colourType == 1) {
                c = mapWriter.getBiomeColor(2, mutableGlobalPos, mapTile, world);
            }
            float rMultiplier = (float)r / 255.0f;
            float gMultiplier = (float)g / 255.0f;
            float bMultiplier = (float)b / 255.0f;
            r = (int)((float)(c >> 16 & 0xFF) * rMultiplier);
            g = (int)((float)(c >> 8 & 0xFF) * gMultiplier);
            b = (int)((float)(c & 0xFF) * bMultiplier);
        }
        if (this.glowing) {
            int brightest = Math.max(r, Math.max(g, b));
            if (brightest != 0) {
                r = r * 255 / brightest;
                g = g * 255 / brightest;
                b = b * 255 / brightest;
            }
            topLightValue = 15;
        }
        int overlayRed = 0;
        int overlayGreen = 0;
        int overlayBlue = 0;
        float divider = 1.0f;
        if (overlays != null && !overlays.isEmpty()) {
            int sun = 15;
            for (int i = 0; i < overlays.size(); ++i) {
                Overlay o = overlays.get(i);
                o.getPixelColour(block, result_dest, mapWriter, world, tileChunk, prevChunk, prevTile, mapTile, x, z, mutableGlobalPos);
                if (i == 0) {
                    topLightValue = o.light;
                }
                float overlayIntensity = (float)o.getIntensity() * this.getBlockBrightness(5.0f, o.light, sun);
                divider += overlayIntensity;
                overlayRed = (int)((float)overlayRed + (float)result_dest[0] * overlayIntensity);
                overlayGreen = (int)((float)overlayGreen + (float)result_dest[1] * overlayIntensity);
                overlayBlue = (int)((float)overlayBlue + (float)result_dest[2] * overlayIntensity);
                if ((sun -= o.getOpacity()) >= 0) continue;
                sun = 0;
            }
            if (!this.glowing) {
                brightness = this.getBlockBrightness(5.0f, this.light, sun);
            }
        }
        if (isFinalBlock & !this.glowing) {
            if (block.getHeightType() != 3 && (mutableGlobalPos.func_177952_p() & 0x1FF) == 0) {
                block.setHeightType((byte)3);
            }
            if (block.getHeightType() == 3 && block.getState().func_177230_c() != Blocks.field_150350_a) {
                block.fixHeightType(x, z, prevTile, mapTile, tileChunk, prevChunk);
                if (block.getHeightType() != 3 && (mutableGlobalPos.func_177952_p() & 0x1FF) != 0 && tileChunk.getInRegion().isMultiplayer()) {
                    tileChunk.getInRegion().setBeingWritten(true);
                }
            }
            float depthBrightness = 1.0f;
            int block_height = block.getHeight();
            boolean caving = block.isCaveBlock() && block_height != -1 && block_height < 127;
            float caveBrightness = (float)block_height / 127.0f;
            if (!caving && WorldMap.settings.terrainDepth && block_height != -1) {
                depthBrightness = (float)height / 63.0f;
                if ((double)depthBrightness > 1.15) {
                    depthBrightness = 1.15f;
                } else if ((double)depthBrightness < 0.7) {
                    depthBrightness = 0.7f;
                }
            }
            if (WorldMap.settings.terrainSlopes) {
                if (block.getHeightType() == 1) {
                    depthBrightness = (float)((double)depthBrightness * 1.15);
                } else if (block.getHeightType() == 2) {
                    depthBrightness = (float)((double)depthBrightness * 0.85);
                }
            }
            if (caving) {
                brightness = caveBrightness;
            }
            if ((brightness *= depthBrightness) < 0.0f) {
                brightness = 0.0f;
            }
        }
        result_dest[0] = (int)(((float)r * brightness + (float)overlayRed) / divider);
        if (result_dest[0] > 255) {
            result_dest[0] = 255;
        }
        result_dest[1] = (int)(((float)g * brightness + (float)overlayGreen) / divider);
        if (result_dest[1] > 255) {
            result_dest[1] = 255;
        }
        result_dest[2] = (int)(((float)b * brightness + (float)overlayBlue) / divider);
        if (result_dest[2] > 255) {
            result_dest[2] = 255;
        }
        result_dest[3] = (int)(this.getPixelLight(topLightValue) * 255.0f);
    }

    public float getBlockBrightness(float min, int l, int sun) {
        return (min + (float)Math.max(sun, l)) / (15.0f + min);
    }

    private float getPixelLight(int topLightValue) {
        return topLightValue == 0 ? 0.0f : (float)(5 + topLightValue) / 20.0f;
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public void setLight(byte light) {
        this.light = light;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    public byte getColourType() {
        return this.colourType;
    }

    public void setColourType(byte colourType) {
        this.colourType = colourType;
    }

    public int getCustomColour() {
        return this.customColour;
    }

    public void setCustomColour(int customColour) {
        this.customColour = customColour;
    }
}

