/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xaero.map.MapWriter;
import xaero.map.region.MapBlock;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;

public class Overlay
extends MapPixel {
    private short opacity;
    private byte intensity;

    public Overlay(BlockState state, int[] biome, int intensity, byte light, boolean glowing) {
        this.write(state, biome, intensity, light, glowing);
    }

    public void write(BlockState state, int[] biome, int intensity, byte light, boolean glowing) {
        this.opacity = 0;
        this.state = state;
        this.colourType = (byte)biome[0];
        this.customColour = (byte)biome[2];
        this.intensity = (byte)intensity;
        this.light = light;
        this.glowing = glowing;
    }

    public boolean isWater() {
        return this.state.func_177230_c() == Blocks.field_150355_j;
    }

    public int getParametres() {
        int parametres = 0;
        parametres |= !this.isWater() ? 1 : 0;
        parametres |= this.opacity > 1 ? 8 : 0;
        parametres |= this.light << 4;
        return parametres |= this.colourType << 8;
    }

    public void getPixelColour(MapBlock block, int[] result_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTile prevTile, MapTile mapTile, int x, int z, BlockPos.Mutable mutableGlobalPos) {
        super.getPixelColours(result_dest, mapWriter, world, tileChunk, prevChunk, prevTile, mapTile, x, z, block, -1, null, mutableGlobalPos);
    }

    public String toString() {
        return "(S: " + this.getState() + ", CT: " + this.colourType + ", CC: " + this.getCustomColour() + ", I: " + this.intensity + ", O: " + this.opacity + ", L: " + this.light + ")";
    }

    public boolean equals(Overlay p) {
        return p != null && this.opacity == p.opacity && this.intensity == p.intensity && this.light == p.light && this.getState() == p.getState();
    }

    void fillManagerKeyHolder(Object[] keyHolder) {
        keyHolder[0] = this.state;
        keyHolder[1] = this.colourType;
        keyHolder[2] = this.customColour;
        keyHolder[3] = this.light;
        keyHolder[4] = this.opacity;
    }

    public int getIntensity() {
        return this.intensity;
    }

    public void setIntensity(int intensity) {
        this.intensity = (byte)intensity;
    }

    public void increaseOpacity(int toAdd) {
        this.opacity = (short)(this.opacity + toAdd);
    }

    public int getOpacity() {
        return this.opacity;
    }
}

