/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.block;

import com.bagel.atmospheric.common.block.AloeVeraBlock;
import com.bagel.atmospheric.common.block.AridSandBlock;
import com.bagel.atmospheric.core.other.AtmosphericCriteriaTriggers;
import com.bagel.atmospheric.core.other.AtmosphericDamageSources;
import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.bagel.atmospheric.core.registry.AtmosphericItems;
import com.bagel.atmospheric.core.registry.AtmosphericParticles;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class AloeVeraTallBlock
extends DoublePlantBlock
implements IGrowable {
    public static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE_TOP = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)6, (int)8);

    public AloeVeraTallBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(6))).func_206870_a((IProperty)field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vec3d vec3d = state.func_191059_e(worldIn, pos);
        VoxelShape shape = state.func_177229_b((IProperty)field_176492_b) == DoubleBlockHalf.UPPER ? SHAPE_TOP : SHAPE;
        return shape.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176492_b, AGE});
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b((IProperty)field_176492_b);
        if (half == DoubleBlockHalf.UPPER) {
            return block instanceof AridSandBlock || block instanceof AloeVeraTallBlock;
        }
        return block instanceof AridSandBlock;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            if (!(entityIn instanceof BeeEntity)) {
                entityIn.func_213295_a(state, new Vec3d((double)0.8f, 0.75, (double)0.8f));
            }
            Random rand = new Random();
            for (int i = 0; i < 3; ++i) {
                double offsetX = rand.nextFloat() * 0.6f;
                double offsetZ = rand.nextFloat() * 0.45f;
                double x = (double)pos.func_177958_n() + 0.5 + offsetX;
                double y = (double)pos.func_177956_o() + 0.5 + (double)(rand.nextFloat() * 0.05f);
                double z = (double)pos.func_177952_p() + 0.65 + offsetZ;
                if (state.func_177229_b((IProperty)field_176492_b) != DoubleBlockHalf.UPPER || !worldIn.field_72995_K || worldIn.func_82737_E() % (long)(9 / ((Integer)state.func_177229_b((IProperty)AGE) - 5)) != 0L) continue;
                worldIn.func_195594_a((IParticleData)AtmosphericParticles.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
            }
            if (!worldIn.field_72995_K && (Integer)state.func_177229_b((IProperty)AGE) > 3 && Math.random() <= 0.4 && state.func_177229_b((IProperty)field_176492_b) == DoubleBlockHalf.LOWER && !(entityIn instanceof BeeEntity)) {
                entityIn.func_213295_a(state, new Vec3d((double)0.2f, 0.2, (double)0.2f));
                entityIn.func_70097_a(AtmosphericDamageSources.ALOE_LEAVES, 1.0f);
                if (entityIn instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entityIn;
                    if (!entityIn.func_130014_f_().func_201670_d() && !serverplayerentity.func_184812_l_()) {
                        AtmosphericCriteriaTriggers.ALOE_VERA_PRICK.trigger(serverplayerentity);
                    }
                }
            }
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)AtmosphericItems.ALOE_KERNELS.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        double offsetX = rand.nextFloat() * 0.6f;
        double offsetZ = rand.nextFloat() * 0.45f;
        double x = (double)pos.func_177958_n() + 0.5 + offsetX;
        double y = (double)pos.func_177956_o() + 0.5 + (double)(rand.nextFloat() * 0.05f);
        double z = (double)pos.func_177952_p() + 0.65 + offsetZ;
        if (state.func_177229_b((IProperty)field_176492_b) == DoubleBlockHalf.UPPER && worldIn.field_72995_K && worldIn.func_82737_E() % (long)(6 / ((Integer)state.func_177229_b((IProperty)AGE) - 5)) == 0L) {
            worldIn.func_195594_a((IParticleData)AtmosphericParticles.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        Random rand = new Random();
        if (player.func_184586_b(handIn).func_77973_b() == Items.field_151097_aZ) {
            player.func_184586_b(handIn).func_222118_a(1, (LivingEntity)player, onBroken -> onBroken.func_213334_d(handIn));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187872_fl, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            for (int i = 0; i < 50 + rand.nextInt(50); ++i) {
                double offsetX = rand.nextFloat();
                double offsetZ = rand.nextFloat();
                double x = (double)pos.func_177958_n() + offsetX;
                double y = (double)pos.func_177956_o() + 0.5 + (double)rand.nextFloat();
                double z = (double)pos.func_177952_p() + 0.15 + offsetZ;
                if (!worldIn.field_72995_K) continue;
                worldIn.func_195594_a((IParticleData)AtmosphericParticles.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
            }
            if (state.func_177229_b((IProperty)field_176492_b) == DoubleBlockHalf.LOWER) {
                worldIn.func_180501_a(pos, (BlockState)((Block)AtmosphericBlocks.ALOE_VERA.get()).func_176223_P().func_206870_a((IProperty)AloeVeraBlock.AGE, (Comparable)Integer.valueOf(2)), 32);
                worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 32);
            } else {
                worldIn.func_180501_a(pos, (BlockState)((Block)AtmosphericBlocks.ALOE_VERA.get()).func_176223_P().func_206870_a((IProperty)AloeVeraBlock.AGE, (Comparable)Integer.valueOf(2)), 32);
                worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 32);
            }
            AloeVeraTallBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)AtmosphericItems.ALOE_LEAVES.get(), new Random().nextInt(5) + 3));
            AloeVeraTallBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)AtmosphericItems.ALOE_KERNELS.get(), age - 5));
            AloeVeraTallBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_222081_ls, age - 5));
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.func_200014_a_(state, (IBlockReader)worldIn, pos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 8;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 8;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DAMAGE_CACTUS;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225534_a_(state, worldIn, pos, random);
        if (state.func_177229_b((IProperty)field_176492_b) == DoubleBlockHalf.LOWER) {
            boolean flag;
            boolean bl = flag = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == AtmosphericBlocks.RED_ARID_SAND.get();
            if (!flag && (Integer)state.func_177229_b((IProperty)AGE) < 8 && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 12 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(12) == 0 ? 1 : 0) != 0)) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)));
                worldIn.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a((IProperty)field_176492_b, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)));
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b((IProperty)field_176492_b);
        if (age < 8) {
            if (half == DoubleBlockHalf.LOWER) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
                world.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a((IProperty)field_176492_b, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
            } else if (half == DoubleBlockHalf.UPPER) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
                world.func_175656_a(pos.func_177977_b(), (BlockState)((BlockState)state.func_206870_a((IProperty)field_176492_b, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
            }
        }
    }
}

