/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.world.gen.feature;

import com.bagel.atmospheric.common.block.MonkeyBrushBlock;
import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class RosewoodTreeFeature
extends TreeFeature {
    private final Supplier<BlockState> ROSEWOOD_LOG = () -> ((Block)AtmosphericBlocks.ROSEWOOD_LOG.get()).func_176223_P();
    private final Supplier<BlockState> ROSEWOOD_LEAVES = () -> (BlockState)((Block)AtmosphericBlocks.ROSEWOOD_LEAVES.get()).func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
    private List<Block> brushes = new ArrayList<Block>();

    public RosewoodTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> config) {
        super(config);
    }

    public boolean func_225557_a_(IWorldGenerationReader worldIn, Random rand, BlockPos position, Set<BlockPos> logsPlaced, Set<BlockPos> leavesPlaced, MutableBoundingBox boundsIn, TreeFeatureConfig config) {
        if (rand.nextInt(250) == 0) {
            if (rand.nextInt(2) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get());
            }
            if (rand.nextInt(3) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get());
            }
            if (rand.nextInt(4) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get());
            }
        } else {
            this.brushes.clear();
        }
        int branches = 2 + rand.nextInt(3);
        int height = 4 + rand.nextInt(2) + rand.nextInt(3) + rand.nextInt(3);
        int bonusCanopies = rand.nextInt(3);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (RosewoodTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (RosewoodTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)config.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - branches - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                boolean canopy = false;
                BlockPos sapling = position;
                for (int k1 = 0; k1 < height; ++k1) {
                    int logY = position.func_177956_o() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (RosewoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) {
                        this.placeLogAt(logsPlaced, worldIn, blockpos, boundsIn, Direction.UP);
                    }
                    if (rand.nextInt(6) != 0 || k1 <= 3 || k1 >= height || canopy) continue;
                    int leafSize = 1 + rand.nextInt(2);
                    for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
                        for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                            if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                            this.placeLeafAt(leavesPlaced, worldIn, blockpos.func_177982_a(k3, 0, j4), boundsIn);
                        }
                    }
                    canopy = true;
                }
                ArrayList<String> directions = new ArrayList<String>();
                for (int k2 = 0; k2 < branches; ++k2) {
                    int j4;
                    int k3;
                    Direction offset = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                    while (directions.contains(offset.toString())) {
                        offset = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                    }
                    directions.add(offset.toString());
                    int turns = 1 + rand.nextInt(3);
                    BlockPos currentPos = position.func_177967_a(Direction.UP, height - 1);
                    int branchLength = 0;
                    int branchHeight = 0;
                    for (int k4 = 0; k4 < turns; ++k4) {
                        branchLength = 1 + rand.nextInt(2) + rand.nextInt(2);
                        branchHeight = 1 + rand.nextInt(3) + rand.nextInt(2);
                        this.createHorizontalLog(branchLength, logsPlaced, leavesPlaced, worldIn, currentPos, offset, boundsIn);
                        this.createVerticalLog(branchHeight, logsPlaced, leavesPlaced, worldIn, currentPos.func_177967_a(offset, branchLength), boundsIn, rand);
                        currentPos = currentPos.func_177967_a(offset, branchLength).func_177967_a(Direction.UP, branchHeight);
                    }
                    int leafSize = 2 + rand.nextInt(2);
                    int leafSizeTop = 0;
                    leafSizeTop = leafSize == 2 ? leafSize - 1 : leafSize - 1 - rand.nextInt(2);
                    for (k3 = -leafSize; k3 <= leafSize; ++k3) {
                        for (j4 = -leafSize; j4 <= leafSize; ++j4) {
                            if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                            this.placeLeafAt(leavesPlaced, worldIn, currentPos.func_177982_a(k3, 0, j4), boundsIn);
                        }
                    }
                    currentPos = currentPos.func_177967_a(Direction.UP, 1);
                    for (k3 = -leafSizeTop; k3 <= leafSizeTop; ++k3) {
                        for (j4 = -leafSizeTop; j4 <= leafSizeTop; ++j4) {
                            if (Math.abs(k3) == leafSizeTop && Math.abs(j4) == leafSizeTop) continue;
                            this.placeLeafAt(leavesPlaced, worldIn, currentPos.func_177982_a(k3, 0, j4), boundsIn);
                        }
                    }
                    logX = position.func_177958_n();
                    logZ = position.func_177952_p();
                }
                if (!this.brushes.isEmpty()) {
                    for (BlockPos pos : logsPlaced) {
                        for (Direction direction2 : Direction.values()) {
                            if (!RosewoodTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)pos.func_177972_a(direction2)) || rand.nextInt(3) != 0) continue;
                            worldIn.func_180501_a(pos.func_177972_a(direction2), (BlockState)this.brushes.get(rand.nextInt(this.brushes.size())).func_176223_P().func_206870_a((IProperty)MonkeyBrushBlock.FACING, (Comparable)direction2), 18);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void createHorizontalLog(int branchLength, Set<BlockPos> changedBlocks, Set<BlockPos> changedBlocksLeaves, IWorldGenerationReader worldIn, BlockPos pos, Direction direction, MutableBoundingBox boundsIn) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        for (int k3 = 0; k3 < branchLength; ++k3) {
            BlockPos blockpos1 = new BlockPos(logX += direction.func_82601_c(), logY, logZ += direction.func_82599_e());
            if (!RosewoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) continue;
            this.placeLogAt(changedBlocks, worldIn, blockpos1, boundsIn, direction);
        }
    }

    private void createVerticalLog(int branchHeight, Set<BlockPos> changedBlocks, Set<BlockPos> changedBlocksLeaves, IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox boundsIn, Random rand) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        boolean canopy = false;
        for (int k1 = 0; k1 < branchHeight; ++k1) {
            BlockPos blockpos;
            if (RosewoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(logX, ++logY, logZ)))) {
                this.placeLogAt(changedBlocks, worldIn, blockpos, boundsIn, Direction.UP);
            }
            if (rand.nextInt(6) != 0 || canopy) continue;
            int leafSize = 1 + rand.nextInt(2);
            for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
                for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                    if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                    this.placeLeafAt(changedBlocksLeaves, worldIn, blockpos.func_177982_a(k3, 0, j4), boundsIn);
                }
            }
            canopy = true;
        }
    }

    private void placeLogAt(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox boundsIn, Direction direction) {
        this.setLogState(changedBlocks, (IWorldWriter)worldIn, pos, (BlockState)this.ROSEWOOD_LOG.get().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k()), boundsIn);
    }

    private void placeLeafAt(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos pos, MutableBoundingBox boundsIn) {
        if (RosewoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            this.setLogState(changedBlocks, (IWorldWriter)world, pos, this.ROSEWOOD_LEAVES.get(), boundsIn);
        }
    }

    private void placeBrushAt(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos pos, MutableBoundingBox boundsIn, Direction direction2) {
        Random rand = new Random();
        boundsIn.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        if (RosewoodTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177972_a(direction2))) {
            world.func_180501_a(pos.func_177972_a(direction2), (BlockState)this.brushes.get(rand.nextInt(this.brushes.size())).func_176223_P().func_206870_a((IProperty)MonkeyBrushBlock.FACING, (Comparable)direction2), 18);
        }
    }

    protected final void setLogState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState state, MutableBoundingBox boundsIn) {
        worldIn.func_180501_a(pos, state, 18);
        boundsIn.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        if (BlockTags.field_200031_h.func_199685_a_((Object)state.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    private void func_208521_b(IWorldWriter p_208521_1_, BlockPos p_208521_2_, BlockState p_208521_3_) {
        p_208521_1_.func_180501_a(p_208521_2_, p_208521_3_, 18);
    }
}

