/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.world.gen.feature;

import com.bagel.atmospheric.common.block.YuccaFlowerDoubleBlock;
import com.bagel.atmospheric.core.other.AtmosphericTags;
import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class YuccaTreeFeature
extends TreeFeature {
    private boolean patch;
    private boolean petrified;
    private Supplier<BlockState> YUCCA_LOG = () -> ((Block)AtmosphericBlocks.YUCCA_LOG.get()).func_176223_P();
    private Supplier<BlockState> YUCCA_LEAVES = () -> (BlockState)((Block)AtmosphericBlocks.YUCCA_LEAVES.get()).func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
    private Supplier<BlockState> YUCCA_FLOWER = () -> ((Block)AtmosphericBlocks.YUCCA_FLOWER.get()).func_176223_P();
    private Supplier<BlockState> YUCCA_BRANCH = () -> ((Block)AtmosphericBlocks.YUCCA_BRANCH.get()).func_176223_P();
    private Supplier<BlockState> TALL_YUCCA_FLOWER_TOP = () -> (BlockState)((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()).func_176223_P().func_206870_a((IProperty)YuccaFlowerDoubleBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER);
    private Supplier<BlockState> TALL_YUCCA_FLOWER_BOTTOM = () -> (BlockState)((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()).func_176223_P().func_206870_a((IProperty)YuccaFlowerDoubleBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER);

    public YuccaTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> config, boolean patch, boolean petrified) {
        super(config);
        this.patch = patch;
        this.petrified = petrified;
    }

    public boolean func_225557_a_(IWorldGenerationReader worldIn, Random rand, BlockPos position, Set<BlockPos> logsPlaced, Set<BlockPos> leavesPlaced, MutableBoundingBox boundsIn, TreeFeatureConfig config) {
        if (this.petrified) {
            Supplier<BlockState> newBlock = () -> ((Block)AtmosphericBlocks.ARID_SANDSTONE.get()).func_176223_P();
            Supplier<BlockState> newBlockWall = () -> ((Block)AtmosphericBlocks.ARID_SANDSTONE_WALL.get()).func_176223_P();
            if (rand.nextInt(4) == 0) {
                newBlock = () -> ((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get()).func_176223_P();
                newBlockWall = () -> ((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_WALL.get()).func_176223_P();
            }
            this.YUCCA_LOG = newBlock;
            this.YUCCA_LEAVES = newBlock;
            this.YUCCA_FLOWER = newBlockWall;
            this.YUCCA_BRANCH = newBlockWall;
        }
        int height = 4 + rand.nextInt(2) + rand.nextInt(2);
        int reduction = 2 + rand.nextInt(3);
        if (this.petrified) {
            height -= reduction;
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (YuccaTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (YuccaTreeFeature.isYucca((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), config.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight()) {
                BlockPos blockpos;
                if (!YuccaTreeFeature.isSand((IWorldGenerationBaseReader)worldIn, position.func_177977_b())) {
                    this.setDirtAt(worldIn, position.func_177977_b(), position);
                }
                for (int ja = 0; ja < reduction; ++ja) {
                    if (!this.petrified) continue;
                    this.placeLogAt(logsPlaced, (IWorldWriter)worldIn, position.func_177979_c(ja), boundsIn, Direction.UP, false);
                }
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                int logY = position.func_177956_o();
                for (int k1 = 0; k1 < height; ++k1) {
                    logY = position.func_177956_o() + k1;
                    BlockPos blockpos2 = new BlockPos(logX, logY, logZ);
                    if (!YuccaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos2)) continue;
                    this.placeLogAt(logsPlaced, (IWorldWriter)worldIn, blockpos2, boundsIn, Direction.UP, false);
                }
                logY = position.func_177956_o() + height - 1;
                BlockPos newPos = this.createYuccaBranch(height, logsPlaced, worldIn, position, Direction.NORTH, boundsIn, rand);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos.func_177984_a(), boundsIn, rand, false);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos, boundsIn, rand, true);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos.func_177977_b(), boundsIn, rand, false);
                newPos = this.createYuccaBranch(height, logsPlaced, worldIn, position, Direction.EAST, boundsIn, rand);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos.func_177984_a(), boundsIn, rand, false);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos, boundsIn, rand, true);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos.func_177977_b(), boundsIn, rand, false);
                newPos = this.createYuccaBranch(height, logsPlaced, worldIn, position, Direction.SOUTH, boundsIn, rand);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos.func_177984_a(), boundsIn, rand, false);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos, boundsIn, rand, true);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos.func_177977_b(), boundsIn, rand, false);
                newPos = this.createYuccaBranch(height, logsPlaced, worldIn, position, Direction.WEST, boundsIn, rand);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos.func_177984_a(), boundsIn, rand, false);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos, boundsIn, rand, true);
                this.createYuccaLeaves(leavesPlaced, worldIn, newPos.func_177977_b(), boundsIn, rand, false);
                if (this.patch) {
                    for (int j = 0; j < 64; ++j) {
                        blockpos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
                        if (!YuccaTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos) || blockpos.func_177956_o() >= 255 || !this.YUCCA_FLOWER.get().func_196955_c((IWorldReader)worldIn, blockpos)) continue;
                        this.placeFlowerAt(leavesPlaced, worldIn, blockpos, boundsIn, rand);
                    }
                }
                if (this.petrified && rand.nextInt(12) == 0) {
                    for (int j = 0; j < 12; ++j) {
                        blockpos = position.func_177982_a(rand.nextInt(6) - rand.nextInt(6), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(6) - rand.nextInt(6));
                        if (!YuccaTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos) || blockpos.func_177956_o() >= 255 || !YuccaTreeFeature.isSand((IWorldGenerationBaseReader)worldIn, blockpos.func_177977_b())) continue;
                        this.setLogState(leavesPlaced, (IWorldWriter)worldIn, blockpos, ((Block)AtmosphericBlocks.ROASTED_YUCCA_BUNDLE.get()).func_176223_P(), boundsIn);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void createYuccaLeaves(Set<BlockPos> leavesPlaced, IWorldGenerationReader worldIn, BlockPos newPos, MutableBoundingBox boundsIn, Random rand, boolean square) {
        int leafSize = 1;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (square) {
                    this.placeLeafAt(leavesPlaced, worldIn, newPos.func_177982_a(k3, 0, j4), boundsIn, rand);
                    continue;
                }
                if (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize) {
                    this.placeLeafAt(leavesPlaced, worldIn, newPos.func_177982_a(k3, 0, j4), boundsIn, rand);
                    continue;
                }
                if (rand.nextInt(4) != 0) continue;
                this.placeLeafAt(leavesPlaced, worldIn, newPos.func_177982_a(k3, 0, j4), boundsIn, rand);
            }
        }
    }

    private BlockPos createYuccaBranch(int height, Set<BlockPos> logsPlaced, IWorldGenerationReader worldIn, BlockPos pos, Direction direction, MutableBoundingBox boundsIn, Random rand) {
        int logX = pos.func_177958_n();
        int logZ = pos.func_177952_p();
        int logY = pos.func_177956_o() + height - 1;
        int length = 4 + rand.nextInt(2);
        BlockPos blockpos = new BlockPos(logX, logY, logZ);
        boolean bundle = false;
        boolean anyBundle = false;
        for (int i = 0; i < length; ++i) {
            blockpos = new BlockPos(logX, logY, logZ);
            if (!anyBundle && rand.nextInt(16) == 0) {
                bundle = true;
                anyBundle = true;
            } else {
                bundle = false;
            }
            this.createHorizontalLog(1, logsPlaced, worldIn, blockpos, direction, boundsIn, bundle);
            if (i == length) continue;
            if (direction == Direction.EAST || direction == Direction.WEST) {
                logX = direction == Direction.EAST ? (logX += rand.nextInt(2)) : (logX -= rand.nextInt(2));
            } else {
                logZ = direction == Direction.SOUTH ? (logZ += rand.nextInt(2)) : (logZ -= rand.nextInt(2));
            }
            ++logY;
        }
        return blockpos.func_177972_a(direction);
    }

    private void createHorizontalLog(int branchLength, Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, Direction direction, MutableBoundingBox boundsIn, boolean bundle) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        for (int k3 = 0; k3 < branchLength; ++k3) {
            BlockPos blockpos1 = new BlockPos(logX += direction.func_82601_c(), logY, logZ += direction.func_82599_e());
            if (!YuccaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) continue;
            if (!YuccaTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1.func_177977_b())) {
                bundle = false;
            }
            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos1, boundsIn, Direction.UP, bundle);
        }
    }

    private void placeLogAt(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, MutableBoundingBox boundsIn, Direction direction, boolean bundle) {
        BlockState logState = this.petrified ? this.YUCCA_LOG.get() : (BlockState)this.YUCCA_LOG.get().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k());
        this.setLogState(changedBlocks, worldIn, pos, logState, boundsIn);
        if (bundle && !this.petrified) {
            this.setLogState(changedBlocks, worldIn, pos.func_177977_b(), this.YUCCA_BRANCH.get(), boundsIn);
        }
    }

    private void placeLeafAt(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos pos, MutableBoundingBox boundsIn, Random rand) {
        if (YuccaTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos) && !this.petrified) {
            this.setLogState(changedBlocks, (IWorldWriter)world, pos, this.YUCCA_LEAVES.get(), boundsIn);
        }
        if (rand.nextInt(8) == 0 && !this.petrified) {
            this.placeFlowerAt(changedBlocks, world, pos.func_177984_a(), boundsIn, rand);
        }
    }

    private void placeFlowerAt(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos pos, MutableBoundingBox boundsIn, Random rand) {
        if (YuccaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            if (!YuccaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177984_a())) {
                this.setLogState(changedBlocks, (IWorldWriter)world, pos, this.YUCCA_FLOWER.get(), boundsIn);
            } else if (rand.nextInt(4) == 0) {
                this.setLogState(changedBlocks, (IWorldWriter)world, pos, this.TALL_YUCCA_FLOWER_BOTTOM.get(), boundsIn);
                this.setLogState(changedBlocks, (IWorldWriter)world, pos.func_177984_a(), this.TALL_YUCCA_FLOWER_TOP.get(), boundsIn);
            } else {
                this.setLogState(changedBlocks, (IWorldWriter)world, pos, this.YUCCA_FLOWER.get(), boundsIn);
            }
        }
    }

    protected final void setLogState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState state, MutableBoundingBox boundsIn) {
        worldIn.func_180501_a(pos, state, 18);
        boundsIn.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        if (!this.petrified && BlockTags.field_200031_h.func_199685_a_((Object)state.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    protected static boolean isYucca(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        return reader.func_217375_a(pos, state -> state.func_177230_c().func_203417_a(AtmosphericTags.YUCCA_PLANTABLE_ON));
    }

    public static boolean isSand(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, block -> block.func_203425_a(BlockTags.field_203436_u));
    }
}

