/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.core.other;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class AtmosphericConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class ValuesHolder {
        private static int rosewoodForestWeight;
        private static int dunesWeight;
        private static int rockyDunesWeight;

        public static void updateCommonValuesFromConfig(ModConfig config) {
            rosewoodForestWeight = (Integer)AtmosphericConfig.COMMON.rosewoodForestWeight.get();
            dunesWeight = (Integer)AtmosphericConfig.COMMON.dunesWeight.get();
            rockyDunesWeight = (Integer)AtmosphericConfig.COMMON.rockyDunesWeight.get();
        }

        public static int getRosewoodForestWeight() {
            return rosewoodForestWeight;
        }

        public static int getRockyDunesWeight() {
            return dunesWeight;
        }

        public static int getDunesWeight() {
            return rockyDunesWeight;
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> rosewoodForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rockyDunesWeight;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configurations for Atmospheric").push("common");
            builder.comment("Values for biome frequencies; lower = more rare. (Requires restart)").push("biomeWeights");
            this.rosewoodForestWeight = builder.comment("The frequency of Rosewood Forests; Default: 2").define("rosewoodForestWeight", (Object)2);
            this.dunesWeight = builder.comment("The frequency of Dunes; Default: 5").define("dunesWeight", (Object)5);
            this.rockyDunesWeight = builder.comment("The frequency of Rocky Dunes; Default: 4").define("rockyDunesWeight", (Object)4);
            builder.pop();
            builder.pop();
        }
    }
}

