/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.core.registry;

import com.bagel.atmospheric.common.client.particle.AloeBlossomParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class AtmosphericParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = new DeferredRegister(ForgeRegistries.PARTICLE_TYPES, "atmospheric");
    public static final RegistryObject<BasicParticleType> ALOE_BLOSSOM = AtmosphericParticles.createBasicParticleType(true, "aloe_blossom");

    private static RegistryObject<BasicParticleType> createBasicParticleType(boolean alwaysShow, String name) {
        RegistryObject particleType = PARTICLES.register(name, () -> new BasicParticleType(alwaysShow));
        return particleType;
    }

    private static boolean checkForNonNullWithReflectionCauseForgeIsBaby(RegistryObject<BasicParticleType> registryObject) {
        return ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, registryObject, (String)"value") != null;
    }

    @Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegisterParticleFactories {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerParticleTypes(ParticleFactoryRegisterEvent event) {
            if (AtmosphericParticles.checkForNonNullWithReflectionCauseForgeIsBaby((RegistryObject<BasicParticleType>)ALOE_BLOSSOM)) {
                Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ALOE_BLOSSOM.get(), AloeBlossomParticle.Factory::new);
            }
        }
    }
}

