/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items;

import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.MiningGadgets;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeBatteryLevels;
import com.direwolf20.mininggadgets.common.util.MagicHelpers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class UpgradeCard
extends Item {
    private Upgrade upgrade;

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack.func_77973_b() instanceof UpgradeCard) {
            Upgrade upgrade = ((UpgradeCard)stack.func_77973_b()).upgrade;
            int cost = upgrade.getCostPerBlock();
            if (cost > 0) {
                tooltip.add(new TranslationTextComponent("mininggadgets.tooltip.item.upgrade_cost", new Object[]{cost}).func_211708_a(TextFormatting.AQUA));
            }
            cost = 0;
            if (upgrade == Upgrade.LIGHT_PLACER) {
                cost = (Integer)Config.UPGRADECOST_LIGHT.get();
            }
            if (upgrade == Upgrade.FREEZING) {
                cost = (Integer)Config.UPGRADECOST_FREEZE.get();
            }
            if (cost > 0) {
                tooltip.add(new TranslationTextComponent("mininggadgets.tooltip.item.use_cost", new Object[]{cost}).func_211708_a(TextFormatting.AQUA));
            }
            if (upgrade.getBaseName().equals(Upgrade.BATTERY_1.getBaseName())) {
                UpgradeBatteryLevels.getBatteryByLevel(upgrade.getTier()).ifPresent(e -> tooltip.add(new TranslationTextComponent("mininggadgets.tooltip.item.battery_boost", new Object[]{MagicHelpers.tidyValue(e.getPower())}).func_211708_a(TextFormatting.AQUA)));
            }
            tooltip.add(new TranslationTextComponent(this.upgrade.getTooltop(), new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public UpgradeCard(Upgrade upgrade, int maxStack) {
        super(new Item.Properties().func_200916_a(MiningGadgets.itemGroup).func_200917_a(maxStack));
        this.upgrade = upgrade;
    }

    public Upgrade getUpgrade() {
        return this.upgrade;
    }
}

