/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDurabilitySync {
    private final List<Tuple<BlockPos, Integer>> updateList;

    public PacketDurabilitySync(List<Tuple<BlockPos, Integer>> updateList) {
        this.updateList = updateList;
    }

    public static void encode(PacketDurabilitySync msg, PacketBuffer buffer) {
        List<Tuple<BlockPos, Integer>> thisList = msg.updateList;
        CompoundNBT tag = new CompoundNBT();
        ListNBT nbtList = new ListNBT();
        for (int i = 0; i < thisList.size(); ++i) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)thisList.get(i).func_76341_a())));
            nbt.func_74768_a("dur", ((Integer)thisList.get(i).func_76340_b()).intValue());
            nbtList.add(i, (INBT)nbt);
        }
        tag.func_218657_a("list", (INBT)nbtList);
        buffer.func_150786_a(tag);
    }

    public static PacketDurabilitySync decode(PacketBuffer buffer) {
        CompoundNBT tag = buffer.func_150793_b();
        ListNBT nbtList = tag.func_150295_c("list", 10);
        ArrayList<Tuple<BlockPos, Integer>> thisList = new ArrayList<Tuple<BlockPos, Integer>>();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundNBT nbt = nbtList.func_150305_b(i);
            thisList.add((Tuple<BlockPos, Integer>)new Tuple((Object)NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos")), (Object)nbt.func_74762_e("dur")));
        }
        return new PacketDurabilitySync(thisList);
    }

    public static void clientPacketHandler(PacketDurabilitySync msg) {
        List<Tuple<BlockPos, Integer>> thisList = msg.updateList;
        for (int i = 0; i < thisList.size(); ++i) {
            BlockPos pos = (BlockPos)thisList.get(i).func_76341_a();
            int durability = (Integer)thisList.get(i).func_76340_b();
            TileEntity clientTE = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
            if (!(clientTE instanceof RenderBlockTileEntity)) {
                return;
            }
            ((RenderBlockTileEntity)clientTE).setClientDurability(durability);
        }
    }

    public static class Handler {
        public static void handle(PacketDurabilitySync msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketDurabilitySync.clientPacketHandler(msg)));
            ctx.get().setPacketHandled(true);
        }
    }
}

