/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.crafting.client;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.modules.crafting.CraftingModule;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardContainer;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsbase.modules.crafting.network.PacketItemNBTToServer;
import mcjty.rftoolsbase.setup.RFToolsBaseMessages;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiCraftingCard
extends GenericGuiContainer<GenericTileEntity, CraftingCardContainer> {
    public static final int WIDTH = 180;
    public static final int HEIGHT = 198;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsbase", "textures/gui/craftingcard.png");
    private BlockRender[] slots = new BlockRender[21];

    public GuiCraftingCard(CraftingCardContainer container, PlayerInventory inventory) {
        super(null, (Container)container, inventory, CraftingCardItem.MANUAL);
        this.field_146999_f = 180;
        this.field_147000_g = 198;
    }

    public static void register() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)CraftingModule.CONTAINER_CRAFTING_CARD.get()), GuiCraftingCard::createCraftingCardGui);
    }

    private static GuiCraftingCard createCraftingCardGui(CraftingCardContainer container, PlayerInventory inventory, ITextComponent textComponent) {
        return new GuiCraftingCard(container, inventory);
    }

    public void init() {
        super.init();
        Panel toplevel = (Panel)Widgets.positional().background(iconLocation);
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        toplevel.children(new Widget[]{((Label)Widgets.label((String)"Regular 3x3 crafting recipe").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint(10, 4, 160, 14)});
        toplevel.children(new Widget[]{((Label)Widgets.label((String)"or more complicated recipes").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint(10, 17, 160, 14)});
        toplevel.children(new Widget[]{((Button)Widgets.button((int)110, (int)57, (int)60, (int)14, (String)"Update").tooltips(new String[]{"Update the item in the output", "slot to the recipe in the", "3x3 grid"})).event(() -> RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketSendServerCommand("rftoolsbase", "testRecipe", TypedMap.EMPTY)))});
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 5; ++x) {
                int idx = y * 5 + x;
                this.createDummySlot(toplevel, idx, new PositionalLayout.PositionalHint(x * 18 + 10, y * 18 + 37, 18, 18), this.createSelectionEvent(idx));
            }
        }
        this.createDummySlot(toplevel, 20, new PositionalLayout.PositionalHint(154, 37, 18, 18), this.createSelectionEvent(20));
        this.updateSlots();
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void createDummySlot(Panel toplevel, final int idx, PositionalLayout.PositionalHint hint, BlockRenderEvent selectionEvent) {
        this.slots[idx] = (BlockRender)new BlockRender(){

            public List<String> getTooltips() {
                Object s = GuiCraftingCard.this.slots[idx].getRenderItem();
                if (s instanceof ItemStack) {
                    ItemStack stack = (ItemStack)s;
                    if (!stack.func_190926_b()) {
                        ITooltipFlag.TooltipFlags flag = this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
                        List list = stack.func_82840_a((PlayerEntity)this.mc.field_71439_g, (ITooltipFlag)flag);
                        for (int i = 0; i < list.size(); ++i) {
                        }
                        return list.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
                    }
                    return Collections.emptyList();
                }
                return Collections.emptyList();
            }
        }.hilightOnHover(true).hint((LayoutHint)hint);
        this.slots[idx].event(selectionEvent);
        toplevel.children(new Widget[]{this.slots[idx]});
    }

    private void updateSlots() {
        ItemStackList stacks = this.getStacks();
        if (stacks.isEmpty()) {
            return;
        }
        for (int i = 0; i < stacks.size(); ++i) {
            this.slots[i].renderItem(stacks.get(i));
        }
    }

    @Nonnull
    private ItemStackList getStacks() {
        ItemStack cardItem = this.minecraft.field_71439_g.func_184586_b(Hand.MAIN_HAND);
        ItemStackList stacks = ItemStackList.EMPTY;
        if (!cardItem.func_190926_b() && cardItem.func_77973_b() instanceof CraftingCardItem) {
            stacks = CraftingCardItem.getStacksFromItem(cardItem);
        }
        return stacks;
    }

    private BlockRenderEvent createSelectionEvent(final int idx) {
        return new BlockRenderEvent(){

            public void select() {
                ItemStack itemstack = ((GuiCraftingCard)GuiCraftingCard.this).minecraft.field_71439_g.field_71071_by.func_70445_o();
                GuiCraftingCard.this.slots[idx].renderItem((Object)itemstack);
                ItemStackList stacks = GuiCraftingCard.this.getStacks();
                if (!stacks.isEmpty()) {
                    stacks.set(idx, (Object)itemstack);
                    ItemStack cardItem = ((GuiCraftingCard)GuiCraftingCard.this).minecraft.field_71439_g.func_184586_b(Hand.MAIN_HAND);
                    CraftingCardItem.putStacksInItem(cardItem, stacks);
                    RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketItemNBTToServer(cardItem.func_77978_p()));
                }
            }

            public void doubleClick() {
            }
        };
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.updateSlots();
        this.drawWindow();
    }
}

