/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui.widget.loader;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import xaero.common.gui.widget.ImageWidgetBuilder;
import xaero.common.gui.widget.Widget;
import xaero.common.gui.widget.loader.ScalableWidgetLoader;

public class ImageWidgetLoader
extends ScalableWidgetLoader {
    private static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Widget load(Map<String, String> parsedArgs) throws IOException {
        ImageWidgetBuilder builder = new ImageWidgetBuilder();
        this.commonLoad(builder, parsedArgs);
        String image = parsedArgs.get("image");
        String image_url = parsedArgs.get("image_url");
        int textureId = 0;
        if (image != null) {
            builder.setImageId(image);
            textureId = GL11.glGenTextures();
            if (textureId <= 0) {
                return null;
            }
            builder.setGlTexture(textureId);
            RenderSystem.enableTexture();
            RenderSystem.bindTexture((int)textureId);
            String tex_base_level = parsedArgs.get("tex_base_level");
            String tex_max_level = parsedArgs.get("tex_max_level");
            String tex_min_lod = parsedArgs.get("tex_min_lod");
            String tex_max_lod = parsedArgs.get("tex_max_lod");
            String tex_lod_bias = parsedArgs.get("tex_lod_bias");
            String tex_mag_filter = parsedArgs.get("tex_mag_filter");
            String tex_min_filter = parsedArgs.get("tex_min_filter");
            String tex_wrap_s = parsedArgs.get("tex_wrap_s");
            String tex_wrap_t = parsedArgs.get("tex_wrap_t");
            GL11.glTexParameteri((int)3553, (int)33084, (int)(tex_base_level != null ? Integer.parseInt(tex_base_level) : 0));
            GL11.glTexParameteri((int)3553, (int)33085, (int)(tex_max_level != null ? Integer.parseInt(tex_max_level) : 1));
            GL11.glTexParameterf((int)3553, (int)33082, (float)(tex_min_lod != null ? Float.parseFloat(tex_min_lod) : 0.0f));
            GL11.glTexParameterf((int)3553, (int)33083, (float)(tex_max_lod != null ? Float.parseFloat(tex_max_lod) : 1.0f));
            GL11.glTexParameterf((int)3553, (int)34049, (float)(tex_lod_bias != null ? Float.parseFloat(tex_lod_bias) : 0.0f));
            if (!GL.getCapabilities().OpenGL30) {
                GL11.glTexParameteri((int)3553, (int)33169, (int)1);
            }
            GL11.glTexParameteri((int)3553, (int)10240, (int)(tex_mag_filter != null ? Integer.parseInt(tex_mag_filter) : 9728));
            GL11.glTexParameteri((int)3553, (int)10241, (int)(tex_min_filter != null ? Integer.parseInt(tex_min_filter) : 9729));
            GL11.glTexParameteri((int)3553, (int)10242, (int)(tex_wrap_s != null ? Integer.parseInt(tex_wrap_s) : 33071));
            GL11.glTexParameteri((int)3553, (int)10243, (int)(tex_wrap_t != null ? Integer.parseInt(tex_wrap_t) : 33071));
            File cacheFolder = new File("XaeroCache");
            Files.createDirectories(cacheFolder.toPath(), new FileAttribute[0]);
            ResourceLocation resourceLocation = new ResourceLocation("xaerobetterpvp", "gui/" + image + ".png");
            BufferedImage bufferedImage = null;
            try (InputStream inputStream = null;){
                IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation);
                inputStream = resource.func_199027_b();
                bufferedImage = ImageIO.read(inputStream);
                inputStream.close();
            }
            if (bufferedImage == null) {
                RenderSystem.bindTexture((int)0);
                GL11.glDeleteTextures((int)textureId);
                return null;
            }
            int imageW = bufferedImage.getWidth();
            int imageH = bufferedImage.getHeight();
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(imageW * imageH * 4));
            for (int y = 0; y < imageH; ++y) {
                for (int x = 0; x < imageW; ++x) {
                    int color = bufferedImage.getRGB(x, y);
                    buffer.putInt(color);
                }
            }
            buffer.flip();
            bufferedImage.flush();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)imageW, (int)imageH, (int)0, (int)32993, (int)33639, (ByteBuffer)buffer);
            if (GL.getCapabilities().OpenGL30) {
                GL30.glGenerateMipmap((int)3553);
            }
            RenderSystem.bindTexture((int)0);
            builder.setImageW(imageW);
            builder.setImageH(imageH);
        }
        if (builder.validate()) {
            return builder.build();
        }
        if (textureId > 0) {
            GL11.glDeleteTextures((int)textureId);
        }
        return null;
    }
}

