/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Difficulty;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private ArrayList<Entity> players;
    private ArrayList<Entity> living;
    private ArrayList<Entity> hostile;
    private ArrayList<Entity> items;
    private ArrayList<Entity> entities;

    public MinimapRadar(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.players = new ArrayList();
        this.living = new ArrayList();
        this.hostile = new ArrayList();
        this.items = new ArrayList();
        this.entities = new ArrayList();
    }

    private int getType(Entity e) {
        if (e instanceof PlayerEntity) {
            return 1;
        }
        if (e.getPersistentData().func_74764_b("hostileMinimap") ? e.getPersistentData().func_74767_n("hostileMinimap") : Minecraft.func_71410_x().field_71441_e.func_175659_aa() != Difficulty.PEACEFUL && !this.hostileException(e) && (e instanceof MonsterEntity || e instanceof IMob || e.func_184176_by() == SoundCategory.HOSTILE)) {
            return 2;
        }
        if (e instanceof LivingEntity) {
            return 3;
        }
        if (e instanceof ItemEntity) {
            return 4;
        }
        return 0;
    }

    public void updateRadar(ClientWorld world, PlayerEntity p, Entity renderEntity) {
        this.players.clear();
        this.hostile.clear();
        this.living.clear();
        this.items.clear();
        this.entities.clear();
        Iterable worldEntities = world.func_217416_b();
        for (Entity e : worldEntities) {
            try {
                int type = this.getType(e);
                if (type == 1 ? e != p && (!this.modMain.getSettings().getShowPlayers() || !this.modMain.getSettings().getShowOtherTeam() && p.func_96124_cp() != ((PlayerEntity)e).func_96124_cp()) : (type == 2 ? !this.modMain.getSettings().getShowHostile() : (type == 3 ? !this.modMain.getSettings().getShowMobs() : (type == 4 ? !this.modMain.getSettings().getShowItems() : !this.modMain.getSettings().getShowOther())))) continue;
                double offx = e.func_226277_ct_() - renderEntity.func_226277_ct_();
                double offy = e.func_226281_cx_() - renderEntity.func_226281_cx_();
                double offh = renderEntity.func_226278_cu_() - e.func_226278_cu_();
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                double maxDistance = 50625.0 / (this.minimapSession.getMinimapProcessor().getMinimapZoom() * this.minimapSession.getMinimapProcessor().getMinimapZoom());
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(this.modMain.getSettings().heightLimit * this.modMain.getSettings().heightLimit)) continue;
                ArrayList<Entity> typeList = this.entities;
                switch (type) {
                    case 1: {
                        typeList = this.players;
                        break;
                    }
                    case 2: {
                        typeList = this.hostile;
                        break;
                    }
                    case 3: {
                        typeList = this.living;
                        break;
                    }
                    case 4: {
                        typeList = this.items;
                    }
                }
                typeList.add(e);
                if (this.modMain.getSettings().entityAmount == 0 || typeList.size() < 100 * this.modMain.getSettings().entityAmount) continue;
                break;
            }
            catch (Exception ex) {
            }
        }
    }

    private boolean hostileException(Entity e) {
        return false;
    }

    public double getEntityX(Entity e, float partial) {
        return e.field_70142_S + (e.func_226277_ct_() - e.field_70142_S) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        return e.field_70136_U + (e.func_226281_cx_() - e.field_70136_U) * (double)partial;
    }

    public boolean shouldRenderEntity(Entity e) {
        return !e.func_225608_bj_() && !e.func_82150_aj();
    }

    public int getPlayerTeamColour(PlayerEntity p) {
        Integer teamColour = null;
        Team team = p.func_96124_cp();
        if (team != null) {
            teamColour = team.func_178775_l().func_211163_e();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(PlayerEntity p, Entity e, double offh) {
        int color;
        int type = this.getType(e);
        if (type == 1) {
            int teamColour = this.getPlayerTeamColour(p);
            int entityTeamColour = this.getPlayerTeamColour((PlayerEntity)e);
            color = this.modMain.getSettings().otherTeamColor != -1 && entityTeamColour != teamColour ? ModSettings.COLORS[this.modMain.getSettings().otherTeamColor] : (this.modMain.getSettings().playersColor != -1 ? ModSettings.COLORS[this.modMain.getSettings().playersColor] : (entityTeamColour != -1 ? entityTeamColour : -1));
        } else {
            color = type == 2 ? ModSettings.COLORS[this.modMain.getSettings().hostileColor] : (type == 3 ? ModSettings.COLORS[this.modMain.getSettings().mobsColor] : (type == 4 ? ModSettings.COLORS[this.modMain.getSettings().itemsColor] : ModSettings.COLORS[this.modMain.getSettings().otherColor]));
        }
        double brightness = this.getEntityBrightness(offh);
        if (brightness < 1.0) {
            int l = color >> 16 & 0xFF;
            int i1 = color >> 8 & 0xFF;
            int j1 = color & 0xFF;
            if ((l = (int)((double)l * brightness)) > 255) {
                l = 255;
            }
            if ((i1 = (int)((double)i1 * brightness)) > 255) {
                i1 = 255;
            }
            if ((j1 = (int)((double)j1 * brightness)) > 255) {
                j1 = 255;
            }
            color = 0xFF000000 | l << 16 | i1 << 8 | j1;
        }
        return color;
    }

    public double getEntityBrightness(double offh) {
        double level = (double)this.modMain.getSettings().heightLimit - offh;
        if (level < 0.0) {
            level = 0.0;
        }
        double brightness = 1.0;
        if (level <= (double)(this.modMain.getSettings().heightLimit / 2) && this.modMain.getSettings().showEntityHeight) {
            brightness = level / (double)this.modMain.getSettings().heightLimit;
        }
        return brightness;
    }

    public Iterator<Entity> getEntitiesIterator() {
        return this.entities.iterator();
    }

    public Iterator<Entity> getItemsIterator() {
        return this.items.iterator();
    }

    public Iterator<Entity> getLivingIterator() {
        return this.living.iterator();
    }

    public Iterator<Entity> getHostileIterator() {
        return this.hostile.iterator();
    }

    public Iterator<Entity> getPlayersIterator() {
        return this.players.iterator();
    }
}

