/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsGuiRenderer {
    private IXaeroMinimap modMain;
    private Minecraft mc;

    public WaypointsGuiRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
    }

    public void render(XaeroMinimapSession minimapSession, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double zoom) {
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        RenderSystem.disableDepthTest();
        if (this.modMain.getSettings().compassOverWaypoints) {
            this.drawWaypoints(waypointsManager, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom);
            this.drawCompass(specW, specH, ps, pc, zoom);
        } else {
            this.drawCompass(specW, specH, ps, pc, zoom);
            this.drawWaypoints(waypointsManager, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom);
        }
    }

    private void drawWaypoints(WaypointsManager waypointsManager, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double dimDiv, double zoom) {
        if (this.modMain.getSettings().getShowWaypoints() && waypointsManager.getWaypoints() != null) {
            if (this.modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    this.renderWaypointsList(setEntry.getValue().getList(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom);
                }
            } else {
                this.renderWaypointsList(waypointsManager.getWaypoints().getList(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom);
            }
        }
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = WaypointsManager.customWaypoints;
        if (this.modMain.getSettings().getShowWaypoints() && !customWaypoints.isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                this.renderWaypointsList(modCustomWaypoints.values(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom);
            }
        }
    }

    private void renderWaypointsList(Collection<Waypoint> list, double playerX, double playerZ, int specW, int specH, double ps, double pc, double dimDiv, double zoom) {
        for (Waypoint w : list) {
            if (w == null || w.isDisabled() || w.getType() == 1 && !this.modMain.getSettings().getDeathpoints()) continue;
            double offx = (double)w.getX(dimDiv) + 0.5 - playerX;
            double offz = (double)w.getZ(dimDiv) + 0.5 - playerZ;
            double distance = Math.sqrt(offx * offx + offz * offz);
            if (w.getType() == 0 && !w.isGlobal() && this.modMain.getSettings().waypointsDistance != 0.0 && distance > this.modMain.getSettings().waypointsDistance) continue;
            this.translatePosition(specW, specH, ps, pc, offx, offz, zoom);
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            this.drawIconOnGUI(w, this.modMain.getSettings(), 0, 0);
            GL11.glPopMatrix();
        }
    }

    private void drawCompass(int specW, int specH, double ps, double pc, double zoom) {
        if (!this.modMain.getSettings().compass) {
            return;
        }
        String[] nesw = new String[]{"N", "E", "S", "W"};
        for (int i = 0; i < 4; ++i) {
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            this.translatePosition(specW, specH, ps, pc, offx, offy, zoom);
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            Misc.drawPiercingText(nesw[i], 1 - this.mc.field_71466_p.func_78256_a(nesw[i]) / 2, -3.0f, -1, true);
            GL11.glPopMatrix();
        }
    }

    public void translatePosition(int specW, int specH, double ps, double pc, double offx, double offy, double zoom) {
        double X;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (borderedX > (double)(specW - 2)) {
            borderedX = specW - 2;
            borderedY = Y * (double)(specW - 2) / X;
        } else if (borderedX < (double)(-specW)) {
            borderedX = -specW;
            borderedY = -Y * (double)specW / X;
        }
        if (borderedY > (double)(specH - 2)) {
            borderedY = specH - 2;
            borderedX = X * (double)(specH - 2) / Y;
        } else if (borderedY < (double)(-specH)) {
            borderedY = -specH;
            borderedX = -X * (double)specH / Y;
        }
        GL11.glPushMatrix();
        RenderSystem.translated((double)borderedX, (double)borderedY, (double)0.0);
    }

    public void drawIconOnGUI(Waypoint w, ModSettings settings, int drawX, int drawY) {
        if (w.getType() == 0) {
            int j = Minecraft.func_71410_x().field_71466_p.func_78256_a(w.getSymbol()) / 2;
            int addedFrame = j > 4 ? j - 4 : 0;
            int rectX1 = drawX - 4 - addedFrame;
            int rectY1 = drawY - 4 - addedFrame;
            int rectX2 = drawX + 5 + addedFrame;
            int rectY2 = drawY + 5 + addedFrame;
            int c = ModSettings.COLORS[w.getColor()];
            int r = c >> 16 & 0xFF;
            int g = c >> 8 & 0xFF;
            int b = c & 0xFF;
            int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
            c = a << 24 | r << 16 | g << 8 | b;
            AbstractGui.fill((int)rectX1, (int)rectY1, (int)rectX2, (int)rectY2, (int)c);
            Misc.drawPiercingText(w.getSymbol(), drawX + 1 - j, drawY - 3, -1, true);
        } else if (w.getType() == 1) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            Minecraft.func_71410_x().field_71456_v.blit(drawX - 4, drawY - 4, 0, 78, 9, 9);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, MainWindow res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                Misc.drawCenteredPiercingText(I18n.func_135052_a((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), res.func_198107_o() / 2, res.func_198087_p() / 2 + 50, c, true);
                GL11.glEnable((int)3008);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }
}

