/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.block;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.fruits.FruitType;
import snownee.fruits.FruitsConfig;
import snownee.fruits.cherry.block.CherryLeavesBlock;
import snownee.fruits.tile.FruitTreeTile;
import snownee.fruits.world.gen.treedecorator.CarpetTreeDecorator;

public class FruitLeavesBlock
extends LeavesBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    public final Supplier<FruitType> type;

    public FruitLeavesBlock(Supplier<FruitType> type, Block.Properties properties) {
        super(properties);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_208494_a, (Comparable)Integer.valueOf(7))).func_206870_a((IProperty)field_208495_b, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_208494_a, field_208495_b, AGE});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrow(state) || (Integer)state.func_177229_b((IProperty)AGE) == 1;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) != 3;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        block8: {
            block7: {
                if ((Integer)state.func_177229_b((IProperty)AGE) != 3) break block7;
                if (!world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
                    return;
                }
                switch (FruitsConfig.getDropMode((World)world)) {
                    case INDEPENDENT: {
                        world.func_175656_a(pos, this.onPassiveGathered(world, pos, state));
                        FruitLeavesBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this.type.get().fruit));
                        break;
                    }
                    case ONE_BY_ONE: {
                        ItemStack stack;
                        FruitTreeTile tile = this.findTile(world, pos, state);
                        if (tile != null && tile.canDrop() && !(stack = new ItemStack((IItemProvider)this.type.get().fruit)).func_190926_b() && !world.restoringBlockSnapshots) {
                            double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                            double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                            double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                            ItemEntity itementity = new ItemEntity((World)world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                            itementity.func_174869_p();
                            if (world.func_217376_c((Entity)itementity)) {
                                tile.setOnlyItem(itementity);
                                break;
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block8;
            }
            world.func_175656_a(pos, (BlockState)state.func_177231_a((IProperty)AGE));
        }
    }

    @Nullable
    public FruitTreeTile findTile(ServerWorld world, BlockPos pos, BlockState state) {
        if (state.hasTileEntity()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof FruitTreeTile) {
                return (FruitTreeTile)tile;
            }
        } else {
            for (BlockPos pos2 : BlockPos.func_191531_b((int)(pos.func_177958_n() - 2), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)(pos.func_177956_o() + 3), (int)(pos.func_177952_p() + 2))) {
                TileEntity tile = world.func_175625_s(pos2);
                if (!(tile instanceof FruitTreeTile)) continue;
                return (FruitTreeTile)tile;
            }
        }
        return null;
    }

    public BlockState onPassiveGathered(ServerWorld world, BlockPos pos, BlockState state) {
        int death = 30;
        FruitTreeTile tile = this.findTile(world, pos, state);
        if (tile != null) {
            death = tile.updateDeathRate();
        }
        if (death >= 50 || !state.hasTileEntity() && world.field_73012_v.nextInt(50) < death) {
            return (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0));
        }
        return (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(1));
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_208495_b) != false && (Integer)state.func_177229_b((IProperty)field_208494_a) == 1;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FruitTreeTile(this.type.get());
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (this.shouldDecay(state)) {
            FruitLeavesBlock.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_217377_a(pos, false);
        } else if (this.canGrow(state) && world.isAreaLoaded(pos, 1) && world.func_201696_r(pos.func_177984_a()) >= 9) {
            boolean def;
            boolean bl = def = rand.nextInt(100) > 99 - FruitsConfig.growingSpeed;
            if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (boolean)def)) {
                this.func_225535_a_(world, rand, pos, state);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (((Boolean)(state = FruitLeavesBlock.func_208493_b((BlockState)state, (IWorld)world, (BlockPos)pos)).func_177229_b((IProperty)field_208495_b)).booleanValue() && (Integer)state.func_177229_b((IProperty)field_208494_a) != 1) {
            state = (BlockState)state.func_206870_a((IProperty)field_208495_b, (Comparable)Boolean.valueOf(false));
        }
        world.func_180501_a(pos, state, 3);
    }

    public boolean func_149653_t(BlockState state) {
        return this.shouldDecay(state) || this.canGrow(state) || (Integer)state.func_177229_b((IProperty)AGE) == 0;
    }

    public boolean shouldDecay(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_208494_a) == 7 && (Boolean)state.func_177229_b((IProperty)field_208495_b) == false;
    }

    public boolean canGrow(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) > 0 && (Boolean)state.func_177229_b((IProperty)field_208495_b) == false || (Integer)state.func_177229_b((IProperty)field_208494_a) == 1;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.canGrow(state) || (Integer)state.func_177229_b((IProperty)AGE) == 0) {
            return super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_208495_b, (Comparable)Boolean.valueOf(true));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Entity entity = context.getEntity();
        if (entity instanceof ItemEntity || entity instanceof IFlyingAnimal || entity == null && state.func_177230_c().getClass() == CherryLeavesBlock.class) {
            return VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        if (!worldIn.field_72995_K && fallDistance >= 1.0f && (entityIn instanceof LivingEntity || entityIn instanceof FallingBlockEntity)) {
            for (BlockPos pos2 : BlockPos.func_191531_b((int)(pos.func_177958_n() - 1), (int)Math.max(0, pos.func_177956_o() - 2), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 1))) {
                BlockState state = worldIn.func_180495_p(pos2);
                if (!(state.func_177230_c() instanceof FruitLeavesBlock)) continue;
                if ((Integer)state.func_177229_b((IProperty)AGE) == 3) {
                    ((FruitLeavesBlock)state.func_177230_c()).func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos2, state);
                }
                if (!(state.func_177230_c() instanceof CherryLeavesBlock)) continue;
                CarpetTreeDecorator.placeCarpet((IWorld)worldIn, pos2, ((CherryLeavesBlock)state.func_177230_c()).getCarpet().func_176223_P(), 3);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult ray) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 3 && worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(1)))) {
            if (!worldIn.field_72995_K) {
                ItemStack fruit = new ItemStack((IItemProvider)this.type.get().fruit);
                if (playerIn instanceof FakePlayer) {
                    double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                    ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, fruit);
                    itementity.func_174869_p();
                    worldIn.func_217376_c((Entity)itementity);
                } else {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)fruit);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity) {
        if (entity instanceof IFlyingAnimal) {
            return PathNodeType.OPEN;
        }
        return null;
    }
}

