/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.event;

import com.performant.coremod.Performant;
import com.performant.coremod.config.ConfigurationCache;
import java.util.Objects;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.fml.LogicalSide;

public class EventHandlerB {
    private static Random rand = new Random();
    public static int eventbus_id = 0;
    public static boolean eventbus_trackPhases = true;
    public static int[][] preWorldTickPause = new int[3][5];
    public static IEventListener[] preWorldlisteners;
    public static double livingEventMult;
    public static double tickEventMult;
    public static int[][] postWorldTickPause;
    public static IEventListener[] postWorldlisteners;
    public static int[][] preServerTickPause;
    public static IEventListener[] preServerlisteners;
    public static int[][] postServerTickPause;
    public static IEventListener[] postServerlisteners;

    public static void onPreWorldTick(World world) {
        TickEvent.WorldTickEvent event = new TickEvent.WorldTickEvent(LogicalSide.SERVER, TickEvent.Phase.START, world);
        preWorldlisteners = event.getListenerList().getListeners(eventbus_id);
        if (preWorldTickPause[0].length < preWorldlisteners.length) {
            preWorldTickPause = new int[3][preWorldlisteners.length];
        }
        EventHandlerB.post((Event)event, preWorldlisteners, preWorldTickPause, eventbus_trackPhases, tickEventMult, 1800000);
    }

    public static void onPostWorldTick(World world) {
        TickEvent.WorldTickEvent event = new TickEvent.WorldTickEvent(LogicalSide.SERVER, TickEvent.Phase.END, world);
        postWorldlisteners = event.getListenerList().getListeners(eventbus_id);
        if (postWorldTickPause[0].length < postWorldlisteners.length) {
            postWorldTickPause = new int[3][postWorldlisteners.length];
        }
        EventHandlerB.post((Event)event, postWorldlisteners, postWorldTickPause, eventbus_trackPhases, tickEventMult, 1800000);
    }

    public static void onPreServerTick() {
        TickEvent.ServerTickEvent event = new TickEvent.ServerTickEvent(TickEvent.Phase.START);
        preServerlisteners = event.getListenerList().getListeners(eventbus_id);
        if (preServerTickPause[0].length < preServerlisteners.length) {
            preServerTickPause = new int[3][preServerlisteners.length];
        }
        EventHandlerB.post((Event)event, preServerlisteners, preServerTickPause, eventbus_trackPhases, tickEventMult, 1800000);
    }

    public static void onPostServerTick() {
        TickEvent.ServerTickEvent event = new TickEvent.ServerTickEvent(TickEvent.Phase.END);
        postServerlisteners = event.getListenerList().getListeners(eventbus_id);
        if (postServerTickPause[0].length < postServerlisteners.length) {
            postServerTickPause = new int[3][postServerlisteners.length];
        }
        EventHandlerB.post((Event)event, postServerlisteners, postServerTickPause, eventbus_trackPhases, tickEventMult, 1800000);
    }

    public static boolean post(Event event, IEventListener[] listeners, int[][] pauseTicks, boolean trackPhases, double pauseModifier, int threshold) {
        long preTick = 0L;
        for (int index = 0; index < listeners.length; ++index) {
            if (!trackPhases && Objects.equals(listeners[index].getClass(), EventPriority.class)) continue;
            if (ConfigurationCache.eventLoadBalancing && (double)ConfigurationCache.meanTickEvent < ConfigurationCache.CURRENT_MEAN_TICK_TIME) {
                int pauseTime;
                int newAvg;
                int pause = pauseTicks[0][index];
                if (pause > 0) {
                    int[] nArray = pauseTicks[0];
                    int n = index;
                    nArray[n] = nArray[n] - 1;
                    continue;
                }
                preTick = System.nanoTime();
                listeners[index].invoke(event);
                preTick = System.nanoTime() - preTick;
                int[] nArray = pauseTicks[1];
                int n = index;
                nArray[n] = (int)((long)nArray[n] + preTick);
                pauseTicks[1][index] = newAvg = pauseTicks[1][index] >> 1;
                if (newAvg <= threshold || index <= 0) continue;
                pauseTicks[0][index] = pauseTime = (int)((double)newAvg * pauseModifier);
                if (pauseTime <= 2000 || !ConfigurationCache.eventDebugOutput) continue;
                Performant.LOGGER.warn(" Event:" + event.getClass().getSimpleName() + " is lagging because of listener:" + listeners[index] + " took " + newAvg + " ns! pausing:" + pauseTime);
                continue;
            }
            listeners[index].invoke(event);
        }
        return event.isCancelable() && event.isCanceled();
    }

    static {
        livingEventMult = 4.0E-4;
        tickEventMult = 3.846153846153846E-6;
        postWorldTickPause = new int[3][5];
        preServerTickPause = new int[3][5];
        postServerTickPause = new int[3][5];
    }
}

