/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.item;

import com.performant.coremod.Performant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    Map<Long, List<Object>> recipeCache = new HashMap<Long, List<Object>>();

    @Inject(method={"getRecipe(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public <C extends IInventory, T extends IRecipe<C>> Optional<T> OngetRecipe(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable<Optional> c) {
        List<Object> recipes = this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && !recipes.isEmpty() && recipes.get(0) != null) {
            c.setReturnValue(Optional.of((IRecipe)recipes.get(0)));
        }
        return null;
    }

    @Inject(method={"getRecipe(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/Optional;"}, at={@At(value="RETURN")})
    public <C extends IInventory, T extends IRecipe<C>> Optional<T> OnEndgetRecipe(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable<Optional<T>> c) {
        Optional val = (Optional)c.getReturnValue();
        if (val.isPresent() && ((Boolean)Performant.getConfig().getCommon().cacheRecipes.get()).booleanValue()) {
            long hash = this.calcHash(inventoryIn, recipeTypeIn);
            List<Object> list = this.recipeCache.get(hash);
            if (list == null) {
                list = new ArrayList<Object>();
                list.add(val.get());
                this.recipeCache.put(hash, list);
            } else if (!list.contains(val.get())) {
                list.add(val.get());
            }
        }
        return val;
    }

    @Inject(method={"getRecipes(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    public <C extends IInventory, T extends IRecipe<C>> List<T> OngetRecipes(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable c) {
        List<Object> recipes = this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && ((Boolean)Performant.getConfig().getCommon().cacheRecipes.get()).booleanValue()) {
            c.setReturnValue(new ArrayList<Object>(recipes));
        }
        return null;
    }

    @Inject(method={"getRecipes(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/List;"}, at={@At(value="RETURN")})
    public <C extends IInventory, T extends IRecipe<C>> List<T> OnEndgetRecipes(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable<List<T>> c) {
        List list = (List)c.getReturnValue();
        if (!list.isEmpty()) {
            long hash = this.calcHash(inventoryIn, recipeTypeIn);
            this.recipeCache.put(hash, new ArrayList(list));
        }
        return list;
    }

    private long calcHash(IInventory inventory, IRecipeType type) {
        long hash = type.hashCode();
        int size = inventory.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            hash = 31L * hash;
            if (stack == null || stack.func_190926_b()) continue;
            hash += (long)stack.func_77973_b().hashCode();
            hash = hash * 31L + (long)stack.func_77952_i();
            if (!stack.func_77942_o()) continue;
            hash = hash * 31L + (long)stack.func_77978_p().hashCode();
        }
        return hash;
    }
}

