/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.world;

import com.google.common.collect.Lists;
import com.performant.coremod.entity.ClassInheritanceMultiMapValues;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Region;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ChunkCache
extends Region
implements IWorldReader {
    protected int field_72818_a;
    protected int field_72816_b;
    protected Chunk[][] chunkArray;
    protected boolean field_72814_d;
    protected World field_72815_e;
    private Entity entity;
    private int invalidationCounter = 100;

    public ChunkCache(World worldIn, BlockPos posFromIn, BlockPos posToIn) {
        super(worldIn, BlockPos.field_177992_a, BlockPos.field_177992_a);
        this.field_72815_e = worldIn;
        this.field_72818_a = posFromIn.func_177958_n() >> 4;
        this.field_72816_b = posFromIn.func_177952_p() >> 4;
        int i = posToIn.func_177958_n() >> 4;
        int j = posToIn.func_177952_p() >> 4;
        this.chunkArray = new Chunk[i - this.field_72818_a + 1][j - this.field_72816_b + 1];
        this.field_72814_d = true;
        for (int k = this.field_72818_a; k <= i; ++k) {
            for (int l = this.field_72816_b; l <= j; ++l) {
                if (!worldIn.func_72863_F().func_222865_a(new ChunkPos(k, l))) continue;
                this.chunkArray[k - this.field_72818_a][l - this.field_72816_b] = (Chunk)worldIn.func_217353_a(k, l, ChunkStatus.field_222617_m, false);
            }
        }
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    private World getWorld() {
        if (this.entity != null) {
            return this.entity.field_70170_p;
        }
        return this.field_72815_e;
    }

    public boolean isRainingAt(BlockPos position) {
        if (!this.getWorld().func_72896_J()) {
            return false;
        }
        if (!this.func_226660_f_(position)) {
            return false;
        }
        if (this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        return this.getWorld().func_226691_t_(position).func_201851_b() == Biome.RainType.RAIN;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEmpty() {
        return this.field_72814_d;
    }

    @Nullable
    public TileEntity func_175625_s(@NotNull BlockPos pos) {
        return this.getTileEntity(pos, Chunk.CreateEntityType.CHECK);
    }

    public IBlockReader func_225522_c_(int i, int j) {
        if (!this.withinBounds(i -= this.field_72818_a, j -= this.field_72816_b)) {
            return null;
        }
        return this.chunkArray[i][j];
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos, Chunk.CreateEntityType createType) {
        int j;
        int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
        if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.field_72816_b)) {
            return null;
        }
        return this.chunkArray[i][j].func_177424_a(pos, createType);
    }

    @NotNull
    public BlockState func_180495_p(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
            int j = (pos.func_177952_p() >> 4) - this.field_72816_b;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.func_180495_p(pos);
            }
        } else {
            return Blocks.field_201940_ji.func_176223_P();
        }
        --this.invalidationCounter;
        if (this.entity != null && this.field_72815_e != this.entity.field_70170_p) {
            this.invalidationCounter = 0;
        }
        if (this.entity instanceof PlayerEntity) {
            return Blocks.field_196753_fW.func_176223_P();
        }
        return Blocks.field_150346_d.func_176223_P();
    }

    public IFluidState func_204610_c(BlockPos pos) {
        Chunk chunk;
        this.getWorld();
        if (World.func_189509_E((BlockPos)pos)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
        int j = (pos.func_177952_p() >> 4) - this.field_72816_b;
        if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
            return chunk.func_204610_c(pos);
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Biome func_226691_t_(BlockPos pos) {
        return Biomes.field_76772_c;
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return this.getWorld().func_225604_a_(x, y, z);
    }

    public boolean func_175623_d(BlockPos pos) {
        BlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockReader)this, pos);
    }

    @Nullable
    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        int i = x - this.field_72818_a;
        int j = z - this.field_72816_b;
        if (this.getWorld() == this.field_72815_e && i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length) {
            Chunk chunk = this.chunkArray[i][j];
            if (chunk != null) {
                return chunk;
            }
            IChunk missing = this.getWorld().func_72863_F().func_212849_a_(x, z, requiredStatus, nonnull);
            if (missing instanceof Chunk) {
                this.chunkArray[i][j] = (Chunk)missing;
            }
            return missing;
        }
        return this.getWorld().func_72863_F().func_212849_a_(x, z, requiredStatus, nonnull);
    }

    public boolean func_217354_b(int chunkX, int chunkZ) {
        Chunk chunk;
        int i = chunkX - this.field_72818_a;
        int j = chunkZ - this.field_72816_b;
        return i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        int i = x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000 ? (this.func_217354_b(x >> 4, z >> 4) ? this.func_212866_a_(x >> 4, z >> 4).func_201576_a(heightmapType, x & 0xF, z & 0xF) + 1 : 0) : this.func_181545_F() + 1;
        return i;
    }

    public int func_175657_ab() {
        return this.field_72815_e.func_175657_ab();
    }

    public BiomeManager func_225523_d_() {
        return this.getWorld().func_225523_d_();
    }

    public WorldBorder func_175723_af() {
        return null;
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return false;
    }

    public int func_175627_a(BlockPos pos, Direction direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockReader)this, pos, direction);
    }

    public boolean func_201670_d() {
        return this.getWorld().field_72995_K;
    }

    public int func_181545_F() {
        return this.getWorld().func_181545_F();
    }

    public Dimension func_201675_m() {
        return this.getWorld().func_201675_m();
    }

    private boolean withinBounds(int x, int z) {
        return x >= 0 && x < this.chunkArray.length && z >= 0 && z < this.chunkArray[x].length && this.chunkArray[x][z] != null;
    }

    public WorldLightManager func_225524_e_() {
        return this.getWorld().func_225524_e_();
    }

    public boolean isFlammableWithin(AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        boolean flag;
                        BlockState state = this.func_180495_p((BlockPos)blockpos$pooledmutable.func_181079_c(k1, l1, i2));
                        if (!state.isBurning((IBlockReader)this, (BlockPos)blockpos$pooledmutable)) continue;
                        boolean bl = flag = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public synchronized List<Entity> getEntitiesInAABBexcluding(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        double maxEntityRadius = this.getWorld().getMaxEntityRadius();
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)((boundingBox.field_72340_a - maxEntityRadius) / 16.0));
        int j = MathHelper.func_76128_c((double)((boundingBox.field_72336_d + maxEntityRadius) / 16.0));
        int k = MathHelper.func_76128_c((double)((boundingBox.field_72339_c - maxEntityRadius) / 16.0));
        int l = MathHelper.func_76128_c((double)((boundingBox.field_72334_f + maxEntityRadius) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                int relativeX = i1 - this.field_72818_a;
                int relativeZ = j1 - this.field_72816_b;
                Chunk chunk = null;
                if (relativeX >= 0 && relativeX < this.chunkArray.length && relativeZ >= 0 && relativeZ < this.chunkArray[relativeX].length) {
                    chunk = this.chunkArray[relativeX][relativeZ];
                }
                if (chunk == null) continue;
                int minY = MathHelper.func_76128_c((double)((boundingBox.field_72338_b - this.getWorld().getMaxEntityRadius()) / 16.0));
                int maxY = MathHelper.func_76128_c((double)((boundingBox.field_72337_e + this.getWorld().getMaxEntityRadius()) / 16.0));
                minY = MathHelper.func_76125_a((int)minY, (int)0, (int)(chunk.func_177429_s().length - 1));
                maxY = MathHelper.func_76125_a((int)maxY, (int)0, (int)(chunk.func_177429_s().length - 1));
                for (int section = minY; section <= maxY; ++section) {
                    if (chunk.func_177429_s()[section].isEmpty()) continue;
                    if (chunk.func_177429_s()[section] instanceof ClassInheritanceMultiMapValues) {
                        List entities = ((ClassInheritanceMultiMapValues)chunk.func_177429_s()[section]).getValues();
                        for (int e = 0; e < entities.size() && entities.size() > e; ++e) {
                            Entity entity = (Entity)entities.get(e);
                            if (entity == null || !entity.func_174813_aQ().func_72326_a(boundingBox) || entity == entityIn) continue;
                            if (predicate == null || predicate.test((Entity)entity)) {
                                list.add(entity);
                            }
                            if (!(entity instanceof EnderDragonEntity)) continue;
                            EnderDragonPartEntity[] enderDragonPartEntityArray = ((EnderDragonEntity)entity).func_213404_dT();
                            int n = enderDragonPartEntityArray.length;
                            for (int i2 = 0; i2 < n; ++i2) {
                                EnderDragonPartEntity enderdragonpartentity = enderDragonPartEntityArray[i2];
                                if (enderdragonpartentity == entityIn || !enderdragonpartentity.func_174813_aQ().func_72326_a(boundingBox) || predicate != null && !predicate.test((Entity)enderdragonpartentity)) continue;
                                list.add(enderdragonpartentity);
                            }
                        }
                        continue;
                    }
                    for (Entity entity : chunk.func_177429_s()[section]) {
                        if (entity == null || !entity.func_174813_aQ().func_72326_a(boundingBox) || entity == entityIn) continue;
                        if (predicate == null || predicate.test((Entity)entity)) {
                            list.add(entity);
                        }
                        if (!(entity instanceof EnderDragonEntity)) continue;
                        for (EnderDragonPartEntity enderdragonpartentity : ((EnderDragonEntity)entity).func_213404_dT()) {
                            if (enderdragonpartentity == entityIn || !enderdragonpartentity.func_174813_aQ().func_72326_a(boundingBox) || predicate != null && !predicate.test((Entity)enderdragonpartentity)) continue;
                            list.add(enderdragonpartentity);
                        }
                    }
                }
            }
        }
        return list;
    }

    public boolean isValid() {
        return this.invalidationCounter > 0;
    }
}

