/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.NetworkFactory;
import com.refinedmods.refinedpipes.network.NetworkRegistry;
import com.refinedmods.refinedpipes.network.graph.NetworkGraphScannerResult;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.PipeFactory;
import com.refinedmods.refinedpipes.network.pipe.PipeRegistry;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipe;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkManager
extends WorldSavedData {
    private static final String NAME = "refinedpipes_networks";
    private static final Logger LOGGER = LogManager.getLogger(NetworkManager.class);
    private final World world;
    private final Map<String, Network> networks = new HashMap<String, Network>();
    private final Map<BlockPos, Pipe> pipes = new HashMap<BlockPos, Pipe>();

    public static NetworkManager get(World world) {
        return NetworkManager.get((ServerWorld)world);
    }

    public static NetworkManager get(ServerWorld world) {
        String name = "refinedpipes_networks_" + world.func_201675_m().func_186058_p().getRegistryName().func_110624_b() + "_" + world.func_201675_m().func_186058_p().getRegistryName().func_110623_a();
        return (NetworkManager)world.func_217481_x().func_215752_a(() -> new NetworkManager(name, (World)world), name);
    }

    public NetworkManager(String name, World world) {
        super(name);
        this.world = world;
    }

    public void addNetwork(Network network) {
        if (this.networks.containsKey(network.getId())) {
            throw new RuntimeException("Duplicate network " + network.getId());
        }
        this.networks.put(network.getId(), network);
        LOGGER.debug("Network {} created", (Object)network.getId());
        this.func_76185_a();
    }

    public void removeNetwork(String id) {
        if (!this.networks.containsKey(id)) {
            throw new RuntimeException("Network " + id + " not found");
        }
        this.networks.remove(id);
        LOGGER.debug("Network {} removed", (Object)id);
        this.func_76185_a();
    }

    private void formNetworkAt(World world, BlockPos pos, ResourceLocation type) {
        Network network = NetworkRegistry.INSTANCE.getFactory(type).create(pos);
        this.addNetwork(network);
        network.scanGraph(world, pos);
    }

    private void mergeNetworksIntoOne(Set<Pipe> candidates, World world, BlockPos pos) {
        if (candidates.isEmpty()) {
            throw new RuntimeException("Cannot merge networks: no candidates");
        }
        HashSet<Network> networkCandidates = new HashSet<Network>();
        for (Pipe candidate : candidates) {
            if (candidate.getNetwork() == null) {
                throw new RuntimeException("Pipe network is null!");
            }
            networkCandidates.add(candidate.getNetwork());
        }
        Iterator networks = networkCandidates.iterator();
        Network mainNetwork = (Network)networks.next();
        HashSet<Network> mergedNetworks = new HashSet<Network>();
        while (networks.hasNext()) {
            Network otherNetwork = (Network)networks.next();
            boolean canMerge = mainNetwork.getType().equals((Object)otherNetwork.getType());
            if (!canMerge) continue;
            mergedNetworks.add(otherNetwork);
            this.removeNetwork(otherNetwork.getId());
        }
        mainNetwork.scanGraph(world, pos);
        mergedNetworks.forEach(n -> n.onMergedWith(mainNetwork));
    }

    public void addPipe(Pipe pipe) {
        if (this.pipes.containsKey(pipe.getPos())) {
            throw new RuntimeException("Pipe at " + pipe.getPos() + " already exists");
        }
        this.pipes.put(pipe.getPos(), pipe);
        LOGGER.debug("Pipe added at {}", (Object)pipe.getPos());
        this.func_76185_a();
        Set<Pipe> adjacentPipes = this.findAdjacentPipes(pipe.getPos(), pipe.getNetworkType());
        if (adjacentPipes.isEmpty()) {
            this.formNetworkAt(pipe.getWorld(), pipe.getPos(), pipe.getNetworkType());
        } else {
            this.mergeNetworksIntoOne(adjacentPipes, pipe.getWorld(), pipe.getPos());
        }
    }

    public void removePipe(BlockPos pos) {
        Pipe pipe = this.getPipe(pos);
        if (pipe == null) {
            throw new RuntimeException("Pipe at " + pos + " was not found");
        }
        if (pipe.getNetwork() == null) {
            LOGGER.warn("Removed pipe at {} has no associated network", (Object)pipe.getPos());
        }
        this.pipes.remove(pipe.getPos());
        LOGGER.debug("Pipe removed at {}", (Object)pipe.getPos());
        this.func_76185_a();
        if (pipe.getNetwork() != null) {
            this.splitNetworks(pipe);
        }
    }

    private void splitNetworks(Pipe originPipe) {
        for (Pipe adjacent : this.findAdjacentPipes(originPipe.getPos(), originPipe.getNetworkType())) {
            if (adjacent.getNetwork() == null) {
                throw new RuntimeException("Adjacent pipe has no network");
            }
            if (originPipe.getNetwork() == originPipe.getNetwork()) continue;
            throw new RuntimeException("The origin pipe network is different than the adjacent pipe network");
        }
        Pipe otherPipeInNetwork = this.findFirstAdjacentPipe(originPipe.getPos(), originPipe.getNetworkType());
        if (otherPipeInNetwork != null) {
            otherPipeInNetwork.getNetwork().setOriginPos(otherPipeInNetwork.getPos());
            this.func_76185_a();
            NetworkGraphScannerResult result = otherPipeInNetwork.getNetwork().scanGraph(otherPipeInNetwork.getWorld(), otherPipeInNetwork.getPos());
            boolean foundRemovedPipe = false;
            for (Pipe removed : result.getRemovedPipes()) {
                if (removed.getPos().equals((Object)originPipe.getPos())) {
                    foundRemovedPipe = true;
                    continue;
                }
                if (removed.getNetwork() != null) continue;
                this.formNetworkAt(removed.getWorld(), removed.getPos(), removed.getNetworkType());
            }
            if (!foundRemovedPipe) {
                throw new RuntimeException("Didn't find removed pipe when splitting network");
            }
        } else {
            LOGGER.debug("Removing empty network {}", (Object)originPipe.getNetwork().getId());
            this.removeNetwork(originPipe.getNetwork().getId());
        }
    }

    private Set<Pipe> findAdjacentPipes(BlockPos pos, ResourceLocation networkType) {
        HashSet<Pipe> pipes = new HashSet<Pipe>();
        for (Direction dir : Direction.values()) {
            Pipe pipe = this.getPipe(pos.func_177972_a(dir));
            if (pipe == null || !pipe.getNetworkType().equals((Object)networkType)) continue;
            pipes.add(pipe);
        }
        return pipes;
    }

    @Nullable
    private Pipe findFirstAdjacentPipe(BlockPos pos, ResourceLocation networkType) {
        for (Direction dir : Direction.values()) {
            Pipe pipe = this.getPipe(pos.func_177972_a(dir));
            if (pipe == null || !pipe.getNetworkType().equals((Object)networkType)) continue;
            return pipe;
        }
        return null;
    }

    @Nullable
    public Pipe getPipe(BlockPos pos) {
        return this.pipes.get(pos);
    }

    public Collection<Network> getNetworks() {
        return this.networks.values();
    }

    public void func_76184_a(CompoundNBT tag) {
        ListNBT pipes = tag.func_150295_c("pipes", 10);
        for (INBT pipeTag : pipes) {
            CompoundNBT pipeTagCompound = (CompoundNBT)pipeTag;
            ResourceLocation factoryId = pipeTagCompound.func_74764_b("id") ? new ResourceLocation(pipeTagCompound.func_74779_i("id")) : ItemPipe.ID;
            PipeFactory factory = PipeRegistry.INSTANCE.getFactory(factoryId);
            if (factory == null) {
                LOGGER.warn("Pipe {} no longer exists", (Object)factoryId.toString());
                continue;
            }
            Pipe pipe = factory.createFromNbt(this.world, pipeTagCompound);
            this.pipes.put(pipe.getPos(), pipe);
        }
        ListNBT nets = tag.func_150295_c("networks", 10);
        for (INBT netTag : nets) {
            CompoundNBT netTagCompound = (CompoundNBT)netTag;
            if (!netTagCompound.func_74764_b("type")) {
                LOGGER.warn("Skipping network without type");
                continue;
            }
            ResourceLocation type = new ResourceLocation(netTagCompound.func_74779_i("type"));
            NetworkFactory factory = NetworkRegistry.INSTANCE.getFactory(type);
            if (factory == null) {
                LOGGER.warn("Unknown network type {}", (Object)type.toString());
                continue;
            }
            Network network = factory.create(netTagCompound);
            this.networks.put(network.getId(), network);
        }
        LOGGER.debug("Read {} pipes", (Object)pipes.size());
        LOGGER.debug("Read {} networks", (Object)this.networks.size());
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        ListNBT pipes = new ListNBT();
        this.pipes.values().forEach(p -> {
            CompoundNBT pipeTag = new CompoundNBT();
            pipeTag.func_74778_a("id", p.getId().toString());
            pipes.add((Object)p.writeToNbt(pipeTag));
        });
        tag.func_218657_a("pipes", (INBT)pipes);
        ListNBT networks = new ListNBT();
        this.networks.values().forEach(n -> {
            CompoundNBT networkTag = new CompoundNBT();
            networkTag.func_74778_a("type", n.getType().toString());
            networks.add((Object)n.writeToNbt(networkTag));
        });
        tag.func_218657_a("networks", (INBT)networks);
        return tag;
    }
}

