/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.attachment;

import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentManager;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerAttachmentManager
implements AttachmentManager {
    private static final Logger LOGGER = LogManager.getLogger(ServerAttachmentManager.class);
    private final Map<Direction, Attachment> attachments = new HashMap<Direction, Attachment>();
    private final ResourceLocation[] attachmentState = new ResourceLocation[Direction.values().length];
    private final Pipe pipe;

    public ServerAttachmentManager(Pipe pipe) {
        this.pipe = pipe;
    }

    @Override
    public boolean hasAttachment(Direction dir) {
        return this.attachments.containsKey(dir);
    }

    @Override
    public void openAttachmentContainer(Direction dir, ServerPlayerEntity player) {
        if (this.hasAttachment(dir)) {
            this.getAttachment(dir).openContainer(player);
        }
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(Direction dir) {
        throw new RuntimeException("Shouldn't be called on the server");
    }

    public void removeAttachmentAndScanGraph(Direction dir) {
        this.attachments.remove(dir);
        this.attachmentState[dir.ordinal()] = null;
        this.pipe.getNetwork().scanGraph(this.pipe.getWorld(), this.pipe.getPos());
    }

    public void setAttachmentAndScanGraph(Direction dir, Attachment attachment) {
        this.setAttachment(dir, attachment);
        this.pipe.getNetwork().scanGraph(this.pipe.getWorld(), this.pipe.getPos());
    }

    private void setAttachment(Direction dir, Attachment attachment) {
        this.attachments.put(dir, attachment);
        this.attachmentState[dir.ordinal()] = attachment.getId();
    }

    @Override
    @Nullable
    public Attachment getAttachment(Direction dir) {
        return this.attachments.get(dir);
    }

    public Collection<Attachment> getAttachments() {
        return this.attachments.values();
    }

    public CompoundNBT writeToNbt(CompoundNBT tag) {
        ListNBT attch = new ListNBT();
        this.getAttachments().forEach(a -> {
            CompoundNBT attchTag = new CompoundNBT();
            attchTag.func_74778_a("typ", a.getId().toString());
            attch.add((Object)a.writeToNbt(attchTag));
        });
        tag.func_218657_a("attch", (INBT)attch);
        return tag;
    }

    public void readFromNbt(CompoundNBT tag) {
        ListNBT attch = tag.func_150295_c("attch", 10);
        for (INBT item : attch) {
            CompoundNBT attchTag = (CompoundNBT)item;
            AttachmentFactory factory = AttachmentRegistry.INSTANCE.getFactory(new ResourceLocation(attchTag.func_74779_i("typ")));
            if (factory != null) {
                Attachment attachment = factory.createFromNbt(this.pipe, attchTag);
                this.setAttachment(attachment.getDirection(), attachment);
                continue;
            }
            LOGGER.warn("Attachment {} no longer exists", (Object)attchTag.func_74779_i("typ"));
        }
    }

    @Override
    public ResourceLocation[] getState() {
        return this.attachmentState;
    }

    @Override
    public void writeUpdate(CompoundNBT tag) {
        for (Direction dir : Direction.values()) {
            if (!this.hasAttachment(dir)) continue;
            tag.func_74778_a("attch_" + dir.ordinal(), this.getAttachment(dir).getId().toString());
            tag.func_218657_a("pb_" + dir.ordinal(), (INBT)this.getAttachment(dir).getDrop().func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        throw new RuntimeException("Client-side only");
    }
}

