/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.attachment.extractor;

import com.refinedmods.refinedpipes.block.FluidPipeBlock;
import com.refinedmods.refinedpipes.block.ItemPipeBlock;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.refinedmods.refinedpipes.util.DirectionUtil;
import com.refinedmods.refinedpipes.util.StringUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtractorAttachmentFactory
implements AttachmentFactory {
    private final ExtractorAttachmentType type;

    public ExtractorAttachmentFactory(ExtractorAttachmentType type) {
        this.type = type;
    }

    @Override
    public Attachment createFromNbt(Pipe pipe, CompoundNBT tag) {
        Direction dir = DirectionUtil.safeGet((byte)tag.func_74762_e("dir"));
        ExtractorAttachment attachment = new ExtractorAttachment(pipe, dir, this.type);
        if (tag.func_74764_b("itemfilter")) {
            attachment.getItemFilter().deserializeNBT(tag.func_74775_l("itemfilter"));
        }
        if (tag.func_74764_b("rm")) {
            attachment.setRedstoneMode(RedstoneMode.get(tag.func_74771_c("rm")));
        }
        if (tag.func_74764_b("bw")) {
            attachment.setBlacklistWhitelist(BlacklistWhitelist.get(tag.func_74771_c("bw")));
        }
        if (tag.func_74764_b("rr")) {
            attachment.setRoundRobinIndex(tag.func_74762_e("rr"));
        }
        if (tag.func_74764_b("routingm")) {
            attachment.setRoutingMode(RoutingMode.get(tag.func_74771_c("routingm")));
        }
        if (tag.func_74764_b("stacksi")) {
            attachment.setStackSize(tag.func_74762_e("stacksi"));
        }
        if (tag.func_74764_b("exa")) {
            attachment.setExactMode(tag.func_74767_n("exa"));
        }
        if (tag.func_74764_b("fluidfilter")) {
            attachment.getFluidFilter().readFromNbt(tag.func_74775_l("fluidfilter"));
        }
        return attachment;
    }

    @Override
    public Attachment create(Pipe pipe, Direction dir) {
        return new ExtractorAttachment(pipe, dir, this.type);
    }

    @Override
    public ResourceLocation getItemId() {
        return this.type.getItemId();
    }

    @Override
    public ResourceLocation getId() {
        return this.type.getId();
    }

    @Override
    public ResourceLocation getModelLocation() {
        return this.type.getModelLocation();
    }

    @Override
    public void addInformation(List<ITextComponent> tooltip) {
        tooltip.add(new TranslationTextComponent("misc.refinedpipes.tier", new Object[]{new TranslationTextComponent("enchantment.level." + this.type.getTier(), new Object[0])}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        ITextComponent itemsToExtract = new StringTextComponent(StringUtil.formatNumber(this.type.getItemsToExtract()) + " ").func_150257_a((ITextComponent)new TranslationTextComponent("misc.refinedpipes.item" + (this.type.getItemsToExtract() == 1 ? "" : "s"), new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
        float itemSecondsInterval = (float)this.type.getItemTickInterval() / 20.0f;
        ITextComponent itemTickInterval = new StringTextComponent(StringUtil.formatNumber(itemSecondsInterval) + " ").func_150257_a((ITextComponent)new TranslationTextComponent("misc.refinedpipes.second" + (itemSecondsInterval == 1.0f ? "" : "s"), new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
        tooltip.add(new TranslationTextComponent("tooltip.refinedpipes.extractor_attachment.item_extraction_rate", new Object[]{itemsToExtract, itemTickInterval}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        ITextComponent fluidsToExtract = new StringTextComponent(StringUtil.formatNumber(this.type.getFluidsToExtract()) + " mB").func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
        float fluidSecondsInterval = (float)this.type.getFluidTickInterval() / 20.0f;
        ITextComponent fluidTickInterval = new StringTextComponent(StringUtil.formatNumber(fluidSecondsInterval) + " ").func_150257_a((ITextComponent)new TranslationTextComponent("misc.refinedpipes.second" + (fluidSecondsInterval == 1.0f ? "" : "s"), new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
        tooltip.add(new TranslationTextComponent("tooltip.refinedpipes.extractor_attachment.fluid_extraction_rate", new Object[]{fluidsToExtract, fluidTickInterval}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        tooltip.add(new TranslationTextComponent("tooltip.refinedpipes.extractor_attachment.filter_slots", new Object[]{new StringTextComponent("" + this.type.getFilterSlots()).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE))}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        this.addAbilityToInformation(tooltip, this.type.getCanSetRedstoneMode(), "misc.refinedpipes.redstone_mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetWhitelistBlacklist(), "misc.refinedpipes.mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetRoutingMode(), "misc.refinedpipes.routing_mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetExactMode(), "misc.refinedpipes.exact_mode");
    }

    private void addAbilityToInformation(List<ITextComponent> tooltip, boolean possible, String key) {
        tooltip.add(new StringTextComponent(possible ? "\u2713 " : "\u274c ").func_150257_a((ITextComponent)new TranslationTextComponent(key, new Object[0])).func_150255_a(new Style().func_150238_a(possible ? TextFormatting.GREEN : TextFormatting.RED)));
    }

    @Override
    public boolean canPlaceOnPipe(Block pipe) {
        return pipe instanceof ItemPipeBlock || pipe instanceof FluidPipeBlock;
    }
}

